/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc.messages;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.remote.rpc.messages.AbstractExecute;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataOutput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeStreamVersion;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

public final class ExecuteAction
extends AbstractExecute<SchemaNodeIdentifier.Absolute, ContainerNode> {
    private static final long serialVersionUID = 1128904894827335676L;
    private final @NonNull DOMDataTreeIdentifier path;

    private ExecuteAction(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull SchemaNodeIdentifier.Absolute type, @NonNull DOMDataTreeIdentifier path, @NonNull ContainerNode input) {
        super(type, Objects.requireNonNull(input));
        this.path = Objects.requireNonNull(path);
    }

    public static @NonNull ExecuteAction from(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull SchemaNodeIdentifier.Absolute type, @NonNull DOMDataTreeIdentifier path, @NonNull ContainerNode input) {
        return new ExecuteAction(type, path, input);
    }

    public @NonNull DOMDataTreeIdentifier getPath() {
        return this.path;
    }

    @Override
    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return super.addToStringAttributes(helper.add("path", (Object)this.path));
    }

    @Override
    Object writeReplace() {
        return new Proxy(this);
    }

    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ExecuteAction executeAction;

        public Proxy() {
        }

        Proxy(ExecuteAction executeAction) {
            this.executeAction = Objects.requireNonNull(executeAction);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            try (NormalizedNodeDataOutput stream = NormalizedNodeStreamVersion.current().newDataOutput((DataOutput)out);){
                stream.writeSchemaNodeIdentifier((SchemaNodeIdentifier)this.executeAction.getType());
                this.executeAction.getPath().getDatastoreType().writeTo((DataOutput)out);
                stream.writeYangInstanceIdentifier(this.executeAction.getPath().getRootIdentifier());
                stream.writeOptionalNormalizedNode(this.executeAction.getInput());
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            NormalizedNodeDataInput stream = NormalizedNodeDataInput.newDataInput((DataInput)in);
            SchemaNodeIdentifier sni = stream.readSchemaNodeIdentifier();
            if (!(sni instanceof SchemaNodeIdentifier.Absolute)) {
                throw new InvalidObjectException("Non-absolute type " + sni);
            }
            SchemaNodeIdentifier.Absolute absolute = (SchemaNodeIdentifier.Absolute)sni;
            LogicalDatastoreType type = LogicalDatastoreType.readFrom((DataInput)in);
            YangInstanceIdentifier path = stream.readYangInstanceIdentifier();
            ContainerNode input = stream.readOptionalNormalizedNode().orElse(null);
            this.executeAction = new ExecuteAction(absolute, new DOMDataTreeIdentifier(type, path), input);
        }

        private Object readResolve() {
            return Verify.verifyNotNull((Object)this.executeAction);
        }
    }
}

