/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc.registry.mbeans;

import akka.actor.Address;
import akka.util.Timeout;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.md.sal.common.util.jmx.AbstractMXBean;
import org.opendaylight.controller.remote.rpc.registry.AbstractRoutingTable;
import org.opendaylight.controller.remote.rpc.registry.gossip.Bucket;
import org.opendaylight.controller.remote.rpc.registry.gossip.BucketStoreAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Await;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

abstract class AbstractRegistryMXBean<T extends AbstractRoutingTable<T, I>, I>
extends AbstractMXBean {
    static final String LOCAL_CONSTANT = "local";
    static final String ROUTE_CONSTANT = "route:";
    static final String NAME_CONSTANT = " | name:";
    @SuppressFBWarnings(value={"SLF4J_LOGGER_SHOULD_BE_PRIVATE"})
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final BucketStoreAccess bucketAccess;
    private final FiniteDuration timeout;

    @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"}, justification="registerMBean() is expected to be stateless")
    AbstractRegistryMXBean(@NonNull String beanName, @NonNull String beanType, @NonNull BucketStoreAccess bucketAccess, @NonNull Timeout timeout) {
        super(beanName, beanType, null);
        this.bucketAccess = Objects.requireNonNull(bucketAccess);
        this.timeout = timeout.duration();
        this.registerMBean();
    }

    final T localData() {
        try {
            return (T)((AbstractRoutingTable)Await.result(this.bucketAccess.getLocalData(), (Duration)this.timeout));
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IllegalStateException("getLocalData failed", e);
        }
    }

    final Map<Address, Bucket<T>> remoteBuckets() {
        try {
            return (Map)Await.result(this.bucketAccess.getRemoteBuckets(), (Duration)this.timeout);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IllegalStateException("getRemoteBuckets failed", e);
        }
    }

    final String bucketVersions() {
        try {
            return Await.result(this.bucketAccess.getBucketVersions(), (Duration)this.timeout).toString();
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IllegalStateException("getVersions failed", e);
        }
    }
}

