/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.api.CommonDataObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.IncorrectNestingException;
import org.opendaylight.mdsal.binding.dom.codec.impl.ChoiceCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContextSupplier;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecDataObjectAnalysis;
import org.opendaylight.mdsal.binding.dom.codec.impl.CommonDataObjectCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CommonDataObjectCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueNodeCodecContext;
import org.opendaylight.mdsal.binding.runtime.api.CompositeRuntimeType;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractDataObjectCodecContext<D extends DataObject, T extends CompositeRuntimeType>
extends CommonDataObjectCodecContext<D, T> {
    private final ImmutableMap<Class<?>, CommonDataObjectCodecPrototype<?>> byBindingArgClass;
    private final ImmutableMap<Class<?>, CommonDataObjectCodecPrototype<?>> byStreamClass;
    private final ImmutableMap<YangInstanceIdentifier.NodeIdentifier, CodecContextSupplier> byYang;
    private final ImmutableMap<String, ValueNodeCodecContext> leafChild;
    private final MethodHandle proxyConstructor;

    AbstractDataObjectCodecContext(CommonDataObjectCodecPrototype<T> prototype, CodecDataObjectAnalysis<T> analysis) {
        super(prototype);
        this.byBindingArgClass = analysis.byBindingArgClass;
        this.byStreamClass = analysis.byStreamClass;
        this.byYang = analysis.byYang;
        this.leafChild = analysis.leafNodes;
        this.proxyConstructor = analysis.proxyConstructor;
    }

    public final DocumentedNode.WithStatus getSchema() {
        return (DocumentedNode.WithStatus)((CompositeRuntimeType)this.type()).statement();
    }

    @Override
    public final <C extends DataObject> CommonDataObjectCodecContext<C, ?> getStreamChild(Class<C> childClass) {
        return (CommonDataObjectCodecContext)this.childNonNull(this.streamChild((Class)childClass), childClass, "Child %s is not valid child of %s", this.getBindingClass(), childClass);
    }

    @Override
    public final <C extends DataObject> CommonDataObjectCodecContext<C, ?> streamChild(Class<C> childClass) {
        CommonDataObjectCodecPrototype<C> childProto = this.streamChildPrototype(childClass);
        return childProto == null ? null : childProto.get();
    }

    @Nullable CommonDataObjectCodecPrototype<?> streamChildPrototype(@NonNull Class<?> childClass) {
        return (CommonDataObjectCodecPrototype)this.byStreamClass.get(childClass);
    }

    @Override
    public final CommonDataObjectCodecContext<?, ?> bindingPathArgumentChild(InstanceIdentifier.PathArgument arg, List<YangInstanceIdentifier.PathArgument> builder) {
        Class argType = arg.getType();
        CodecContext context = this.childNonNull(this.pathChildPrototype(argType), argType, "Class %s is not valid child of %s", argType, this.getBindingClass()).get();
        if (context instanceof ChoiceCodecContext) {
            ChoiceCodecContext choice = (ChoiceCodecContext)context;
            choice.addYangPathArgument(arg, builder);
            Optional caseType = arg.getCaseType();
            Class type = arg.getType();
            CommonDataObjectCodecTreeNode caze = caseType.isPresent() ? choice.getStreamChild((Class)caseType.orElseThrow()) : choice.getCaseByChildClass(type);
            caze.addYangPathArgument(arg, builder);
            return caze.bindingPathArgumentChild(arg, (List)builder);
        }
        ((DataContainerCodecContext)context).addYangPathArgument(arg, builder);
        return context;
    }

    @Nullable CommonDataObjectCodecPrototype<?> pathChildPrototype(@NonNull Class<? extends DataObject> argType) {
        return (CommonDataObjectCodecPrototype)this.byBindingArgClass.get(argType);
    }

    @Override
    public final CodecContext yangPathArgumentChild(YangInstanceIdentifier.PathArgument arg) {
        CodecContextSupplier supplier;
        if (arg instanceof YangInstanceIdentifier.NodeIdentifier) {
            YangInstanceIdentifier.NodeIdentifier nodeId = (YangInstanceIdentifier.NodeIdentifier)arg;
            supplier = this.yangChildSupplier(nodeId);
        } else if (arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            YangInstanceIdentifier.NodeIdentifierWithPredicates nip = (YangInstanceIdentifier.NodeIdentifierWithPredicates)arg;
            supplier = this.yangChildSupplier(new YangInstanceIdentifier.NodeIdentifier(nip.getNodeType()));
        } else {
            supplier = null;
        }
        return this.childNonNull(supplier, arg, "Argument %s is not valid child of %s", arg, this.getSchema()).get();
    }

    @Nullable CodecContextSupplier yangChildSupplier(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier arg) {
        return (CodecContextSupplier)this.byYang.get((Object)arg);
    }

    final @NonNull D createBindingProxy(DataContainerNode node) {
        try {
            return (D)this.proxyConstructor.invokeExact(this, node);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    final ValueNodeCodecContext getLeafChild(String name) {
        ValueNodeCodecContext value = (ValueNodeCodecContext)this.leafChild.get((Object)name);
        if (value == null) {
            throw new IncorrectNestingException("Leaf %s is not valid for %s", new Object[]{name, this.getBindingClass()});
        }
        return value;
    }

    final @NonNull ImmutableSet<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.NodeIdentifier> byYangKeySet() {
        return this.byYang.keySet();
    }

    abstract @NonNull Map<Class<? extends Augmentation<?>>, Augmentation<?>> getAllAugmentationsFrom(DataContainerNode var1);
}

