/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.xml.transform.dom.DOMSource;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingOpaqueObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.impl.AbstractValueCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecOpaqueObject;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecPackage;
import org.opendaylight.mdsal.binding.dom.codec.impl.ForeignOpaqueData;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueNodeCodecContext;
import org.opendaylight.mdsal.binding.loader.BindingClassLoader;
import org.opendaylight.yangtools.yang.binding.OpaqueData;
import org.opendaylight.yangtools.yang.binding.OpaqueObject;
import org.opendaylight.yangtools.yang.data.api.schema.ForeignDataNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractOpaqueCodecContext<T extends OpaqueObject<T>>
extends ValueNodeCodecContext
implements BindingOpaqueObjectCodecTreeNode<T> {
    private static final MethodType CTOR_LOOKUP_TYPE = MethodType.methodType(Void.TYPE, OpaqueData.class);
    private static final MethodType CTOR_INVOKE_TYPE = MethodType.methodType(OpaqueObject.class, OpaqueData.class);
    private static final DynamicType.Builder<CodecOpaqueObject> TEMPLATE = new ByteBuddy().subclass(CodecOpaqueObject.class).modifiers(4113);
    private final AbstractValueCodec<Object, Object> valueCodec = new AbstractValueCodec<Object, Object>(){

        @Override
        protected Object serializeImpl(Object input) {
            Preconditions.checkArgument((boolean)AbstractOpaqueCodecContext.this.bindingClass.isInstance(input), (String)"Unexpected input %s", (Object)input);
            OpaqueData opaqueData = (OpaqueData)((OpaqueObject)AbstractOpaqueCodecContext.this.bindingClass.cast(input)).getValue();
            Object data = opaqueData.getData();
            Preconditions.checkArgument((boolean)(data instanceof DOMSource), (String)"Unexpected data %s", (Object)data);
            return data;
        }

        @Override
        protected Object deserializeImpl(Object input) {
            Preconditions.checkArgument((boolean)(input instanceof NormalizedNode), (String)"Unexpected input %s", (Object)input);
            return AbstractOpaqueCodecContext.this.deserializeObject((NormalizedNode)input);
        }
    };
    private final MethodHandle proxyConstructor;
    private final @NonNull Class<T> bindingClass;

    AbstractOpaqueCodecContext(DataSchemaNode schema, String getterName, Class<T> bindingClass, BindingClassLoader loader) {
        super(schema, getterName, null);
        this.bindingClass = Objects.requireNonNull(bindingClass);
        this.proxyConstructor = AbstractOpaqueCodecContext.createImpl(loader, bindingClass);
    }

    public final Class<T> getBindingClass() {
        return this.bindingClass;
    }

    public final T deserialize(NormalizedNode data) {
        if (data instanceof ForeignDataNode) {
            ForeignDataNode foreign = (ForeignDataNode)data;
            return this.deserialize(foreign);
        }
        throw new IllegalArgumentException("Expected a ForeignDataNode, not " + data.contract().getSimpleName());
    }

    T deserialize(ForeignDataNode<?> foreignData) {
        return (T)((OpaqueObject)this.bindingClass.cast(this.createBindingProxy((OpaqueData<?>)new ForeignOpaqueData(foreignData))));
    }

    public final ForeignDataNode<?> serialize(T data) {
        Object object;
        OpaqueData opaqueData = (OpaqueData)data.getValue();
        if (opaqueData instanceof ForeignOpaqueData) {
            ForeignOpaqueData foreign = (ForeignOpaqueData)opaqueData;
            object = foreign.domData();
        } else {
            object = this.serializedData(opaqueData);
        }
        return object;
    }

    @Override
    protected final @NonNull Object deserializeObject(NormalizedNode normalizedNode) {
        return this.deserialize(normalizedNode);
    }

    @Override
    ValueCodec<Object, Object> getValueCodec() {
        return this.valueCodec;
    }

    abstract @NonNull ForeignDataNode<?> serializedData(OpaqueData<?> var1);

    private OpaqueObject<?> createBindingProxy(OpaqueData<?> data) {
        try {
            return this.proxyConstructor.invokeExact(data);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private static MethodHandle createImpl(BindingClassLoader rootLoader, Class<?> bindingClass) {
        Class proxyClass = CodecPackage.CODEC.generateClass(rootLoader, bindingClass, (loader, fqcn, bindingInterface) -> BindingClassLoader.GeneratorResult.of((DynamicType.Unloaded)TEMPLATE.name(fqcn).implement(new Type[]{bindingInterface}).make()));
        try {
            return MethodHandles.publicLookup().findConstructor(proxyClass, CTOR_LOOKUP_TYPE).asType(CTOR_INVOKE_TYPE);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new LinkageError("Failed to access constructor for prototype " + proxyClass, e);
        }
    }
}

