/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Verify;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.mdsal.binding.dom.codec.impl.AbstractOpaqueCodecContext;
import org.opendaylight.mdsal.binding.loader.BindingClassLoader;
import org.opendaylight.yangtools.yang.binding.OpaqueData;
import org.opendaylight.yangtools.yang.binding.OpaqueObject;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyxmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.DOMSourceAnyxmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.ForeignDataNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

final class AnyxmlCodecContext<T extends OpaqueObject<T>>
extends AbstractOpaqueCodecContext<T> {
    AnyxmlCodecContext(AnyxmlSchemaNode schema, String getterName, Class<T> bindingClass, BindingClassLoader loader) {
        super((DataSchemaNode)schema, getterName, bindingClass, loader);
    }

    @Override
    AnyxmlNode<?> serializedData(OpaqueData<?> opaqueData) {
        Class model = opaqueData.getObjectModel();
        Verify.verify((boolean)DOMSource.class.isAssignableFrom(model), (String)"Cannot just yet support object model %s", (Object)model);
        return (AnyxmlNode)Builders.anyXmlBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)this.getDomPathArgument()).withValue((Object)((DOMSource)opaqueData.getData())).build();
    }

    @Override
    T deserialize(ForeignDataNode<?> foreignData) {
        Verify.verify((boolean)(foreignData instanceof DOMSourceAnyxmlNode), (String)"Variable node %s not supported yet", foreignData);
        return super.deserialize(foreignData);
    }
}

