/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingAugmentationCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTree;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingInstanceIdentifierCodec;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeWriterFactory;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingStreamEventWriter;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingYangDataCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.CommonDataObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.impl.ActionCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.AnydataCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.AnyxmlCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.AugmentationCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingToNormalizedStreamWriter;
import org.opendaylight.mdsal.binding.dom.codec.impl.CaseCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ChoiceCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContextFactory;
import org.opendaylight.mdsal.binding.dom.codec.impl.CommonDataObjectCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CompositeValueCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerSerializer;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerSerializerRegistry;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerStreamer;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerStreamerGenerator;
import org.opendaylight.mdsal.binding.dom.codec.impl.IdentifiableItemCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.IdentityCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.InstanceIdentifierCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.LeafNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.LeafSetNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ListCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NotificationCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.RootCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.RpcInputCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.SchemaUnawareCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.UnionTypeCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.spi.AbstractBindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingDOMCodecServices;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingSchemaMapping;
import org.opendaylight.mdsal.binding.loader.BindingClassLoader;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.api.ListRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeType;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.util.ClassLoaderUtils;
import org.opendaylight.yangtools.yang.binding.Action;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;
import org.opendaylight.yangtools.yang.binding.BaseNotification;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyAware;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.OpaqueObject;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.binding.RpcOutput;
import org.opendaylight.yangtools.yang.binding.YangData;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.YangDataName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.api.schema.ValueNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizationResultHolder;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeDefinitionAware;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BindingCodecContext
extends AbstractBindingNormalizedNodeSerializer
implements BindingDOMCodecServices,
Immutable,
CodecContextFactory,
DataContainerSerializerRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(BindingCodecContext.class);
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier FAKE_NODEID = new YangInstanceIdentifier.NodeIdentifier(QName.create((String)"fake", (String)"fake"));
    private static final File BYTECODE_DIRECTORY;
    private final LoadingCache<Class<?>, DataContainerStreamer<?>> streamers = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, DataContainerStreamer<?>>(){

        public DataContainerStreamer<?> load(Class<?> key) throws ReflectiveOperationException {
            Class<DataContainerStreamer<?>> streamer = DataContainerStreamerGenerator.generateStreamer(BindingCodecContext.this.loader, BindingCodecContext.this, key);
            Field instance = streamer.getDeclaredField("INSTANCE");
            return (DataContainerStreamer)instance.get(null);
        }
    });
    private final LoadingCache<Class<?>, DataContainerSerializer> serializers = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, DataContainerSerializer>(){

        public DataContainerSerializer load(Class<?> key) throws ExecutionException {
            return new DataContainerSerializer(BindingCodecContext.this, (DataContainerStreamer)BindingCodecContext.this.streamers.get(key));
        }
    });
    private final @NonNull BindingClassLoader loader = BindingClassLoader.create(BindingCodecContext.class, (File)BYTECODE_DIRECTORY);
    private final @NonNull InstanceIdentifierCodec instanceIdentifierCodec;
    private final @NonNull IdentityCodec identityCodec;
    private final @NonNull BindingRuntimeContext context;
    private final @NonNull RootCodecContext<?> root;

    public BindingCodecContext() {
        this(ServiceLoader.load(BindingRuntimeContext.class).findFirst().orElseThrow(() -> new IllegalStateException("Failed to load BindingRuntimeContext")));
    }

    public BindingCodecContext(BindingRuntimeContext context) {
        this.context = Objects.requireNonNull(context, "Binding Runtime Context is required.");
        this.root = new RootCodecContext(this);
        this.identityCodec = new IdentityCodec(context);
        this.instanceIdentifierCodec = new InstanceIdentifierCodec(this);
    }

    @Override
    public BindingRuntimeContext getRuntimeContext() {
        return this.context;
    }

    @Override
    public BindingClassLoader getLoader() {
        return this.loader;
    }

    public IdentityCodec getIdentityCodec() {
        return this.identityCodec;
    }

    public BindingInstanceIdentifierCodec getInstanceIdentifierCodec() {
        return this.instanceIdentifierCodec;
    }

    public <T extends YangData<T>> BindingYangDataCodecTreeNode<T> getYangDataCodec(Class<T> yangDataClass) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public BindingYangDataCodecTreeNode<?> getYangDataCodec(YangDataName yangDataName) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public DataContainerSerializer getEventStreamSerializer(Class<?> type) {
        return (DataContainerSerializer)this.serializers.getUnchecked(type);
    }

    @Override
    public DataContainerStreamer<?> getDataContainerStreamer(Class<?> type) {
        return (DataContainerStreamer)this.streamers.getUnchecked(type);
    }

    @Override
    public DataContainerSerializer getSerializer(Class<? extends DataContainer> type) {
        return (DataContainerSerializer)this.serializers.getUnchecked(type);
    }

    public Map.Entry<YangInstanceIdentifier, BindingStreamEventWriter> newWriterAndIdentifier(InstanceIdentifier<?> path, NormalizedNodeStreamWriter domWriter) {
        ArrayList<YangInstanceIdentifier.PathArgument> yangArgs = new ArrayList<YangInstanceIdentifier.PathArgument>();
        DataContainerCodecContext<?, ?> codecContext = this.getCodecContextNode(path, yangArgs);
        return Map.entry(YangInstanceIdentifier.of(yangArgs), new BindingToNormalizedStreamWriter(codecContext, domWriter));
    }

    public BindingStreamEventWriter newWriter(InstanceIdentifier<?> path, NormalizedNodeStreamWriter domWriter) {
        return new BindingToNormalizedStreamWriter(this.getCodecContextNode(path, null), domWriter);
    }

    public BindingStreamEventWriter newRpcWriter(Class<? extends DataContainer> rpcInputOrOutput, NormalizedNodeStreamWriter domWriter) {
        return new BindingToNormalizedStreamWriter(this.root.getRpc(rpcInputOrOutput), domWriter);
    }

    public BindingStreamEventWriter newNotificationWriter(Class<? extends Notification<?>> notification, NormalizedNodeStreamWriter domWriter) {
        return new BindingToNormalizedStreamWriter(this.root.getNotification(notification), domWriter);
    }

    public BindingStreamEventWriter newActionInputWriter(Class<? extends Action<?, ?, ?>> action, NormalizedNodeStreamWriter domWriter) {
        return new BindingToNormalizedStreamWriter(this.getActionCodec(action).input(), domWriter);
    }

    public BindingStreamEventWriter newActionOutputWriter(Class<? extends Action<?, ?, ?>> action, NormalizedNodeStreamWriter domWriter) {
        return new BindingToNormalizedStreamWriter(this.getActionCodec(action).output(), domWriter);
    }

    @NonNull DataContainerCodecContext<?, ?> getCodecContextNode(InstanceIdentifier<?> binding, List<YangInstanceIdentifier.PathArgument> builder) {
        CommonDataObjectCodecTreeNode current = this.root;
        for (InstanceIdentifier.PathArgument bindingArg : binding.getPathArguments()) {
            current = current.bindingPathArgumentChild(bindingArg, (List)builder);
        }
        return current;
    }

    @Nullable BindingDataObjectCodecTreeNode<?> getCodecContextNode(@NonNull YangInstanceIdentifier dom, @Nullable Collection<// Could not load outer class - annotation placement on inner may be incorrect
    InstanceIdentifier.PathArgument> bindingArguments) {
        CodecContext currentNode = this.root;
        CommonDataObjectCodecContext currentList = null;
        for (YangInstanceIdentifier.PathArgument domArg : dom.getPathArguments()) {
            Preconditions.checkArgument((boolean)(currentNode instanceof DataContainerCodecContext), (String)"Unexpected child of non-container node %s", currentNode);
            DataContainerCodecContext previous = currentNode;
            CodecContext nextNode = previous.yangPathArgumentChild(domArg);
            if (nextNode instanceof AugmentationCodecContext) {
                AugmentationCodecContext augmContext = (AugmentationCodecContext)nextNode;
                if (bindingArguments != null) {
                    bindingArguments.add(augmContext.bindingArg());
                }
                currentNode = nextNode;
                nextNode = augmContext.yangPathArgumentChild(domArg);
            }
            if (currentList != null) {
                Preconditions.checkArgument((currentList == nextNode ? 1 : 0) != 0, (String)"List should be referenced two times in YANG Instance Identifier %s", (Object)dom);
                if (bindingArguments != null) {
                    bindingArguments.add(currentList.getBindingPathArgument(domArg));
                }
                currentList = null;
                currentNode = nextNode;
                continue;
            }
            if (nextNode instanceof ListCodecContext) {
                ListCodecContext listNode = (ListCodecContext)nextNode;
                currentList = listNode;
                continue;
            }
            if (nextNode instanceof ChoiceCodecContext) {
                currentNode = nextNode;
                continue;
            }
            if (nextNode instanceof CommonDataObjectCodecContext) {
                CommonDataObjectCodecContext containerNode = (CommonDataObjectCodecContext)nextNode;
                if (bindingArguments != null) {
                    bindingArguments.add(containerNode.getBindingPathArgument(domArg));
                }
                currentNode = nextNode;
                continue;
            }
            if (!(nextNode instanceof ValueNodeCodecContext)) continue;
            LOG.debug("Instance identifier referencing a leaf is not representable ({})", (Object)dom);
            return null;
        }
        if (currentNode instanceof ChoiceCodecContext) {
            LOG.debug("Instance identifier targeting a choice is not representable ({})", (Object)dom);
            return null;
        }
        if (currentNode instanceof CaseCodecContext) {
            LOG.debug("Instance identifier targeting a case is not representable ({})", (Object)dom);
            return null;
        }
        if (currentList != null) {
            if (bindingArguments != null) {
                bindingArguments.add(currentList.getBindingPathArgument(null));
            }
            return currentList;
        }
        if (currentNode != null) {
            Verify.verify((boolean)(currentNode instanceof BindingDataObjectCodecTreeNode), (String)"Illegal return node %s for identifier %s", currentNode, (Object)dom);
            return currentNode;
        }
        return null;
    }

    NotificationCodecContext<?> getNotificationContext(SchemaNodeIdentifier.Absolute notification) {
        return this.root.getNotification(notification);
    }

    RpcInputCodec<?> getRpcInputCodec(SchemaNodeIdentifier.Absolute containerPath) {
        return this.root.getRpc(containerPath);
    }

    ActionCodecContext getActionCodec(Class<? extends Action<?, ?, ?>> action) {
        return this.root.getAction(action);
    }

    @Override
    public ImmutableMap<Method, ValueNodeCodecContext> getLeafNodes(Class<?> type, EffectiveStatement<?, ?> schema) {
        HashMap<String, DataSchemaNode> getterToLeafSchema = new HashMap<String, DataSchemaNode>();
        for (EffectiveStatement stmt : schema.effectiveSubstatements()) {
            if (stmt instanceof TypedDataSchemaNode) {
                TypedDataSchemaNode typedSchema = (TypedDataSchemaNode)stmt;
                BindingCodecContext.putLeaf(getterToLeafSchema, (DataSchemaNode)typedSchema);
                continue;
            }
            if (stmt instanceof AnydataSchemaNode) {
                AnydataSchemaNode anydataSchema = (AnydataSchemaNode)stmt;
                BindingCodecContext.putLeaf(getterToLeafSchema, (DataSchemaNode)anydataSchema);
                continue;
            }
            if (!(stmt instanceof AnyxmlSchemaNode)) continue;
            AnyxmlSchemaNode anyxmlSchema = (AnyxmlSchemaNode)stmt;
            BindingCodecContext.putLeaf(getterToLeafSchema, (DataSchemaNode)anyxmlSchema);
        }
        return this.getLeafNodesUsingReflection(type, getterToLeafSchema);
    }

    private static void putLeaf(Map<String, DataSchemaNode> map, DataSchemaNode leaf) {
        map.put(BindingSchemaMapping.getGetterMethodName((DataSchemaNode)leaf), leaf);
    }

    private ImmutableMap<Method, ValueNodeCodecContext> getLeafNodesUsingReflection(Class<?> parentClass, Map<String, DataSchemaNode> getterToLeafSchema) {
        HashMap<Method, AnyxmlCodecContext<? extends OpaqueObject>> leaves = new HashMap<Method, AnyxmlCodecContext<? extends OpaqueObject>>();
        for (Method method : parentClass.getMethods()) {
            ValueNodeCodecContext valueNode;
            if (method.getParameterCount() != 0 || method.isBridge()) continue;
            DataSchemaNode schema = getterToLeafSchema.get(method.getName());
            if (schema instanceof LeafSchemaNode) {
                LeafSchemaNode leafSchema = (LeafSchemaNode)schema;
                Class<?> valueType = method.getReturnType();
                ValueCodec<Object, Object> codec = this.getCodec(valueType, leafSchema.getType());
                valueNode = LeafNodeCodecContext.of(leafSchema, codec, method.getName(), valueType, this.context.getEffectiveModelContext());
            } else if (schema instanceof LeafListSchemaNode) {
                Class valueType;
                LeafListSchemaNode leafListSchema = (LeafListSchemaNode)schema;
                Optional optType = ClassLoaderUtils.getFirstGenericParameter((Type)method.getGenericReturnType());
                Preconditions.checkState((boolean)optType.isPresent(), (String)"Failed to find return type for %s", (Object)method);
                Type genericType = (Type)optType.orElseThrow();
                if (genericType instanceof Class) {
                    Class clazz;
                    valueType = clazz = (Class)genericType;
                } else if (genericType instanceof ParameterizedType) {
                    ParameterizedType parameterized = (ParameterizedType)genericType;
                    valueType = (Class)parameterized.getRawType();
                } else if (genericType instanceof WildcardType) {
                    valueType = Object.class;
                } else {
                    throw new IllegalStateException("Unexpected return type " + genericType);
                }
                ValueCodec<Object, Object> codec = this.getCodec(valueType, leafListSchema.getType());
                valueNode = new LeafSetNodeCodecContext(leafListSchema, codec, method.getName());
            } else if (schema instanceof AnyxmlSchemaNode) {
                AnyxmlSchemaNode anyxmlSchema = (AnyxmlSchemaNode)schema;
                valueNode = new AnyxmlCodecContext<OpaqueObject>(anyxmlSchema, method.getName(), BindingCodecContext.opaqueReturnType(method), this.loader);
            } else if (schema instanceof AnydataSchemaNode) {
                AnydataSchemaNode anydataSchema = (AnydataSchemaNode)schema;
                valueNode = new AnydataCodecContext<OpaqueObject>(anydataSchema, method.getName(), BindingCodecContext.opaqueReturnType(method), this.loader);
            } else {
                Verify.verify((schema == null ? 1 : 0) != 0, (String)"Unhandled schema %s for method %s", (Object)schema, (Object)method);
                continue;
            }
            leaves.put(method, (AnyxmlCodecContext<? extends OpaqueObject>)valueNode);
        }
        return ImmutableMap.copyOf(leaves);
    }

    ValueCodec<Object, Object> getCodec(Class<?> valueType, TypeDefinition<?> instantiatedType) {
        if (BaseIdentity.class.isAssignableFrom(valueType)) {
            IdentityCodec casted = this.identityCodec;
            return casted;
        }
        if (InstanceIdentifier.class.equals(valueType)) {
            InstanceIdentifierCodec casted = this.instanceIdentifierCodec;
            return casted;
        }
        if (BindingReflections.isBindingClass(valueType)) {
            return this.getCodecForBindingClass(valueType, instantiatedType);
        }
        return SchemaUnawareCodec.NOOP_CODEC;
    }

    private ValueCodec<Object, Object> getCodecForBindingClass(Class<?> valueType, TypeDefinition<?> typeDef) {
        if (typeDef instanceof IdentityrefTypeDefinition) {
            return new CompositeValueCodec.OfIdentity(valueType, this.identityCodec);
        }
        if (typeDef instanceof InstanceIdentifierTypeDefinition) {
            return new CompositeValueCodec.OfInstanceIdentifier(valueType, this.instanceIdentifierCodec);
        }
        if (typeDef instanceof UnionTypeDefinition) {
            UnionTypeDefinition unionType = (UnionTypeDefinition)typeDef;
            try {
                return UnionTypeCodec.of(valueType, unionType, this);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to load codec for " + valueType, e);
            }
        }
        if (typeDef instanceof LeafrefTypeDefinition) {
            TypeDefinition def;
            RuntimeType typeWithSchema = this.context.getTypeWithSchema(valueType);
            EffectiveStatement schema = typeWithSchema.statement();
            if (schema instanceof TypeDefinitionAware) {
                TypeDefinitionAware typeDefAware = (TypeDefinitionAware)schema;
                def = typeDefAware.getTypeDefinition();
            } else if (schema instanceof TypeAware) {
                TypeAware typeAware = (TypeAware)schema;
                def = typeAware.getType();
            } else {
                throw new IllegalStateException("Unexpected schema " + schema);
            }
            return this.getCodec(valueType, def);
        }
        return SchemaUnawareCodec.of(valueType, typeDef);
    }

    @Override
    public IdentifiableItemCodec getPathArgumentCodec(Class<?> listClz, ListRuntimeType type) {
        Optional optIdentifier = ClassLoaderUtils.findFirstGenericArgument(listClz, KeyAware.class);
        Preconditions.checkState((boolean)optIdentifier.isPresent(), (String)"Failed to find identifier for %s", listClz);
        Class identifier = (Class)optIdentifier.orElseThrow();
        HashMap<QName, ValueContext> valueCtx = new HashMap<QName, ValueContext>();
        for (ValueNodeCodecContext leaf : this.getLeafNodes(identifier, (EffectiveStatement<?, ?>)type.statement()).values()) {
            QName name = leaf.getDomPathArgument().getNodeType();
            valueCtx.put(name, new ValueContext(identifier, leaf));
        }
        return IdentifiableItemCodec.of(type.statement(), identifier, listClz, valueCtx);
    }

    public <E extends DataObject> CommonDataObjectCodecTreeNode<E> getStreamChild(Class<E> childClass) {
        return this.root.getStreamChild(childClass);
    }

    public <A extends Augmentation<?>> BindingAugmentationCodecTreeNode<A> getAugmentationCodec(InstanceIdentifier<A> path) {
        DataContainerCodecContext<?, ?> codecContext = this.getCodecContextNode(path, null);
        if (codecContext instanceof BindingAugmentationCodecTreeNode) {
            return (BindingAugmentationCodecTreeNode)codecContext;
        }
        throw new IllegalArgumentException(path + " does not refer to an Augmentation");
    }

    public <T extends DataObject> BindingDataObjectCodecTreeNode<T> getDataObjectCodec(InstanceIdentifier<T> path) {
        DataContainerCodecContext<?, ?> codecContext = this.getCodecContextNode(path, null);
        if (codecContext instanceof BindingDataObjectCodecTreeNode) {
            return (BindingDataObjectCodecTreeNode)codecContext;
        }
        throw new IllegalArgumentException(path + " does not refer to a plain DataObject");
    }

    public <T extends DataObject> BindingCodecTree.CodecWithPath<T> getSubtreeCodecWithPath(InstanceIdentifier<T> path) {
        ArrayList<YangInstanceIdentifier.PathArgument> yangArgs = new ArrayList<YangInstanceIdentifier.PathArgument>();
        DataContainerCodecContext<?, ?> codecContext = this.getCodecContextNode(path, yangArgs);
        return new BindingCodecTree.CodecWithPath((CommonDataObjectCodecTreeNode)codecContext, YangInstanceIdentifier.of(yangArgs));
    }

    public <T extends DataObject> CommonDataObjectCodecTreeNode<T> getSubtreeCodec(InstanceIdentifier<T> path) {
        return (CommonDataObjectCodecTreeNode)this.getCodecContextNode(path, null);
    }

    public BindingCodecTreeNode getSubtreeCodec(YangInstanceIdentifier path) {
        return this.getCodecContextNode(path, null);
    }

    public BindingCodecTreeNode getSubtreeCodec(SchemaNodeIdentifier.Absolute path) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public YangInstanceIdentifier toYangInstanceIdentifier(InstanceIdentifier<?> binding) {
        return this.instanceIdentifierCodec.fromBinding(binding);
    }

    public <T extends DataObject> InstanceIdentifier<T> fromYangInstanceIdentifier(YangInstanceIdentifier dom) {
        return this.instanceIdentifierCodec.toBinding(dom);
    }

    public <A extends Augmentation<?>> BindingNormalizedNodeSerializer.AugmentationResult toNormalizedAugmentation(InstanceIdentifier<A> path, A data) {
        BindingNormalizedNodeSerializer.NormalizedResult result = this.toNormalizedNode((InstanceIdentifier)path, (DataObject)data);
        if (result instanceof BindingNormalizedNodeSerializer.AugmentationResult) {
            BindingNormalizedNodeSerializer.AugmentationResult augment = (BindingNormalizedNodeSerializer.AugmentationResult)result;
            return augment;
        }
        throw new IllegalArgumentException(path + " does not identify an Augmentation");
    }

    public <T extends DataObject> BindingNormalizedNodeSerializer.NodeResult toNormalizedDataObject(InstanceIdentifier<T> path, T data) {
        BindingNormalizedNodeSerializer.NormalizedResult result = this.toNormalizedNode(path, data);
        if (result instanceof BindingNormalizedNodeSerializer.NodeResult) {
            BindingNormalizedNodeSerializer.NodeResult node = (BindingNormalizedNodeSerializer.NodeResult)result;
            return node;
        }
        throw new IllegalArgumentException(path + " does not identify a plain DataObject");
    }

    public <T extends DataObject> BindingNormalizedNodeSerializer.NormalizedResult toNormalizedNode(InstanceIdentifier<T> path, T data) {
        BindingAugmentationCodecTreeNode augmentNode;
        ArrayList<YangInstanceIdentifier.PathArgument> yangArgs = new ArrayList<YangInstanceIdentifier.PathArgument>();
        DataContainerCodecContext<?, ?> codecContext = this.getCodecContextNode(path, yangArgs);
        YangInstanceIdentifier yangPath = YangInstanceIdentifier.of(yangArgs);
        NormalizationResultHolder result = new NormalizationResultHolder();
        NormalizedNodeStreamWriter domWriter = ImmutableNormalizedNodeStreamWriter.from((NormalizationResultHolder)result);
        BindingToNormalizedStreamWriter bindingWriter = new BindingToNormalizedStreamWriter(codecContext, domWriter);
        BindingAugmentationCodecTreeNode augment = codecContext instanceof BindingAugmentationCodecTreeNode ? (augmentNode = (BindingAugmentationCodecTreeNode)codecContext) : null;
        try {
            if (augment != null) {
                domWriter.startContainerNode(FAKE_NODEID, -1);
            }
            this.getSerializer(path.getTargetType()).serialize((DataContainer)data, bindingWriter);
            if (augment != null) {
                domWriter.endNode();
            }
        }
        catch (IOException e) {
            LOG.error("Unexpected failure while serializing path {} data {}", new Object[]{path, data, e});
            throw new IllegalStateException("Failed to create normalized node", e);
        }
        if (augment != null) {
            return new BindingNormalizedNodeSerializer.AugmentationResult(yangPath, augment.childPathArguments(), ImmutableList.copyOf((Collection)((ContainerNode)result.getResult().data()).body()));
        }
        return new BindingNormalizedNodeSerializer.NodeResult(yangPath, result.getResult().data());
    }

    public Map.Entry<InstanceIdentifier<?>, DataObject> fromNormalizedNode(YangInstanceIdentifier path, NormalizedNode data) {
        if (BindingCodecContext.notBindingRepresentable(data)) {
            return null;
        }
        ArrayList<InstanceIdentifier.PathArgument> builder = new ArrayList<InstanceIdentifier.PathArgument>();
        BindingDataObjectCodecTreeNode<?> codec = this.getCodecContextNode(path, builder);
        if (codec == null) {
            if (data != null) {
                LOG.warn("Path {} does not have a binding equivalent, should have been caught earlier ({})", (Object)path, data.getClass());
            }
            return null;
        }
        DataObject lazyObj = (DataObject)codec.deserialize(data);
        InstanceIdentifier bindingPath = InstanceIdentifier.unsafeOf(builder);
        return Map.entry(bindingPath, lazyObj);
    }

    public BaseNotification fromNormalizedNodeNotification(SchemaNodeIdentifier.Absolute path, ContainerNode data) {
        return (BaseNotification)this.getNotificationContext(path).deserialize((NormalizedNode)data);
    }

    public BaseNotification fromNormalizedNodeNotification(SchemaNodeIdentifier.Absolute path, ContainerNode data, Instant eventInstant) {
        return eventInstant == null ? this.fromNormalizedNodeNotification(path, data) : this.getNotificationContext(path).deserialize(data, eventInstant);
    }

    public DataObject fromNormalizedNodeRpcData(SchemaNodeIdentifier.Absolute containerPath, ContainerNode data) {
        return (DataObject)this.getRpcInputCodec(containerPath).deserialize((NormalizedNode)data);
    }

    public <T extends RpcInput> T fromNormalizedNodeActionInput(Class<? extends Action<?, ?, ?>> action, ContainerNode input) {
        return (T)((RpcInput)Objects.requireNonNull((DataObject)this.getActionCodec(action).input().deserialize((NormalizedNode)Objects.requireNonNull(input))));
    }

    public <T extends RpcOutput> T fromNormalizedNodeActionOutput(Class<? extends Action<?, ?, ?>> action, ContainerNode output) {
        return (T)((RpcOutput)Objects.requireNonNull((DataObject)this.getActionCodec(action).output().deserialize((NormalizedNode)Objects.requireNonNull(output))));
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public ContainerNode toNormalizedNodeNotification(Notification<?> data) {
        return this.serializeDataObject((DataObject)data, (ctx, iface, domWriter) -> ctx.newNotificationWriter(iface.asSubclass(Notification.class), domWriter));
    }

    public ContainerNode toNormalizedNodeNotification(SchemaNodeIdentifier.Absolute path, BaseNotification data) {
        Preconditions.checkArgument((boolean)(data instanceof DataObject), (String)"Unexpected data %s", (Object)data);
        NotificationCodecContext<?> notifContext = this.getNotificationContext(path);
        NormalizedNode result = notifContext.serialize((DataObject)data);
        Verify.verify((boolean)(result instanceof ContainerNode), (String)"Unexpected result %s from %s", (Object)result, (Object)data);
        return (ContainerNode)result;
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public ContainerNode toNormalizedNodeRpcData(DataContainer data) {
        return this.serializeDataObject((DataObject)data, BindingNormalizedNodeWriterFactory::newRpcWriter);
    }

    public ContainerNode toNormalizedNodeActionInput(Class<? extends Action<?, ?, ?>> action, RpcInput input) {
        return this.serializeDataObject((DataObject)input, (ctx, iface, domWriter) -> ctx.newActionInputWriter(action, domWriter));
    }

    public ContainerNode toNormalizedNodeActionOutput(Class<? extends Action<?, ?, ?>> action, RpcOutput output) {
        return this.serializeDataObject((DataObject)output, (ctx, iface, domWriter) -> ctx.newActionOutputWriter(action, domWriter));
    }

    protected YangInstanceIdentifier.NodeIdentifier actionInputName(Class<? extends Action<?, ?, ?>> action) {
        return (YangInstanceIdentifier.NodeIdentifier)Verify.verifyNotNull((Object)this.getActionCodec(action).input().getDomPathArgument());
    }

    protected YangInstanceIdentifier.NodeIdentifier actionOutputName(Class<? extends Action<?, ?, ?>> action) {
        return (YangInstanceIdentifier.NodeIdentifier)Verify.verifyNotNull((Object)this.getActionCodec(action).output().getDomPathArgument());
    }

    private <T extends DataContainer> @NonNull ContainerNode serializeDataObject(DataObject data, WriterFactoryMethod<T> newWriter) {
        NormalizationResultHolder result = new NormalizationResultHolder();
        NormalizedNodeStreamWriter domWriter = ImmutableNormalizedNodeStreamWriter.from((NormalizationResultHolder)result);
        Class type = data.implementedInterface();
        BindingStreamEventWriter writer = newWriter.createWriter((BindingNormalizedNodeWriterFactory)this, type, domWriter);
        try {
            this.getSerializer(type).serialize((DataContainer)data, writer);
        }
        catch (IOException e) {
            LOG.error("Unexpected failure while serializing data {}", (Object)data, (Object)e);
            throw new IllegalStateException("Failed to create normalized node", e);
        }
        return (ContainerNode)result.getResult().data();
    }

    private static boolean notBindingRepresentable(NormalizedNode data) {
        return data instanceof ValueNode || data instanceof MapNode || data instanceof UnkeyedListNode || data instanceof ChoiceNode || data instanceof LeafSetNode;
    }

    private static Class<? extends OpaqueObject> opaqueReturnType(Method method) {
        Class<?> valueType = method.getReturnType();
        Verify.verify((boolean)OpaqueObject.class.isAssignableFrom(valueType), (String)"Illegal value type %s", valueType);
        return valueType.asSubclass(OpaqueObject.class);
    }

    static {
        String dir = System.getProperty("org.opendaylight.mdsal.binding.dom.codec.loader.bytecodeDumpDirectory");
        BYTECODE_DIRECTORY = Strings.isNullOrEmpty((String)dir) ? null : new File(dir);
    }

    @FunctionalInterface
    private static interface WriterFactoryMethod<T extends DataContainer> {
        public BindingStreamEventWriter createWriter(@NonNull BindingNormalizedNodeWriterFactory var1, @NonNull Class<? extends T> var2, @NonNull NormalizedNodeStreamWriter var3);
    }
}

