/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeCachingCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.AbstractDataContainerAnalysis;
import org.opendaylight.mdsal.binding.dom.codec.impl.CaseCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CaseCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.ChoiceCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContextFactory;
import org.opendaylight.mdsal.binding.dom.codec.impl.CommonDataObjectCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CommonDataObjectCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.api.CaseRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.ChoiceRuntimeType;
import org.opendaylight.yangtools.yang.binding.BindingObject;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ChoiceCodecContext<D extends DataObject>
extends CommonDataObjectCodecContext<D, ChoiceRuntimeType>
implements BindingDataObjectCodecTreeNode<D> {
    private static final Logger LOG = LoggerFactory.getLogger(ChoiceCodecContext.class);
    private final ImmutableListMultimap<Class<?>, CommonDataObjectCodecPrototype<?>> ambiguousByCaseChildClass;
    private final ImmutableMap<Class<?>, CommonDataObjectCodecPrototype<?>> byCaseChildClass;
    private final ImmutableMap<YangInstanceIdentifier.NodeIdentifier, CaseCodecPrototype> byYangCaseChild;
    private final ImmutableMap<Class<?>, CommonDataObjectCodecPrototype<?>> byClass;
    private final Set<Class<?>> ambiguousByCaseChildWarnings;

    ChoiceCodecContext(Class<D> cls, ChoiceRuntimeType type, CodecContextFactory factory) {
        this(new ChoiceCodecPrototype(InstanceIdentifier.Item.of(cls), type, factory));
    }

    ChoiceCodecContext(ChoiceCodecPrototype prototype) {
        super(prototype);
        HashMap<YangInstanceIdentifier.NodeIdentifier, CaseCodecPrototype> byYangCaseChildBuilder = new HashMap<YangInstanceIdentifier.NodeIdentifier, CaseCodecPrototype>();
        HashMap<Object, CaseCodecPrototype> byClassBuilder = new HashMap<Object, CaseCodecPrototype>();
        SetMultimap childToCase = MultimapBuilder.SetMultimapBuilder.hashKeys().hashSetValues().build();
        ChoiceRuntimeType choiceType = (ChoiceRuntimeType)prototype.getType();
        CodecContextFactory factory = prototype.getFactory();
        HashSet<JavaTypeName> localCases = new HashSet<JavaTypeName>();
        for (CaseRuntimeType caseType : choiceType.validCaseChildren()) {
            Class<?> caseClass = ChoiceCodecContext.loadCase(factory.getRuntimeContext(), caseType);
            CaseCodecPrototype caseCodecPrototype = new CaseCodecPrototype(caseClass, caseType, factory);
            localCases.add(caseType.getIdentifier());
            byClassBuilder.put(caseClass, caseCodecPrototype);
            for (Class<DataObject> cazeChild : ChoiceCodecContext.getChildrenClasses((Class<? extends DataContainer>)caseClass)) {
                childToCase.put(cazeChild, (Object)caseCodecPrototype);
            }
            for (EffectiveStatement stmt : caseType.statement().effectiveSubstatements()) {
                if (!(stmt instanceof DataSchemaNode)) continue;
                DataSchemaNode cazeChild = (DataSchemaNode)stmt;
                byYangCaseChildBuilder.put(YangInstanceIdentifier.NodeIdentifier.create((QName)cazeChild.getQName()), caseCodecPrototype);
            }
        }
        this.byYangCaseChild = ImmutableMap.copyOf(byYangCaseChildBuilder);
        ImmutableListMultimap.Builder ambiguousByCaseBuilder = ImmutableListMultimap.builder();
        ImmutableMap.Builder unambiguousByCaseBuilder = ImmutableMap.builder();
        for (Map.Entry entry : Multimaps.asMap((SetMultimap)childToCase).entrySet()) {
            Set cases = (Set)entry.getValue();
            if (cases.size() != 1) {
                ArrayList<CommonDataObjectCodecPrototype> list = new ArrayList<CommonDataObjectCodecPrototype>((Collection)entry.getValue());
                list.sort(Comparator.comparing(proto -> proto.getBindingClass().getCanonicalName()));
                ambiguousByCaseBuilder.putAll((Object)((Class)entry.getKey()), list);
                continue;
            }
            unambiguousByCaseBuilder.put((Object)((Class)entry.getKey()), (Object)((CommonDataObjectCodecPrototype)cases.iterator().next()));
        }
        this.byCaseChildClass = unambiguousByCaseBuilder.build();
        this.ambiguousByCaseChildClass = ambiguousByCaseBuilder.build();
        this.ambiguousByCaseChildWarnings = this.ambiguousByCaseChildClass.isEmpty() ? ImmutableSet.of() : ConcurrentHashMap.newKeySet();
        HashMap bySubstitutionBuilder = new HashMap();
        BindingRuntimeContext bindingRuntimeContext = factory.getRuntimeContext();
        block4: for (CaseRuntimeType caseType : bindingRuntimeContext.getTypes().allCaseChildren(choiceType)) {
            JavaTypeName caseName = caseType.getIdentifier();
            if (localCases.contains(caseName)) continue;
            Class<?> substitution = ChoiceCodecContext.loadCase(bindingRuntimeContext, caseType);
            for (Map.Entry real : byClassBuilder.entrySet()) {
                if (!ChoiceCodecContext.isSubstitutionFor(substitution, (Class)real.getKey())) continue;
                bySubstitutionBuilder.put(substitution, (CommonDataObjectCodecPrototype)real.getValue());
                continue block4;
            }
        }
        byClassBuilder.putAll(bySubstitutionBuilder);
        this.byClass = ImmutableMap.copyOf(byClassBuilder);
    }

    private static Class<?> loadCase(BindingRuntimeContext context, CaseRuntimeType caseType) {
        JavaTypeName className = caseType.getIdentifier();
        try {
            return context.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new LinkageError("Failed to load class for " + className, e);
        }
    }

    public DocumentedNode.WithStatus getSchema() {
        return (DocumentedNode.WithStatus)((ChoiceRuntimeType)this.type()).statement();
    }

    @Override
    public <C extends DataObject> CommonDataObjectCodecContext<C, ?> getStreamChild(Class<C> childClass) {
        return (CommonDataObjectCodecContext)this.childNonNull(this.streamChild((Class)childClass), childClass, "Supplied class %s is not valid case in %s", childClass, this.bindingArg());
    }

    @Override
    public <C extends DataObject> CommonDataObjectCodecContext<C, ?> streamChild(Class<C> childClass) {
        CommonDataObjectCodecPrototype child = (CommonDataObjectCodecPrototype)this.byClass.get(childClass);
        return child == null ? null : child.get();
    }

    Iterable<Class<?>> getCaseChildrenClasses() {
        return Iterables.concat((Iterable)this.byCaseChildClass.keySet(), (Iterable)this.ambiguousByCaseChildClass.keySet());
    }

    @Override
    public CodecContext yangPathArgumentChild(YangInstanceIdentifier.PathArgument arg) {
        CommonDataObjectCodecPrototype cazeProto = arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates ? (CommonDataObjectCodecPrototype)this.byYangCaseChild.get((Object)new YangInstanceIdentifier.NodeIdentifier(arg.getNodeType())) : (CommonDataObjectCodecPrototype)this.byYangCaseChild.get((Object)arg);
        return ((DataContainerCodecContext)this.childNonNull(cazeProto, arg, "Argument %s is not valid child of %s", arg, this.getSchema()).get()).yangPathArgumentChild(arg);
    }

    @SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"}, justification="See FIXME below")
    public D deserialize(NormalizedNode data) {
        ChoiceNode casted = ChoiceCodecContext.checkDataArgument(ChoiceNode.class, data);
        DataContainerChild first = (DataContainerChild)Iterables.getFirst((Iterable)casted.body(), null);
        if (first == null) {
            return null;
        }
        CaseCodecPrototype caze = (CaseCodecPrototype)this.byYangCaseChild.get((Object)first.name());
        return ((CaseCodecContext)caze.get()).deserialize(data);
    }

    public NormalizedNode serialize(D data) {
        return this.serializeImpl(data);
    }

    @Override
    protected Object deserializeObject(NormalizedNode normalizedNode) {
        return this.deserialize(normalizedNode);
    }

    public InstanceIdentifier.PathArgument deserializePathArgument(YangInstanceIdentifier.PathArgument arg) {
        Preconditions.checkArgument((boolean)this.getDomPathArgument().equals((Object)arg));
        return null;
    }

    public YangInstanceIdentifier.PathArgument serializePathArgument(InstanceIdentifier.PathArgument arg) {
        return this.getDomPathArgument();
    }

    public BindingNormalizedNodeCachingCodec<D> createCachingCodec(ImmutableCollection<Class<? extends BindingObject>> cacheSpecifier) {
        return ChoiceCodecContext.createCachingCodec(this, cacheSpecifier);
    }

    DataContainerCodecContext<?, ?> getCaseByChildClass(@NonNull Class<? extends DataObject> type) {
        ImmutableList inexact;
        CommonDataObjectCodecPrototype result = (CommonDataObjectCodecPrototype)this.byCaseChildClass.get(type);
        if (result == null && !(inexact = this.ambiguousByCaseChildClass.get(type)).isEmpty()) {
            result = (CommonDataObjectCodecPrototype)inexact.get(0);
            if (this.ambiguousByCaseChildWarnings.add(type)) {
                LOG.warn("Ambiguous reference {} to child of {} resolved to {}, the first case in {} This mapping is not guaranteed to be stable and is subject to variations based on runtime circumstances. Please see the stack trace for hints about the source of ambiguity.", new Object[]{type, this.bindingArg(), result.getBindingClass(), Lists.transform((List)inexact, CommonDataObjectCodecPrototype::getBindingClass), new Throwable()});
            }
        }
        return this.childNonNull(result, type, "Class %s is not child of any cases for %s", type, this.bindingArg()).get();
    }

    private static Iterable<Class<? extends DataObject>> getChildrenClasses(Class<? extends DataContainer> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Target type must not be null");
        Preconditions.checkArgument((boolean)DataContainer.class.isAssignableFrom(type), (Object)"Supplied type must be derived from DataContainer");
        LinkedList<Class<? extends DataObject>> ret = new LinkedList<Class<? extends DataObject>>();
        for (Method method : type.getMethods()) {
            AbstractDataContainerAnalysis.getYangModeledReturnType(method, "get").ifPresent(entity -> ret.add((Class<? extends DataObject>)entity));
        }
        return ret;
    }
}

