/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContextSupplier;
import org.opendaylight.mdsal.binding.loader.BindingClassLoader;

@Beta
public final class ClassGeneratorBridge {
    private static final ThreadLocal<BridgeProvider<?>> CURRENT_CUSTOMIZER = new ThreadLocal();

    private ClassGeneratorBridge() {
    }

    public static @NonNull CodecContextSupplier resolveCodecContextSupplier(@NonNull String methodName) {
        return ClassGeneratorBridge.current(CodecContextSupplierProvider.class).resolveCodecContextSupplier(methodName);
    }

    public static @NonNull String resolveLocalName(@NonNull String methodName) {
        return ClassGeneratorBridge.current(LocalNameProvider.class).resolveLocalName(methodName);
    }

    static @Nullable BridgeProvider<?> setup(@NonNull BridgeProvider<?> next) {
        BridgeProvider<?> prev = CURRENT_CUSTOMIZER.get();
        CURRENT_CUSTOMIZER.set((BridgeProvider)Verify.verifyNotNull(next));
        return prev;
    }

    static void tearDown(@Nullable BridgeProvider<?> prev) {
        if (prev == null) {
            CURRENT_CUSTOMIZER.remove();
        } else {
            CURRENT_CUSTOMIZER.set(prev);
        }
    }

    private static <T extends BridgeProvider<?>> @NonNull T current(Class<T> requested) {
        return (T)((BridgeProvider)requested.cast(Verify.verifyNotNull(CURRENT_CUSTOMIZER.get(), (String)"No customizer attached", (Object[])new Object[0])));
    }

    static interface CodecContextSupplierProvider<T>
    extends BridgeProvider<T> {
        public @NonNull CodecContextSupplier resolveCodecContextSupplier(@NonNull String var1);
    }

    static interface BridgeProvider<T>
    extends BindingClassLoader.ClassGenerator<T> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        default public Class<T> customizeLoading(@NonNull Supplier<Class<T>> loader) {
            BridgeProvider<?> prev = ClassGeneratorBridge.setup(this);
            try {
                Class<T> result = loader.get();
                try {
                    Class.forName(result.getName(), true, result.getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new LinkageError("Failed to find newly-defined " + result, e);
                }
                Class<T> clazz = result;
                return clazz;
            }
            finally {
                ClassGeneratorBridge.tearDown(prev);
            }
        }
    }

    static interface LocalNameProvider<T>
    extends BridgeProvider<T> {
        public @NonNull String resolveLocalName(@NonNull String var1);
    }
}

