/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.impl.AbstractDataContainerAnalysis;
import org.opendaylight.mdsal.binding.dom.codec.impl.AbstractDataObjectCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContextFactory;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecDataObject;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecDataObjectGenerator;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecItemFactory;
import org.opendaylight.mdsal.binding.dom.codec.impl.CommonDataObjectCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueNodeCodecContext;
import org.opendaylight.mdsal.binding.runtime.api.AugmentRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.AugmentableRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.CompositeRuntimeType;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;

final class CodecDataObjectAnalysis<R extends CompositeRuntimeType>
extends AbstractDataContainerAnalysis<R> {
    private static final MethodType CONSTRUCTOR_TYPE = MethodType.methodType(Void.TYPE, AbstractDataObjectCodecContext.class, DataContainerNode.class);
    private static final MethodType DATAOBJECT_TYPE = MethodType.methodType(DataObject.class, AbstractDataObjectCodecContext.class, DataContainerNode.class);
    final @NonNull Class<? extends CodecDataObject<?>> generatedClass;
    final @NonNull List<AugmentRuntimeType> possibleAugmentations;
    final @NonNull MethodHandle proxyConstructor;

    CodecDataObjectAnalysis(CommonDataObjectCodecPrototype<R> prototype, CodecItemFactory itemFactory, Method keyMethod) {
        this(prototype.getBindingClass(), (CompositeRuntimeType)prototype.getType(), prototype.getFactory(), itemFactory, keyMethod);
    }

    CodecDataObjectAnalysis(Class<?> bindingClass, R runtimeType, CodecContextFactory factory, CodecItemFactory itemFactory, Method keyMethod) {
        super(bindingClass, runtimeType, factory, itemFactory);
        MethodHandle ctor;
        if (Augmentable.class.isAssignableFrom(bindingClass)) {
            if (!(runtimeType instanceof AugmentableRuntimeType)) {
                throw new VerifyException("Unexpected type %s backing augmenable %s".formatted(runtimeType, bindingClass));
            }
            AugmentableRuntimeType augmentableRuntimeType = (AugmentableRuntimeType)runtimeType;
            this.possibleAugmentations = augmentableRuntimeType.augments();
            this.generatedClass = CodecDataObjectGenerator.generateAugmentable(factory.getLoader(), bindingClass, (ImmutableMap<Method, ValueNodeCodecContext>)this.leafContexts, this.daoProperties, keyMethod);
        } else {
            this.possibleAugmentations = List.of();
            this.generatedClass = CodecDataObjectGenerator.generate(factory.getLoader(), bindingClass, (ImmutableMap<Method, ValueNodeCodecContext>)this.leafContexts, this.daoProperties, keyMethod);
        }
        try {
            ctor = MethodHandles.publicLookup().findConstructor(this.generatedClass, CONSTRUCTOR_TYPE);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new LinkageError("Failed to find contructor for class " + this.generatedClass, e);
        }
        this.proxyConstructor = ctor.asType(DATAOBJECT_TYPE);
    }
}

