/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.impl.AugmentableCodecDataObject;
import org.opendaylight.mdsal.binding.dom.codec.impl.ByteBuddyUtils;
import org.opendaylight.mdsal.binding.dom.codec.impl.ClassGeneratorBridge;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContextSupplier;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecDataObject;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecPackage;
import org.opendaylight.mdsal.binding.dom.codec.impl.PropertyInfo;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueNodeCodecContext;
import org.opendaylight.mdsal.binding.loader.BindingClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class CodecDataObjectGenerator<T extends CodecDataObject<?>>
implements BindingClassLoader.ClassGenerator<T> {
    private static final Logger LOG = LoggerFactory.getLogger(CodecDataObjectGenerator.class);
    private static final TypeDescription.Generic BB_BOOLEAN = TypeDefinition.Sort.describe(Boolean.TYPE);
    private static final TypeDescription.Generic BB_OBJECT = TypeDefinition.Sort.describe(Object.class);
    private static final TypeDescription.Generic BB_INT = TypeDefinition.Sort.describe(Integer.TYPE);
    private static final TypeDescription.Generic BB_STRING = TypeDefinition.Sort.describe(String.class);
    private static final TypeDescription BB_CDO = TypeDescription.ForLoadedType.of(CodecDataObject.class);
    private static final TypeDescription BB_ACDO = TypeDescription.ForLoadedType.of(AugmentableCodecDataObject.class);
    private static final StackManipulation FIRST_ARG_REF = MethodVariableAccess.REFERENCE.loadFrom(1);
    private static final int PROT_FINAL = 4116;
    private static final int PUB_FINAL = 4113;
    private static final ByteBuddy BB = new ByteBuddy();
    private final TypeDescription superClass;
    private final Method keyMethod;

    CodecDataObjectGenerator(TypeDescription superClass, @Nullable Method keyMethod) {
        this.superClass = Objects.requireNonNull(superClass);
        this.keyMethod = keyMethod;
    }

    static <T extends CodecDataObject<T>> Class<T> generate(BindingClassLoader loader, Class<?> bindingInterface, ImmutableMap<Method, ValueNodeCodecContext> simpleProperties, Map<Class<?>, PropertyInfo> daoProperties, Method keyMethod) {
        return CodecPackage.CODEC.generateClass(loader, bindingInterface, new Reusable(BB_CDO, simpleProperties, daoProperties, keyMethod));
    }

    static <T extends CodecDataObject<T>> Class<T> generateAugmentable(BindingClassLoader loader, Class<?> bindingInterface, ImmutableMap<Method, ValueNodeCodecContext> simpleProperties, Map<Class<?>, PropertyInfo> daoProperties, Method keyMethod) {
        return CodecPackage.CODEC.generateClass(loader, bindingInterface, new Reusable(BB_ACDO, simpleProperties, daoProperties, keyMethod));
    }

    public final BindingClassLoader.GeneratorResult<T> generateClass(BindingClassLoader loader, String fqcn, Class<?> bindingInterface) {
        LOG.trace("Generating class {}", (Object)fqcn);
        TypeDescription.Generic bindingDef = TypeDefinition.Sort.describe(bindingInterface);
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = BB.subclass((TypeDefinition)TypeDescription.Generic.Builder.parameterizedType((TypeDescription)this.superClass, (TypeDefinition[])new TypeDefinition[]{bindingDef}).build()).name(fqcn).implement(new TypeDefinition[]{bindingDef});
        builder = this.generateGetters((DynamicType.Builder<T>)builder);
        if (this.keyMethod != null) {
            LOG.trace("Generating for key {}", (Object)this.keyMethod);
            String methodName = this.keyMethod.getName();
            TypeDescription retType = TypeDescription.ForLoadedType.of(this.keyMethod.getReturnType());
            builder = builder.defineMethod(methodName, (TypeDefinition)retType, 4113).intercept((Implementation)new KeyMethodImplementation(methodName, retType));
        }
        return BindingClassLoader.GeneratorResult.of((DynamicType.Unloaded)builder.defineMethod("codecHashCode", (TypeDefinition)BB_INT, 4116).intercept(CodecDataObjectGenerator.codecHashCode(bindingInterface)).defineMethod("codecEquals", (TypeDefinition)BB_BOOLEAN, 4116).withParameter((TypeDefinition)BB_OBJECT).intercept(CodecDataObjectGenerator.codecEquals(bindingInterface)).defineMethod("toString", (TypeDefinition)BB_STRING, 4113).intercept(CodecDataObjectGenerator.toString(bindingInterface)).make());
    }

    abstract DynamicType.Builder<T> generateGetters(DynamicType.Builder<T> var1);

    private static Implementation codecHashCode(Class<?> bindingInterface) {
        return new Implementation.Simple(new StackManipulation[]{MethodVariableAccess.loadThis(), ByteBuddyUtils.invokeMethod(bindingInterface, "bindingHashCode", bindingInterface), MethodReturn.INTEGER});
    }

    private static Implementation codecEquals(Class<?> bindingInterface) {
        return new Implementation.Simple(new StackManipulation[]{MethodVariableAccess.loadThis(), FIRST_ARG_REF, ByteBuddyUtils.invokeMethod(bindingInterface, "bindingEquals", bindingInterface, Object.class), MethodReturn.INTEGER});
    }

    private static Implementation toString(Class<?> bindingInterface) {
        return new Implementation.Simple(new StackManipulation[]{MethodVariableAccess.loadThis(), ByteBuddyUtils.invokeMethod(bindingInterface, "bindingToString", bindingInterface), MethodReturn.REFERENCE});
    }

    private static final class Reusable<T extends CodecDataObject<?>>
    extends CodecDataObjectGenerator<T>
    implements ClassGeneratorBridge.LocalNameProvider<T> {
        private final ImmutableMap<Method, ValueNodeCodecContext> simpleProperties;
        private final Map<Class<?>, PropertyInfo> daoProperties;

        Reusable(TypeDescription superClass, ImmutableMap<Method, ValueNodeCodecContext> simpleProperties, Map<Class<?>, PropertyInfo> daoProperties, @Nullable Method keyMethod) {
            super(superClass, keyMethod);
            this.simpleProperties = Objects.requireNonNull(simpleProperties);
            this.daoProperties = Objects.requireNonNull(daoProperties);
        }

        @Override
        DynamicType.Builder<T> generateGetters(DynamicType.Builder<T> builder) {
            DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition tmp = builder;
            for (Method method : this.simpleProperties.keySet()) {
                LOG.trace("Generating for simple method {}", (Object)method);
                String methodName = method.getName();
                TypeDescription retType = TypeDescription.ForLoadedType.of(method.getReturnType());
                tmp = tmp.defineMethod(methodName, (TypeDefinition)retType, 4113).intercept((Implementation)new SimpleGetterMethodImplementation(methodName, retType));
            }
            for (Map.Entry entry : this.daoProperties.entrySet()) {
                PropertyInfo info = (PropertyInfo)entry.getValue();
                Method method = info.getterMethod();
                LOG.trace("Generating for structured method {}", (Object)method);
                String methodName = method.getName();
                TypeDescription retType = TypeDescription.ForLoadedType.of(method.getReturnType());
                tmp = tmp.defineMethod(methodName, (TypeDefinition)retType, 4113).intercept((Implementation)new StructuredGetterMethodImplementation(methodName, retType, (Class)entry.getKey()));
                if (!(info instanceof PropertyInfo.GetterAndNonnull)) continue;
                PropertyInfo.GetterAndNonnull orEmpty = (PropertyInfo.GetterAndNonnull)info;
                String nonnullName = orEmpty.nonnullMethod().getName();
                tmp = tmp.defineMethod(nonnullName, (TypeDefinition)retType, 4113).intercept((Implementation)new NonnullMethodImplementation(nonnullName, retType, (Class)entry.getKey(), method));
            }
            return tmp;
        }

        @Override
        public String resolveLocalName(String methodName) {
            Optional<Map.Entry> found = this.simpleProperties.entrySet().stream().filter(entry -> methodName.equals(((Method)entry.getKey()).getName())).findAny();
            Verify.verify((boolean)found.isPresent(), (String)"Failed to find property for %s in %s", (Object)methodName, (Object)this);
            return ((ValueNodeCodecContext)found.orElseThrow().getValue()).getSchema().getQName().getLocalName();
        }
    }

    private static final class KeyMethodImplementation
    extends AbstractCachedMethodImplementation {
        private static final StackManipulation CODEC_KEY = ByteBuddyUtils.invokeMethod(CodecDataObject.class, "codecKey", VarHandle.class);

        KeyMethodImplementation(String methodName, TypeDescription retType) {
            super(methodName, retType);
        }

        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new ByteCodeAppender.Simple(new StackManipulation[]{MethodVariableAccess.loadThis(), ByteBuddyUtils.getField(implementationTarget.getInstrumentedType(), this.handleName), CODEC_KEY, TypeCasting.to((TypeDefinition)this.retType), MethodReturn.REFERENCE});
        }
    }

    private static final class SupplierGetterMethodImplementation
    extends AbstractCachedMethodImplementation {
        private static final StackManipulation CODEC_MEMBER = ByteBuddyUtils.invokeMethod(CodecDataObject.class, "codecMember", VarHandle.class, CodecContextSupplier.class);
        private static final StackManipulation BRIDGE_RESOLVE = ByteBuddyUtils.invokeMethod(ClassGeneratorBridge.class, "resolveNodeContextSupplier", String.class);
        private static final TypeDescription.Generic BB_NCS = TypeDefinition.Sort.describe(CodecContextSupplier.class);
        private final String contextName;

        SupplierGetterMethodImplementation(String methodName, TypeDescription retType) {
            super(methodName, retType);
            this.contextName = methodName + "$$$C";
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            InstrumentedType tmp = super.prepare(instrumentedType).withField(new FieldDescription.Token(this.contextName, 4122, BB_NCS));
            return tmp.withInitializer((ByteCodeAppender)new ByteCodeAppender.Simple(new StackManipulation[]{new TextConstant(this.methodName), BRIDGE_RESOLVE, ByteBuddyUtils.putField((TypeDescription)tmp, this.contextName)}));
        }

        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            TypeDescription instrumentedType = implementationTarget.getInstrumentedType();
            return new ByteCodeAppender.Simple(new StackManipulation[]{MethodVariableAccess.loadThis(), ByteBuddyUtils.getField(instrumentedType, this.handleName), ByteBuddyUtils.getField(instrumentedType, this.contextName), CODEC_MEMBER, TypeCasting.to((TypeDefinition)this.retType), MethodReturn.REFERENCE});
        }
    }

    private static final class StructuredGetterMethodImplementation
    extends AbstractCachedMethodImplementation {
        private static final StackManipulation CODEC_MEMBER = ByteBuddyUtils.invokeMethod(CodecDataObject.class, "codecMember", VarHandle.class, Class.class);
        private final Class<?> bindingClass;

        StructuredGetterMethodImplementation(String methodName, TypeDescription retType, Class<?> bindingClass) {
            super(methodName, retType);
            this.bindingClass = Objects.requireNonNull(bindingClass);
        }

        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new ByteCodeAppender.Simple(new StackManipulation[]{MethodVariableAccess.loadThis(), ByteBuddyUtils.getField(implementationTarget.getInstrumentedType(), this.handleName), ClassConstant.of((TypeDescription)TypeDefinition.Sort.describe(this.bindingClass).asErasure()), CODEC_MEMBER, TypeCasting.to((TypeDefinition)this.retType), MethodReturn.REFERENCE});
        }
    }

    private static final class SimpleGetterMethodImplementation
    extends AbstractCachedMethodImplementation {
        private static final StackManipulation CODEC_MEMBER = ByteBuddyUtils.invokeMethod(CodecDataObject.class, "codecMember", VarHandle.class, String.class);
        private static final StackManipulation BRIDGE_RESOLVE = ByteBuddyUtils.invokeMethod(ClassGeneratorBridge.class, "resolveLocalName", String.class);
        private static final TypeDescription.Generic BB_STRING = TypeDefinition.Sort.describe(String.class);
        private final String stringName;

        SimpleGetterMethodImplementation(String methodName, TypeDescription retType) {
            super(methodName, retType);
            this.stringName = methodName + "$$$S";
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            InstrumentedType tmp = super.prepare(instrumentedType).withField(new FieldDescription.Token(this.stringName, 4122, BB_STRING));
            return tmp.withInitializer((ByteCodeAppender)new ByteCodeAppender.Simple(new StackManipulation[]{new TextConstant(this.methodName), BRIDGE_RESOLVE, ByteBuddyUtils.putField((TypeDescription)tmp, this.stringName)}));
        }

        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            TypeDescription instrumentedType = implementationTarget.getInstrumentedType();
            return new ByteCodeAppender.Simple(new StackManipulation[]{MethodVariableAccess.loadThis(), ByteBuddyUtils.getField(instrumentedType, this.handleName), ByteBuddyUtils.getField(instrumentedType, this.stringName), CODEC_MEMBER, TypeCasting.to((TypeDefinition)this.retType), MethodReturn.REFERENCE});
        }
    }

    private static final class NonnullMethodImplementation
    extends AbstractMethodImplementation {
        private static final StackManipulation NONNULL_MEMBER = ByteBuddyUtils.invokeMethod(CodecDataObject.class, "codecMemberOrEmpty", Object.class, Class.class);
        private final Class<?> bindingClass;
        private final Method getterMethod;

        NonnullMethodImplementation(String methodName, TypeDescription retType, Class<?> bindingClass, Method getterMethod) {
            super(methodName, retType);
            this.bindingClass = Objects.requireNonNull(bindingClass);
            this.getterMethod = Objects.requireNonNull(getterMethod);
        }

        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new ByteCodeAppender.Simple(new StackManipulation[]{MethodVariableAccess.loadThis(), MethodVariableAccess.loadThis(), ByteBuddyUtils.invokeMethod(this.getterMethod), ClassConstant.of((TypeDescription)TypeDefinition.Sort.describe(this.bindingClass).asErasure()), NONNULL_MEMBER, TypeCasting.to((TypeDefinition)this.retType), MethodReturn.REFERENCE});
        }

        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }
    }

    private static abstract class AbstractCachedMethodImplementation
    extends AbstractMethodImplementation {
        private static final TypeDescription.Generic BB_HANDLE = TypeDefinition.Sort.describe(VarHandle.class);
        private static final TypeDescription.Generic BB_OBJECT = TypeDefinition.Sort.describe(Object.class);
        private static final StackManipulation OBJECT_CLASS = ClassConstant.of((TypeDescription)TypeDescription.ForLoadedType.of(Object.class));
        private static final StackManipulation LOOKUP = ByteBuddyUtils.invokeMethod(MethodHandles.class, "lookup", new Class[0]);
        private static final StackManipulation FIND_VAR_HANDLE = ByteBuddyUtils.invokeMethod(MethodHandles.Lookup.class, "findVarHandle", Class.class, String.class, Class.class);
        static final int PRIV_CONST = 4122;
        private static final int PRIV_VOLATILE = 4162;
        final String handleName;

        AbstractCachedMethodImplementation(String methodName, TypeDescription retType) {
            super(methodName, retType);
            this.handleName = methodName + "$$$V";
        }

        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            InstrumentedType tmp = instrumentedType.withField(new FieldDescription.Token(this.handleName, 4122, BB_HANDLE)).withField(new FieldDescription.Token(this.methodName, 4162, BB_OBJECT));
            return tmp.withInitializer((ByteCodeAppender)new ByteCodeAppender.Simple(new StackManipulation[]{LOOKUP, ClassConstant.of((TypeDescription)tmp), new TextConstant(this.methodName), OBJECT_CLASS, FIND_VAR_HANDLE, ByteBuddyUtils.putField((TypeDescription)tmp, this.handleName)}));
        }
    }

    private static abstract class AbstractMethodImplementation
    implements Implementation {
        final TypeDescription retType;
        final String methodName;

        AbstractMethodImplementation(String methodName, TypeDescription retType) {
            this.methodName = Objects.requireNonNull(methodName);
            this.retType = Objects.requireNonNull(retType);
        }
    }

    private static final class Fixed<T extends CodecDataObject<?>>
    extends CodecDataObjectGenerator<T>
    implements ClassGeneratorBridge.CodecContextSupplierProvider<T> {
        private final ImmutableMap<Method, CodecContextSupplier> properties;

        Fixed(TypeDescription superClass, ImmutableMap<Method, CodecContextSupplier> properties, @Nullable Method keyMethod) {
            super(superClass, keyMethod);
            this.properties = Objects.requireNonNull(properties);
        }

        @Override
        DynamicType.Builder<T> generateGetters(DynamicType.Builder<T> builder) {
            DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition tmp = builder;
            for (Method method : this.properties.keySet()) {
                LOG.trace("Generating for fixed method {}", (Object)method);
                String methodName = method.getName();
                TypeDescription retType = TypeDescription.ForLoadedType.of(method.getReturnType());
                tmp = tmp.defineMethod(methodName, (TypeDefinition)retType, 4113).intercept((Implementation)new SupplierGetterMethodImplementation(methodName, retType));
            }
            return tmp;
        }

        @Override
        public CodecContextSupplier resolveCodecContextSupplier(String methodName) {
            Optional<Map.Entry> found = this.properties.entrySet().stream().filter(entry -> methodName.equals(((Method)entry.getKey()).getName())).findAny();
            Verify.verify((boolean)found.isPresent(), (String)"Failed to find property for %s in %s", (Object)methodName, (Object)this);
            return (CodecContextSupplier)Verify.verifyNotNull((Object)((CodecContextSupplier)found.orElseThrow().getValue()));
        }
    }
}

