/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContextFactory;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContextSupplier;
import org.opendaylight.mdsal.binding.dom.codec.impl.CommonDataObjectCodecContext;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeTypeContainer;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QNameModule;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class CommonDataObjectCodecPrototype<T extends RuntimeTypeContainer>
implements CodecContextSupplier {
    private static final VarHandle INSTANCE;
    private final @NonNull T type;
    private final @NonNull QNameModule namespace;
    private final @NonNull CodecContextFactory factory;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull InstanceIdentifier.Item<?> bindingArg;
    private volatile CommonDataObjectCodecContext<?, T> instance;

    CommonDataObjectCodecPrototype(InstanceIdentifier.Item<?> bindingArg, QNameModule namespace, T type, CodecContextFactory factory) {
        this.bindingArg = Objects.requireNonNull(bindingArg);
        this.namespace = Objects.requireNonNull(namespace);
        this.type = (RuntimeTypeContainer)Objects.requireNonNull(type);
        this.factory = Objects.requireNonNull(factory);
    }

    final @NonNull T getType() {
        return this.type;
    }

    final @NonNull QNameModule getNamespace() {
        return this.namespace;
    }

    final @NonNull CodecContextFactory getFactory() {
        return this.factory;
    }

    final @NonNull Class<?> getBindingClass() {
        return this.bindingArg.getType();
    }

    final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull InstanceIdentifier.Item<?> getBindingArg() {
        return this.bindingArg;
    }

    abstract // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier getYangArg();

    @Override
    public final CommonDataObjectCodecContext<?, T> get() {
        CommonDataObjectCodecContext<?, T> existing = INSTANCE.getAcquire(this);
        return existing != null ? existing : this.loadInstance();
    }

    private @NonNull CommonDataObjectCodecContext<?, T> loadInstance() {
        CommonDataObjectCodecContext tmp = this.createInstance();
        CommonDataObjectCodecContext witness = INSTANCE.compareAndExchangeRelease(this, null, tmp);
        return witness == null ? tmp : witness;
    }

    abstract @NonNull CommonDataObjectCodecContext<?, T> createInstance();

    static {
        try {
            INSTANCE = MethodHandles.lookup().findVarHandle(CommonDataObjectCodecPrototype.class, "instance", CommonDataObjectCodecContext.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

