/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingStreamEventWriter;
import org.opendaylight.mdsal.binding.dom.codec.impl.AnydataBindingStreamWriter;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingSerializer;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerSerializer;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerSerializerRegistry;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.KeyAware;
import org.opendaylight.yangtools.yang.binding.OpaqueObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class DataContainerStreamer<T extends DataContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(DataContainerStreamer.class);

    protected DataContainerStreamer() {
    }

    protected abstract void serialize(DataContainerSerializerRegistry var1, DataContainer var2, BindingStreamEventWriter var3) throws IOException;

    protected static final void streamAnydata(BindingStreamEventWriter writer, String localName, Object value) throws IOException {
        if (value != null && writer instanceof AnydataBindingStreamWriter) {
            AnydataBindingStreamWriter anydataWriter = (AnydataBindingStreamWriter)writer;
            Verify.verify((boolean)(value instanceof OpaqueObject), (String)"Unexpected data %s", (Object)value);
            anydataWriter.anydataNode(localName, (OpaqueObject)value);
        }
    }

    protected static final void streamAnyxml(BindingStreamEventWriter writer, String localName, Object value) throws IOException {
        if (value != null) {
            writer.anyxmlNode(localName, value);
        }
    }

    protected static final void streamAugmentations(DataContainerSerializerRegistry registry, BindingStreamEventWriter writer, Augmentable<?> obj) throws IOException {
        for (Map.Entry aug : obj.augmentations().entrySet()) {
            DataContainerStreamer.emitAugmentation((Class)aug.getKey(), (Augmentation)aug.getValue(), writer, registry);
        }
    }

    protected static final <C extends DataContainer> void streamChoice(Class<C> choiceClass, DataContainerSerializerRegistry registry, BindingStreamEventWriter writer, C value) throws IOException {
        if (value != null) {
            Class caseClass = value.implementedInterface();
            writer.startChoiceNode(choiceClass, -1);
            DataContainerSerializer caseStreamer = registry.getSerializer(caseClass.asSubclass(DataObject.class));
            if (caseStreamer != null) {
                if (DataContainerStreamer.tryCache(writer, (DataObject)value)) {
                    caseStreamer.serialize((DataContainer)((DataObject)value), writer);
                }
            } else {
                LOG.warn("No serializer for case {} is available in registry {}", (Object)caseClass, (Object)registry);
            }
            writer.endNode();
        }
    }

    protected static final <C extends DataObject> void streamContainer(DataContainerStreamer<C> childStreamer, DataContainerSerializerRegistry registry, BindingStreamEventWriter writer, C value) throws IOException {
        if (value != null && DataContainerStreamer.tryCache(writer, value)) {
            childStreamer.serialize(registry, (DataContainer)value, writer);
        }
    }

    protected static final void streamLeaf(BindingStreamEventWriter writer, String localName, Object value) throws IOException {
        if (value != null) {
            writer.leafNode(localName, value);
        }
    }

    protected static final void streamLeafList(BindingStreamEventWriter writer, String localName, Set<?> value) throws IOException {
        if (value != null) {
            writer.startLeafSet(localName, value.size());
            DataContainerStreamer.commonStreamLeafset(writer, value);
        }
    }

    protected static final void streamOrderedLeafList(BindingStreamEventWriter writer, String localName, List<?> value) throws IOException {
        if (value != null) {
            writer.startOrderedLeafSet(localName, value.size());
            DataContainerStreamer.commonStreamLeafset(writer, value);
        }
    }

    protected static final <E extends DataObject> void streamList(Class<E> childClass, DataContainerStreamer<E> childStreamer, DataContainerSerializerRegistry registry, BindingStreamEventWriter writer, List<? extends E> value) throws IOException {
        int size = DataContainerStreamer.nullSize(value);
        if (size != 0) {
            writer.startUnkeyedList(childClass, size);
            DataContainerStreamer.commonStreamList(registry, writer, childStreamer, value);
        }
    }

    protected static final <E extends DataObject & KeyAware<?>> void streamMap(Class<E> childClass, DataContainerStreamer<E> childStreamer, DataContainerSerializerRegistry registry, BindingStreamEventWriter writer, Map<?, ? extends E> value) throws IOException {
        int size = DataContainerStreamer.nullSize(value);
        if (size != 0) {
            writer.startMapNode(childClass, size);
            DataContainerStreamer.commonStreamList(registry, writer, childStreamer, value.values());
        }
    }

    protected static final <E extends DataObject & KeyAware<?>> void streamOrderedMap(Class<E> childClass, DataContainerStreamer<E> childStreamer, DataContainerSerializerRegistry registry, BindingStreamEventWriter writer, List<? extends E> value) throws IOException {
        int size = DataContainerStreamer.nullSize(value);
        if (size != 0) {
            writer.startOrderedMapNode(childClass, size);
            DataContainerStreamer.commonStreamList(registry, writer, childStreamer, value);
        }
    }

    private static <E extends DataObject> void commonStreamList(DataContainerSerializerRegistry registry, BindingStreamEventWriter writer, DataContainerStreamer<E> childStreamer, Collection<? extends E> value) throws IOException {
        for (DataObject entry : value) {
            if (!DataContainerStreamer.tryCache(writer, entry)) continue;
            childStreamer.serialize(registry, (DataContainer)entry, writer);
        }
        writer.endNode();
    }

    private static void commonStreamLeafset(BindingStreamEventWriter writer, Collection<?> value) throws IOException {
        for (Object entry : value) {
            writer.leafSetEntryNode(entry);
        }
        writer.endNode();
    }

    private static void emitAugmentation(Class<? extends Augmentation<?>> type, Augmentation<?> value, BindingStreamEventWriter writer, DataContainerSerializerRegistry registry) throws IOException {
        if (value != null) {
            DataContainerSerializer serializer = registry.getSerializer(type);
            if (serializer != null) {
                serializer.serialize((DataContainer)value, writer);
            } else {
                LOG.warn("DataObjectSerializer is not present for {} in registry {}", type, (Object)registry);
            }
        }
    }

    private static <T extends DataObject> boolean tryCache(BindingStreamEventWriter writer, T value) {
        return !(writer instanceof BindingSerializer) || ((BindingSerializer)writer).serialize(value) == null;
    }

    private static int nullSize(Collection<?> list) {
        return list == null ? 0 : list.size();
    }

    private static int nullSize(Map<?, ?> map) {
        return map == null ? 0 : map.size();
    }
}

