/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeCachingCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.AbstractDataObjectCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.AugmentationCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContextFactory;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContextSupplier;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecDataObject;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecDataObjectAnalysis;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecItemFactory;
import org.opendaylight.mdsal.binding.dom.codec.impl.CommonDataObjectCodecPrototype;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.runtime.api.AugmentRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.api.CompositeRuntimeType;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.BindingObject;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Beta
public abstract class DataObjectCodecContext<D extends DataObject, T extends CompositeRuntimeType>
extends AbstractDataObjectCodecContext<D, T>
implements BindingDataObjectCodecTreeNode<D> {
    private static final Logger LOG = LoggerFactory.getLogger(DataObjectCodecContext.class);
    private static final VarHandle MISMATCHED_AUGMENTED;
    private final ImmutableMap<Class<?>, AugmentationCodecPrototype> augmentToPrototype;
    private final ImmutableMap<YangInstanceIdentifier.NodeIdentifier, Class<?>> yangToAugmentClass;
    private final @NonNull Class<? extends CodecDataObject<?>> generatedClass;
    private volatile ImmutableMap<Class<?>, CommonDataObjectCodecPrototype<?>> mismatchedAugmented = ImmutableMap.of();

    DataObjectCodecContext(CommonDataObjectCodecPrototype<T> prototype) {
        this(prototype, CodecItemFactory.of());
    }

    DataObjectCodecContext(CommonDataObjectCodecPrototype<T> prototype, CodecItemFactory itemFactory) {
        this(prototype, new CodecDataObjectAnalysis<T>(prototype, itemFactory, null));
    }

    DataObjectCodecContext(CommonDataObjectCodecPrototype<T> prototype, Method keyMethod) {
        this(prototype, new CodecDataObjectAnalysis<T>(prototype, CodecItemFactory.of(), keyMethod));
    }

    private DataObjectCodecContext(CommonDataObjectCodecPrototype<T> prototype, CodecDataObjectAnalysis<T> analysis) {
        super(prototype, analysis);
        this.generatedClass = analysis.generatedClass;
        HashMap augPathToBinding = new HashMap();
        HashMap augClassToProto = new HashMap();
        for (AugmentRuntimeType augment : analysis.possibleAugmentations) {
            AugmentationCodecPrototype augProto = this.loadAugmentPrototype(augment);
            if (augProto == null) continue;
            Class<?> augBindingClass = augProto.getBindingClass();
            for (YangInstanceIdentifier.NodeIdentifier childPath : augProto.getChildArgs()) {
                augPathToBinding.putIfAbsent(childPath, augBindingClass);
            }
            augClassToProto.putIfAbsent(augBindingClass, augProto);
        }
        this.yangToAugmentClass = ImmutableMap.copyOf(augPathToBinding);
        this.augmentToPrototype = ImmutableMap.copyOf(augClassToProto);
    }

    @Override
    final CommonDataObjectCodecPrototype<?> pathChildPrototype(Class<? extends DataObject> argType) {
        CommonDataObjectCodecPrototype child = super.pathChildPrototype(argType);
        return child != null ? child : (CommonDataObjectCodecPrototype)this.augmentToPrototype.get(argType);
    }

    @Override
    final CommonDataObjectCodecPrototype<?> streamChildPrototype(Class<?> childClass) {
        CommonDataObjectCodecPrototype<?> child = super.streamChildPrototype(childClass);
        if (child == null && Augmentation.class.isAssignableFrom(childClass)) {
            return this.getAugmentationProtoByClass(childClass);
        }
        return child;
    }

    @Override
    final CodecContextSupplier yangChildSupplier(YangInstanceIdentifier.NodeIdentifier arg) {
        Class augClass;
        CodecContextSupplier child = super.yangChildSupplier(arg);
        if (child == null && (augClass = (Class)this.yangToAugmentClass.get((Object)arg)) != null) {
            return (CodecContextSupplier)this.augmentToPrototype.get((Object)augClass);
        }
        return child;
    }

    private @Nullable AugmentationCodecPrototype getAugmentationProtoByClass(@NonNull Class<?> augmClass) {
        AugmentationCodecPrototype childProto = (AugmentationCodecPrototype)this.augmentToPrototype.get(augmClass);
        return childProto != null ? childProto : this.mismatchedAugmentationByClass(augmClass);
    }

    private @Nullable AugmentationCodecPrototype mismatchedAugmentationByClass(@NonNull Class<?> childClass) {
        ImmutableMap local = MISMATCHED_AUGMENTED.getAcquire(this);
        AugmentationCodecPrototype mismatched = (AugmentationCodecPrototype)local.get(childClass);
        return mismatched != null ? mismatched : this.loadMismatchedAugmentation(local, childClass);
    }

    private @Nullable AugmentationCodecPrototype loadMismatchedAugmentation(ImmutableMap<Class<?>, AugmentationCodecPrototype> oldMismatched, @NonNull Class<?> childClass) {
        Class<Augmentable<?>> augTarget = DataObjectCodecContext.findAugmentationTarget(childClass);
        if (this.getBindingClass().equals(augTarget) && this.belongsToRuntimeContext(childClass)) {
            for (AugmentationCodecPrototype realChild : this.augmentToPrototype.values()) {
                if (!Augmentation.class.isAssignableFrom(realChild.getBindingClass()) || !DataObjectCodecContext.isSubstitutionFor(childClass, realChild.getBindingClass())) continue;
                return this.cacheMismatched(oldMismatched, childClass, realChild);
            }
        }
        LOG.trace("Failed to resolve {} as a valid augmentation in {}", childClass, (Object)this);
        return null;
    }

    private @NonNull AugmentationCodecPrototype cacheMismatched(@NonNull ImmutableMap<Class<?>, AugmentationCodecPrototype> oldMismatched, @NonNull Class<?> childClass, @NonNull AugmentationCodecPrototype prototype) {
        ImmutableMap witness;
        AugmentationCodecPrototype existing;
        ImmutableMap expected = oldMismatched;
        do {
            ImmutableMap newMismatched;
            if ((witness = MISMATCHED_AUGMENTED.compareAndExchangeRelease(this, expected, newMismatched = ImmutableMap.builderWithExpectedSize((int)(expected.size() + 1)).putAll(expected).put(childClass, (Object)prototype).build())) != expected) continue;
            LOG.trace("Cached mismatched augmentation {} -> {} in {}", new Object[]{childClass, prototype, this});
            return prototype;
        } while ((existing = (AugmentationCodecPrototype)(expected = witness).get(childClass)) == null);
        LOG.trace("Using raced mismatched augmentation {} -> {} in {}", new Object[]{childClass, existing, this});
        return existing;
    }

    private boolean belongsToRuntimeContext(Class<?> cls) {
        Class loaded;
        BindingRuntimeContext ctx = this.factory().getRuntimeContext();
        try {
            loaded = ctx.loadClass(Type.of(cls));
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Proposed {} cannot be loaded in {}", new Object[]{cls, ctx, e});
            return false;
        }
        return cls.equals(loaded);
    }

    private @Nullable AugmentationCodecPrototype loadAugmentPrototype(AugmentRuntimeType augment) {
        Class augClass;
        ImmutableSet childPaths = (ImmutableSet)augment.statement().streamEffectiveSubstatements(SchemaTreeEffectiveStatement.class).map(stmt -> new YangInstanceIdentifier.NodeIdentifier((QName)stmt.argument())).collect(ImmutableSet.toImmutableSet());
        UnmodifiableIterator it = childPaths.iterator();
        if (!it.hasNext()) {
            return null;
        }
        QNameModule namespace = ((YangInstanceIdentifier.NodeIdentifier)it.next()).getNodeType().getModule();
        CodecContextFactory factory = this.factory();
        GeneratedType javaType = augment.javaType();
        try {
            augClass = factory.getRuntimeContext().loadClass((Type)javaType);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("RuntimeContext references type " + javaType + " but failed to load its class", e);
        }
        return new AugmentationCodecPrototype(augClass, namespace, augment, factory, (ImmutableSet<YangInstanceIdentifier.NodeIdentifier>)childPaths);
    }

    @Override
    Map<Class<? extends Augmentation<?>>, Augmentation<?>> getAllAugmentationsFrom(DataContainerNode data) {
        HashMap<Class, DataContainerNodeBuilder> builders = new HashMap<Class, DataContainerNodeBuilder>();
        for (DataContainerChild childValue : data.body()) {
            Class bindingClass = (Class)this.yangToAugmentClass.get((Object)childValue.name());
            if (bindingClass == null) continue;
            builders.computeIfAbsent(bindingClass, key -> Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(data.name().getNodeType()))).addChild((NormalizedNode)childValue);
        }
        HashMap map = new HashMap();
        for (Map.Entry entry : builders.entrySet()) {
            Object bindingObj;
            Class bindingClass = (Class)entry.getKey();
            AugmentationCodecPrototype codecProto = (AugmentationCodecPrototype)this.augmentToPrototype.get((Object)bindingClass);
            if (codecProto == null || (bindingObj = codecProto.get().deserializeObject(((DataContainerNodeBuilder)entry.getValue()).build())) == null) continue;
            map.put(bindingClass, (Augmentation<?>)bindingObj);
        }
        return map;
    }

    final @NonNull Class<? extends CodecDataObject<?>> generatedClass() {
        return this.generatedClass;
    }

    public InstanceIdentifier.PathArgument deserializePathArgument(YangInstanceIdentifier.PathArgument arg) {
        Preconditions.checkArgument((boolean)this.getDomPathArgument().equals((Object)arg));
        return this.bindingArg();
    }

    public YangInstanceIdentifier.PathArgument serializePathArgument(InstanceIdentifier.PathArgument arg) {
        Preconditions.checkArgument((boolean)this.bindingArg().equals(arg));
        return this.getDomPathArgument();
    }

    public NormalizedNode serialize(D data) {
        return this.serializeImpl(data);
    }

    public final BindingNormalizedNodeCachingCodec<D> createCachingCodec(ImmutableCollection<Class<? extends BindingObject>> cacheSpecifier) {
        return DataObjectCodecContext.createCachingCodec(this, cacheSpecifier);
    }

    static {
        try {
            MISMATCHED_AUGMENTED = MethodHandles.lookup().findVarHandle(DataObjectCodecContext.class, "mismatchedAugmented", ImmutableMap.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

