/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingInstanceIdentifierCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ListCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueCodec;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

final class InstanceIdentifierCodec
implements BindingInstanceIdentifierCodec,
ValueCodec<YangInstanceIdentifier, InstanceIdentifier<?>> {
    private final BindingCodecContext context;

    InstanceIdentifierCodec(BindingCodecContext context) {
        this.context = Objects.requireNonNull(context);
    }

    public <T extends DataObject> InstanceIdentifier<T> toBinding(YangInstanceIdentifier domPath) {
        ArrayList<InstanceIdentifier.PathArgument> builder = new ArrayList<InstanceIdentifier.PathArgument>();
        BindingDataObjectCodecTreeNode<?> codec = this.context.getCodecContextNode(domPath, builder);
        if (codec == null) {
            return null;
        }
        if (codec instanceof ListCodecContext && Iterables.getLast(builder) instanceof InstanceIdentifier.Item) {
            return null;
        }
        return InstanceIdentifier.unsafeOf(builder);
    }

    public @NonNull YangInstanceIdentifier fromBinding(@NonNull InstanceIdentifier<?> bindingPath) {
        ArrayList<YangInstanceIdentifier.PathArgument> domArgs = new ArrayList<YangInstanceIdentifier.PathArgument>();
        this.context.getCodecContextNode(bindingPath, domArgs);
        return YangInstanceIdentifier.of(domArgs);
    }

    @Override
    @Deprecated
    public YangInstanceIdentifier serialize(InstanceIdentifier<?> input) {
        return this.fromBinding(input);
    }

    @Override
    @Deprecated
    public InstanceIdentifier<?> deserialize(YangInstanceIdentifier input) {
        return this.toBinding(input);
    }
}

