/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.impl.LazyBindingList;
import org.opendaylight.mdsal.binding.dom.codec.impl.LazyBindingMap;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.binding.KeyAware;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;

final class LazyBindingMapLookupState<K extends Key<V>, V extends DataObject & KeyAware<K>>
extends LazyBindingMap.State<K, V> {
    private static final VarHandle VALUES;
    private final ConcurrentHashMap<K, V> objects = new ConcurrentHashMap();
    private final LazyBindingMap<K, V> map;
    private volatile Values<K, V> values;

    LazyBindingMapLookupState(LazyBindingMap<K, V> map) {
        this.map = Objects.requireNonNull(map);
    }

    @Override
    boolean containsKey(Object key) {
        return this.objects.containsKey(key) || this.loadKey(key) != null;
    }

    @Override
    V get(Object key) {
        DataObject existing = (DataObject)this.objects.get(key);
        return (V)(existing != null ? existing : this.loadKey(key));
    }

    KeySet<K, V> keySet() {
        return new KeySet(this.values());
    }

    Values<K, V> values() {
        Values<K, V> ret = VALUES.getAcquire(this);
        return ret != null ? ret : this.loadValues();
    }

    EntrySet<K, V> entrySet() {
        return new EntrySet(this.values());
    }

    private @Nullable V loadKey(@NonNull Object key) {
        Optional<V> opt = this.map.lookupValue(key);
        if (opt.isEmpty()) {
            return null;
        }
        return (V)this.putIfAbsent((Key)key, (DataObject)opt.orElseThrow());
    }

    private @NonNull V putIfAbsent(@NonNull K key, @NonNull V value) {
        DataObject existing = (DataObject)this.objects.putIfAbsent(key, value);
        return (V)(existing == null ? value : existing);
    }

    private @NonNull Values<K, V> loadValues() {
        Values ret = new Values(this);
        Object witness = VALUES.compareAndExchangeRelease(this, null, ret);
        return witness == null ? ret : (Values)witness;
    }

    static {
        try {
            VALUES = MethodHandles.lookup().findVarHandle(LazyBindingMapLookupState.class, "values", Values.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static final class KeySet<K extends Key<V>, V extends DataObject & KeyAware<K>>
    extends AbstractSet<K>
    implements Immutable {
        private final Values<K, V> values;

        KeySet(Values<K, V> values) {
            this.values = Objects.requireNonNull(values);
        }

        @Override
        public Iterator<K> iterator() {
            return this.values.keyIterator();
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.values.map().containsKey(o);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof KeySet && this.values == ((KeySet)obj).values || super.equals(obj);
        }
    }

    private static final class Values<K extends Key<V>, V extends DataObject & KeyAware<K>>
    extends AbstractSet<V>
    implements Immutable {
        private final LazyBindingMapLookupState<K, V> state;
        @SuppressFBWarnings(value={"VO_VOLATILE_REFERENCE_TO_ARRAY"}, justification="The ref should really be volatile. This class does not access elements directly.")
        private volatile Object[] objects;

        Values(LazyBindingMapLookupState<K, V> state) {
            this.state = Objects.requireNonNull(state);
            this.objects = this.map().mapNode().body().toArray();
        }

        @Override
        public Iterator<V> iterator() {
            Object[] local = this.objects;
            return local == null ? Iterators.unmodifiableIterator(this.state.objects.values().iterator()) : new ValuesIter(this, local);
        }

        @Override
        public boolean contains(Object o) {
            return this.map().containsValue(o);
        }

        @Override
        public int size() {
            return this.map().size();
        }

        Iterator<Map.Entry<K, V>> entryIterator() {
            Object[] local = this.objects;
            return local == null ? Iterators.unmodifiableIterator(this.state.objects.entrySet().iterator()) : Iterators.transform(new ValuesIter(this, local), value -> Map.entry(((KeyAware)value).key(), value));
        }

        Iterator<K> keyIterator() {
            Object[] local = this.objects;
            return local == null ? Iterators.unmodifiableIterator(((ConcurrentHashMap.KeySetView)this.state.objects.keySet()).iterator()) : Iterators.transform(new ValuesIter(this, local), rec$ -> ((KeyAware)rec$).key());
        }

        LazyBindingMap<K, V> map() {
            return this.state.map;
        }

        void fullyIterated() {
            this.objects = null;
        }
    }

    private static final class EntrySet<K extends Key<V>, V extends DataObject & KeyAware<K>>
    extends AbstractSet<Map.Entry<K, V>>
    implements Immutable {
        private final Values<K, V> values;

        EntrySet(Values<K, V> values) {
            this.values = Objects.requireNonNull(values);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this.values.entryIterator();
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.values.contains(((Map.Entry)o).getValue());
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof EntrySet && this.values == ((EntrySet)obj).values || super.equals(obj);
        }
    }

    private static final class ValuesIter<K extends Key<V>, V extends DataObject & KeyAware<K>>
    extends AbstractIterator<V> {
        private final Values<K, V> values;
        private final Object[] objects;
        private int nextOffset;

        ValuesIter(Values<K, V> values, Object[] objects) {
            this.values = Objects.requireNonNull(values);
            this.objects = Objects.requireNonNull(objects);
        }

        protected V computeNext() {
            if (this.nextOffset < this.objects.length) {
                return this.objectAt(this.nextOffset++);
            }
            this.values.fullyIterated();
            return (V)((DataObject)this.endOfData());
        }

        private @NonNull V objectAt(int offset) {
            Object obj = LazyBindingList.OBJ_AA.getAcquire(this.objects, offset);
            return (V)(obj instanceof MapEntryNode ? this.loadObjectAt(offset, (MapEntryNode)obj) : (DataObject)obj);
        }

        private @NonNull V loadObjectAt(int offset, MapEntryNode obj) {
            LazyBindingMapLookupState local = this.values.state;
            Object created = local.map.createValue(obj);
            Object ret = local.putIfAbsent(((KeyAware)created).key(), created);
            Object witness = LazyBindingList.OBJ_AA.compareAndExchangeRelease(this.objects, offset, obj, (DataObject)ret);
            return (V)(witness == obj ? ret : (DataObject)witness);
        }
    }
}

