/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContextFactory;
import org.opendaylight.mdsal.binding.dom.codec.impl.IdentifiableItemCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.LazyBindingMap;
import org.opendaylight.mdsal.binding.dom.codec.impl.ListCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.MapCodecPrototype;
import org.opendaylight.mdsal.binding.runtime.api.ListRuntimeType;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.binding.KeyAware;
import org.opendaylight.yangtools.yang.common.Ordering;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class MapCodecContext<I extends Key<D>, D extends DataObject & KeyAware<I>>
extends ListCodecContext<D> {
    private final IdentifiableItemCodec codec;

    private MapCodecContext(MapCodecPrototype prototype, Method keyMethod, IdentifiableItemCodec codec) {
        super(prototype, keyMethod);
        this.codec = Objects.requireNonNull(codec);
    }

    static @NonNull MapCodecContext<?, ?> of(Class<? extends DataObject> cls, ListRuntimeType type, CodecContextFactory factory) {
        return MapCodecContext.of(new MapCodecPrototype(InstanceIdentifier.Item.of(cls), type, factory));
    }

    static @NonNull MapCodecContext<?, ?> of(MapCodecPrototype prototype) {
        Method keyMethod;
        Class<?> bindingClass = prototype.getBindingClass();
        try {
            keyMethod = bindingClass.getMethod("key", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Required method not available", e);
        }
        ListRuntimeType type = (ListRuntimeType)prototype.getType();
        IdentifiableItemCodec codec = prototype.getFactory().getPathArgumentCodec(bindingClass, type);
        return type.statement().ordering() == Ordering.SYSTEM ? new Unordered(prototype, keyMethod, codec) : new Ordered(prototype, keyMethod, codec);
    }

    @Override
    void addYangPathArgument(List<YangInstanceIdentifier.PathArgument> builder, InstanceIdentifier.PathArgument arg) {
        YangInstanceIdentifier.NodeIdentifier yangArg = this.getDomPathArgument();
        builder.add((YangInstanceIdentifier.PathArgument)yangArg);
        if (arg instanceof InstanceIdentifier.IdentifiableItem) {
            InstanceIdentifier.IdentifiableItem identifiable = (InstanceIdentifier.IdentifiableItem)arg;
            builder.add((YangInstanceIdentifier.PathArgument)this.codec.bindingToDom(identifiable));
        } else {
            builder.add((YangInstanceIdentifier.PathArgument)yangArg);
        }
    }

    @Override
    protected final InstanceIdentifier.PathArgument getBindingPathArgument(YangInstanceIdentifier.PathArgument domArg) {
        InstanceIdentifier.IdentifiableItem<?, ?> identifiableItem;
        if (domArg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            YangInstanceIdentifier.NodeIdentifierWithPredicates nip = (YangInstanceIdentifier.NodeIdentifierWithPredicates)domArg;
            identifiableItem = this.codec.domToBinding(nip);
        } else {
            identifiableItem = super.getBindingPathArgument(domArg);
        }
        return identifiableItem;
    }

    final YangInstanceIdentifier.NodeIdentifierWithPredicates serialize(Key<?> key) {
        return this.codec.bindingToDom(InstanceIdentifier.IdentifiableItem.of(this.getBindingClass(), key));
    }

    final @NonNull Key<?> deserialize(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifierWithPredicates arg) {
        return this.codec.deserializeIdentifier(arg);
    }

    @Override
    public final YangInstanceIdentifier.PathArgument serializePathArgument(InstanceIdentifier.PathArgument arg) {
        YangInstanceIdentifier.PathArgument pathArgument;
        if (arg instanceof InstanceIdentifier.IdentifiableItem) {
            InstanceIdentifier.IdentifiableItem identifiable = (InstanceIdentifier.IdentifiableItem)arg;
            pathArgument = this.codec.bindingToDom(identifiable);
        } else {
            pathArgument = super.serializePathArgument(arg);
        }
        return pathArgument;
    }

    @Override
    public final InstanceIdentifier.PathArgument deserializePathArgument(YangInstanceIdentifier.PathArgument arg) {
        InstanceIdentifier.IdentifiableItem<?, ?> identifiableItem;
        if (arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            YangInstanceIdentifier.NodeIdentifierWithPredicates nip = (YangInstanceIdentifier.NodeIdentifierWithPredicates)arg;
            identifiableItem = this.codec.domToBinding(nip);
        } else {
            identifiableItem = super.deserializePathArgument(arg);
        }
        return identifiableItem;
    }

    static final class Unordered<I extends Key<D>, D extends DataObject & KeyAware<I>>
    extends MapCodecContext<I, D> {
        private Unordered(MapCodecPrototype prototype, Method keyMethod, IdentifiableItemCodec codec) {
            super(prototype, keyMethod, codec);
        }

        @Override
        Map<I, D> fromMap(MapNode map, int size) {
            return LazyBindingMap.of(this, map, size);
        }
    }

    private static final class Ordered<I extends Key<D>, D extends DataObject & KeyAware<I>>
    extends MapCodecContext<I, D> {
        Ordered(MapCodecPrototype prototype, Method keyMethod, IdentifiableItemCodec codec) {
            super(prototype, keyMethod, codec);
        }
    }
}

