/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableCollection;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeCachingCodec;
import org.opendaylight.mdsal.binding.dom.codec.api.CommonDataObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.IncorrectNestingException;
import org.opendaylight.mdsal.binding.dom.codec.impl.ActionCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ChoiceCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContextFactory;
import org.opendaylight.mdsal.binding.dom.codec.impl.CommonDataObjectCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ContainerLikeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.MapCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NotificationCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.RpcInputCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.StructuralContainerCodecContext;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.runtime.api.ActionRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeTypes;
import org.opendaylight.mdsal.binding.runtime.api.ChoiceRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.CompositeRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.ContainerLikeRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.ContainerRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.DataRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.GeneratedRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.ListRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.NotificationRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeType;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.util.ClassLoaderUtils;
import org.opendaylight.yangtools.yang.binding.Action;
import org.opendaylight.yangtools.yang.binding.BindingObject;
import org.opendaylight.yangtools.yang.binding.ChoiceIn;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedListAction;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.binding.RpcOutput;
import org.opendaylight.yangtools.yang.binding.contract.Naming;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ContainerEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PresenceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

final class RootCodecContext<D extends DataObject>
extends DataContainerCodecContext<D, BindingRuntimeTypes>
implements BindingDataObjectCodecTreeNode<D> {
    private final LoadingCache<Class<? extends DataObject>, DataContainerCodecContext<?, ?>> childrenByClass = CacheBuilder.newBuilder().build(new CacheLoader<Class<? extends DataObject>, DataContainerCodecContext<?, ?>>(){

        public DataContainerCodecContext<?, ?> load(Class<? extends DataObject> key) {
            return RootCodecContext.this.createDataTreeChildContext(key);
        }
    });
    private final LoadingCache<Class<? extends Action<?, ?, ?>>, ActionCodecContext> actionsByClass = CacheBuilder.newBuilder().build(new CacheLoader<Class<? extends Action<?, ?, ?>>, ActionCodecContext>(){

        public ActionCodecContext load(Class<? extends Action<?, ?, ?>> key) {
            return RootCodecContext.this.createActionContext(key);
        }
    });
    private final LoadingCache<Class<? extends DataObject>, ChoiceCodecContext<?>> choicesByClass = CacheBuilder.newBuilder().build(new CacheLoader<Class<? extends DataObject>, ChoiceCodecContext<?>>(){

        public ChoiceCodecContext<?> load(Class<? extends DataObject> key) {
            return RootCodecContext.this.createChoiceDataContext(key);
        }
    });
    private final LoadingCache<Class<?>, NotificationCodecContext<?>> notificationsByClass = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, NotificationCodecContext<?>>(){

        public NotificationCodecContext<?> load(Class<?> key) {
            Preconditions.checkArgument((boolean)key.isInterface(), (Object)"Supplied class must be interface.");
            QName qname = BindingReflections.findQName(key);
            RuntimeType runtimeType = RootCodecContext.this.type().schemaTreeChild(qname);
            if (runtimeType instanceof NotificationRuntimeType) {
                NotificationRuntimeType type = (NotificationRuntimeType)runtimeType;
                return new NotificationCodecContext(key, type, RootCodecContext.this.factory());
            }
            throw new IllegalArgumentException("Supplied " + key + " is not valid notification");
        }
    });
    private final LoadingCache<Class<?>, ContainerLikeCodecContext<?>> rpcDataByClass = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, ContainerLikeCodecContext<?>>(){

        public ContainerLikeCodecContext<?> load(Class<?> key) {
            BiFunction<BindingRuntimeTypes, QName, Optional> lookup;
            if (RpcInput.class.isAssignableFrom(key)) {
                lookup = BindingRuntimeTypes::findRpcInput;
            } else if (RpcOutput.class.isAssignableFrom(key)) {
                lookup = BindingRuntimeTypes::findRpcOutput;
            } else {
                throw new IllegalArgumentException(key + " does not represent an RPC container");
            }
            BindingRuntimeContext context = RootCodecContext.this.factory.getRuntimeContext();
            QName qname = BindingReflections.findQName(key);
            QNameModule qnameModule = qname.getModule();
            Module module = (Module)context.getEffectiveModelContext().findModule(qnameModule).orElseThrow(() -> new IllegalArgumentException("Failed to find module for " + qnameModule));
            String className = Naming.getClassName((QName)qname);
            for (RpcDefinition potential : module.getRpcs()) {
                QName potentialQName = potential.getQName();
                if (!key.getSimpleName().equals(Naming.getClassName((QName)potentialQName) + className)) continue;
                ContainerLike schema = RootCodecContext.getRpcDataSchema(potential, qname);
                Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (String)"Schema for %s does not define input / output.", (Object)potentialQName);
                ContainerLikeRuntimeType type = (ContainerLikeRuntimeType)lookup.apply(context.getTypes(), potentialQName).orElseThrow(() -> new IllegalArgumentException("Cannot find runtime type for " + key));
                return new ContainerLikeCodecContext(key, type, RootCodecContext.this.factory);
            }
            throw new IllegalArgumentException("Supplied class " + key + " is not valid RPC class.");
        }
    });
    private final LoadingCache<QName, DataContainerCodecContext<?, ?>> childrenByQName = CacheBuilder.newBuilder().build(new CacheLoader<QName, DataContainerCodecContext<?, ?>>(){

        public DataContainerCodecContext<?, ?> load(QName qname) throws ClassNotFoundException {
            BindingRuntimeTypes type = RootCodecContext.this.type();
            RuntimeType child = RootCodecContext.this.childNonNull(type.schemaTreeChild(qname), qname, "Argument %s is not valid child of %s", qname, type);
            if (!(child instanceof DataRuntimeType)) {
                throw new IncorrectNestingException("Argument %s is not valid data tree child of %s", new Object[]{qname, type});
            }
            EffectiveStatement childSchema = child.statement();
            if (childSchema instanceof DataNodeContainer || childSchema instanceof ChoiceSchemaNode) {
                return RootCodecContext.this.getStreamChild(RootCodecContext.this.factory().getRuntimeContext().loadClass(child.javaType()));
            }
            throw new UnsupportedOperationException("Unsupported child type " + childSchema.getClass());
        }
    });
    private final LoadingCache<SchemaNodeIdentifier.Absolute, RpcInputCodec<?>> rpcDataByPath = CacheBuilder.newBuilder().build(new CacheLoader<SchemaNodeIdentifier.Absolute, RpcInputCodec<?>>(){

        public RpcInputCodec<?> load(SchemaNodeIdentifier.Absolute key) {
            QName rpcName = key.firstNodeIdentifier();
            BindingRuntimeContext context = RootCodecContext.this.factory().getRuntimeContext();
            Class container = switch (key.lastNodeIdentifier().getLocalName()) {
                case "input" -> context.getRpcInput(rpcName);
                case "output" -> context.getRpcOutput(rpcName);
                default -> throw new IllegalArgumentException("Unhandled path " + key);
            };
            return RootCodecContext.this.getRpc(container);
        }
    });
    private final LoadingCache<SchemaNodeIdentifier.Absolute, NotificationCodecContext<?>> notificationsByPath = CacheBuilder.newBuilder().build(new CacheLoader<SchemaNodeIdentifier.Absolute, NotificationCodecContext<?>>(){

        public NotificationCodecContext<?> load(SchemaNodeIdentifier.Absolute key) {
            Class cls = RootCodecContext.this.factory().getRuntimeContext().getClassForSchema(key);
            try {
                return RootCodecContext.this.getNotificationImpl(cls.asSubclass(Notification.class));
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Path " + key + " does not represent a notification", e);
            }
        }
    });
    private static final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier ROOT_NODEID = YangInstanceIdentifier.NodeIdentifier.create((QName)SchemaContext.NAME);
    private final @NonNull CodecContextFactory factory;

    RootCodecContext(CodecContextFactory factory) {
        super(factory.getRuntimeContext().getTypes());
        this.factory = Objects.requireNonNull(factory);
    }

    public DocumentedNode.WithStatus getSchema() {
        return this.factory.getRuntimeContext().getEffectiveModelContext();
    }

    public Class<D> getBindingClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected YangInstanceIdentifier.NodeIdentifier getDomPathArgument() {
        return ROOT_NODEID;
    }

    @Override
    protected CodecContextFactory factory() {
        return this.factory;
    }

    @Override
    protected BindingRuntimeTypes type() {
        return this.factory.getRuntimeContext().getTypes();
    }

    @Override
    public <C extends DataObject> CommonDataObjectCodecContext<C, ?> getStreamChild(Class<C> childClass) {
        NotificationCodecContext<C> result = Notification.class.isAssignableFrom(childClass) ? this.getNotificationImpl(childClass) : RootCodecContext.getOrRethrow(this.childrenByClass, childClass);
        return result;
    }

    @Override
    public <C extends DataObject> CommonDataObjectCodecContext<C, ?> streamChild(Class<C> childClass) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public DataContainerCodecContext<?, ?> yangPathArgumentChild(YangInstanceIdentifier.PathArgument arg) {
        return RootCodecContext.getOrRethrow(this.childrenByQName, arg.getNodeType());
    }

    public D deserialize(NormalizedNode data) {
        throw new UnsupportedOperationException("Could not create Binding data representation for root");
    }

    public NormalizedNode serialize(D data) {
        return this.serializeImpl(data);
    }

    ActionCodecContext getAction(Class<? extends Action<?, ?, ?>> action) {
        return RootCodecContext.getOrRethrow(this.actionsByClass, action);
    }

    NotificationCodecContext<?> getNotification(SchemaNodeIdentifier.Absolute notification) {
        return RootCodecContext.getOrRethrow(this.notificationsByPath, notification);
    }

    NotificationCodecContext<?> getNotification(Class<? extends Notification<?>> notification) {
        return this.getNotificationImpl(notification);
    }

    private NotificationCodecContext<?> getNotificationImpl(Class<?> notification) {
        return RootCodecContext.getOrRethrow(this.notificationsByClass, notification);
    }

    ContainerLikeCodecContext<?> getRpc(Class<? extends DataContainer> rpcInputOrOutput) {
        return RootCodecContext.getOrRethrow(this.rpcDataByClass, rpcInputOrOutput);
    }

    RpcInputCodec<?> getRpc(SchemaNodeIdentifier.Absolute containerPath) {
        return RootCodecContext.getOrRethrow(this.rpcDataByPath, containerPath);
    }

    DataContainerCodecContext<?, ?> createDataTreeChildContext(Class<? extends DataObject> key) {
        GeneratedRuntimeType childSchema = this.childNonNull(this.type().bindingChild(JavaTypeName.create(key)), key, "%s is not top-level item.", key);
        if (childSchema instanceof ContainerLikeRuntimeType) {
            ContainerRuntimeType container;
            ContainerLikeRuntimeType containerLike = (ContainerLikeRuntimeType)childSchema;
            if (childSchema instanceof ContainerRuntimeType && ((ContainerEffectiveStatement)(container = (ContainerRuntimeType)childSchema).statement()).findFirstEffectiveSubstatement(PresenceEffectiveStatement.class).isEmpty()) {
                return new StructuralContainerCodecContext<DataObject>(key, container, this.factory());
            }
            return new ContainerLikeCodecContext<DataObject>(key, containerLike, this.factory());
        }
        if (childSchema instanceof ListRuntimeType) {
            ListRuntimeType list = (ListRuntimeType)childSchema;
            return list.keyType() == null ? new MapCodecContext(key, list, this.factory()) : MapCodecContext.of(key, list, this.factory());
        }
        if (childSchema instanceof ChoiceRuntimeType) {
            ChoiceRuntimeType choice = (ChoiceRuntimeType)childSchema;
            return new ChoiceCodecContext<DataObject>(key, choice, this.factory());
        }
        throw new IncorrectNestingException("%s is not a valid data tree child of %s", new Object[]{key, this});
    }

    ActionCodecContext createActionContext(Class<? extends Action<?, ?, ?>> action) {
        if (KeyedListAction.class.isAssignableFrom(action)) {
            return this.prepareActionContext(2, 3, 4, action, KeyedListAction.class);
        }
        if (Action.class.isAssignableFrom(action)) {
            return this.prepareActionContext(1, 2, 3, action, Action.class);
        }
        throw new IllegalArgumentException("The specific action type does not exist for action " + action.getName());
    }

    private ActionCodecContext prepareActionContext(int inputOffset, int outputOffset, int expectedArgsLength, Class<? extends Action<?, ?, ?>> action, Class<?> actionType) {
        Optional optParamType = ClassLoaderUtils.findParameterizedType(action, actionType);
        Preconditions.checkState((boolean)optParamType.isPresent(), (String)"%s does not specialize %s", action, actionType);
        ParameterizedType paramType = (ParameterizedType)optParamType.orElseThrow();
        Type[] args = paramType.getActualTypeArguments();
        Preconditions.checkArgument((args.length == expectedArgsLength ? 1 : 0) != 0, (String)"Unexpected (%s) Action generatic arguments", (int)args.length);
        ActionRuntimeType schema = this.factory().getRuntimeContext().getActionDefinition(action);
        return new ActionCodecContext(new ContainerLikeCodecContext<RpcInput>(RootCodecContext.asClass(args[inputOffset], RpcInput.class), (ContainerLikeRuntimeType<?, ?>)schema.input(), this.factory()), new ContainerLikeCodecContext<RpcOutput>(RootCodecContext.asClass(args[outputOffset], RpcOutput.class), (ContainerLikeRuntimeType<?, ?>)schema.output(), this.factory()));
    }

    private static <T extends DataObject> Class<? extends T> asClass(Type type, Class<T> target) {
        Verify.verify((boolean)(type instanceof Class), (String)"Type %s is not a class", (Object)type);
        return ((Class)type).asSubclass(target);
    }

    private static @Nullable ContainerLike getRpcDataSchema(@NonNull RpcDefinition rpc, @NonNull QName qname) {
        Objects.requireNonNull(rpc, "Rpc Schema must not be null");
        return switch (Objects.requireNonNull(qname, "QName must not be null").getLocalName()) {
            case "input" -> rpc.getInput();
            case "output" -> rpc.getOutput();
            default -> throw new IllegalArgumentException("Supplied qname " + qname + " does not represent rpc input or output.");
        };
    }

    ChoiceCodecContext<?> createChoiceDataContext(Class<? extends DataObject> caseType) {
        Class<?> choiceClass = RootCodecContext.findCaseChoice(caseType);
        if (choiceClass == null) {
            throw new IllegalArgumentException(caseType + " is not a valid case representation");
        }
        CompositeRuntimeType runtimeType = this.factory().getRuntimeContext().getSchemaDefinition(choiceClass);
        if (!(runtimeType instanceof ChoiceRuntimeType)) {
            throw new IllegalArgumentException(caseType + " does not refer to a choice");
        }
        ChoiceRuntimeType choiceType = (ChoiceRuntimeType)runtimeType;
        return new ChoiceCodecContext(choiceClass, choiceType, this.factory());
    }

    @Override
    protected Object deserializeObject(NormalizedNode normalizedNode) {
        throw new UnsupportedOperationException("Unable to deserialize root");
    }

    public InstanceIdentifier.PathArgument deserializePathArgument(YangInstanceIdentifier.PathArgument arg) {
        Preconditions.checkArgument((arg == null ? 1 : 0) != 0);
        return null;
    }

    public YangInstanceIdentifier.PathArgument serializePathArgument(InstanceIdentifier.PathArgument arg) {
        Preconditions.checkArgument((arg == null ? 1 : 0) != 0);
        return null;
    }

    @Override
    public CommonDataObjectCodecContext<?, ?> bindingPathArgumentChild(InstanceIdentifier.PathArgument arg, List<YangInstanceIdentifier.PathArgument> builder) {
        Optional caseType = arg.getCaseType();
        if (caseType.isPresent()) {
            @NonNull Class type = (Class)caseType.orElseThrow();
            ChoiceCodecContext choice = (ChoiceCodecContext)this.choicesByClass.getUnchecked((Object)type);
            choice.addYangPathArgument(arg, builder);
            CommonDataObjectCodecTreeNode caze = choice.getStreamChild(type);
            caze.addYangPathArgument(arg, builder);
            return caze.bindingPathArgumentChild(arg, (List)builder);
        }
        return super.bindingPathArgumentChild(arg, (List)builder);
    }

    public BindingNormalizedNodeCachingCodec<D> createCachingCodec(ImmutableCollection<Class<? extends BindingObject>> cacheSpecifier) {
        return RootCodecContext.createCachingCodec(this, cacheSpecifier);
    }

    private static Class<?> findCaseChoice(Class<? extends DataObject> caseClass) {
        for (Type type : caseClass.getGenericInterfaces()) {
            Class typeClass;
            if (!(type instanceof Class) || !ChoiceIn.class.isAssignableFrom(typeClass = (Class)type)) continue;
            return typeClass.asSubclass(ChoiceIn.class);
        }
        return null;
    }

    private static <K, V> V getOrRethrow(LoadingCache<K, V> cache, K key) {
        try {
            return (V)cache.getUnchecked(key);
        }
        catch (UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                Throwables.throwIfUnchecked((Throwable)cause);
            }
            throw e;
        }
    }
}

