/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyHistory;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.ImplicitParentAwareStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.MutableStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceKeyCriterion;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.ParserNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementFactory;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.UndeclaredStatementFactory;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.InferredStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.NamespaceAccess;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.ReactorStmtCtx;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.ReplicaStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementDefinitionContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.UndeclaredStmtCtx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class StatementContextBase<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends ReactorStmtCtx<A, D, E>
implements CopyHistory {
    private static final Logger LOG = LoggerFactory.getLogger(StatementContextBase.class);
    private static final byte COPY_ORIGINAL = 0;
    private static final byte COPY_LAST_TYPE_MASK = 3;
    @Deprecated(since="7.0.9", forRemoval=true)
    private static final byte COPY_ADDED_BY_USES = 4;
    private static final byte COPY_ADDED_BY_AUGMENTATION = 8;
    private static final int COPY_CHILD_TYPE_SHIFT = 4;
    private static final CopyType @NonNull [] COPY_TYPE_VALUES = CopyType.values();
    private final byte bitsAight;
    private final @NonNull StatementDefinitionContext<A, D, E> definition;
    private Multimap<ModelProcessingPhase, OnPhaseFinished> phaseListeners = ImmutableMultimap.of();
    private Multimap<ModelProcessingPhase, ContextMutation> phaseMutation = ImmutableMultimap.of();
    private List<StmtContext<?, ?, ?>> effectOfStatement = ImmutableList.of();
    private byte executionOrder;

    StatementContextBase(StatementContextBase<A, D, E> original) {
        super(original);
        this.bitsAight = original.bitsAight;
        this.definition = original.definition;
        this.executionOrder = original.executionOrder;
    }

    StatementContextBase(StatementDefinitionContext<A, D, E> def) {
        this.definition = Objects.requireNonNull(def);
        this.bitsAight = 0;
    }

    StatementContextBase(StatementDefinitionContext<A, D, E> def, CopyType copyType) {
        this.definition = Objects.requireNonNull(def);
        this.bitsAight = (byte)StatementContextBase.copyFlags(copyType);
    }

    StatementContextBase(StatementContextBase<A, D, E> prototype, CopyType copyType, CopyType childCopyType) {
        this.definition = prototype.definition;
        this.bitsAight = (byte)(StatementContextBase.copyFlags(copyType) | prototype.bitsAight & 0xFFFFFFFC | childCopyType.ordinal() << 4);
    }

    private static int copyFlags(CopyType copyType) {
        return StatementContextBase.historyFlags(copyType) | copyType.ordinal();
    }

    private static byte historyFlags(CopyType copyType) {
        return switch (copyType) {
            default -> throw new IncompatibleClassChangeError();
            case CopyType.ADDED_BY_AUGMENTATION -> 8;
            case CopyType.ADDED_BY_USES -> 4;
            case CopyType.ADDED_BY_USES_AUGMENTATION -> 12;
            case CopyType.ORIGINAL -> 0;
        };
    }

    public final Collection<? extends StmtContext<?, ?, ?>> getEffectOfStatement() {
        return this.effectOfStatement;
    }

    public final void addAsEffectOfStatement(Collection<? extends StmtContext<?, ?, ?>> ctxs) {
        if (ctxs.isEmpty()) {
            return;
        }
        if (this.effectOfStatement.isEmpty()) {
            this.effectOfStatement = new ArrayList(ctxs.size());
        }
        this.effectOfStatement.addAll(ctxs);
    }

    public final CopyHistory history() {
        return this;
    }

    @Deprecated(since="7.0.9", forRemoval=true)
    public final boolean isAddedByUses() {
        return (this.bitsAight & 4) != 0;
    }

    @Deprecated(since="8.0.0")
    public final boolean isAugmenting() {
        return (this.bitsAight & 8) != 0;
    }

    public final CopyType getLastOperation() {
        return COPY_TYPE_VALUES[this.bitsAight & 3];
    }

    final CopyType childCopyType() {
        return COPY_TYPE_VALUES[this.bitsAight >> 4 & 3];
    }

    @Override
    final byte executionOrder() {
        return this.executionOrder;
    }

    @Deprecated
    final void setCompletedPhase(ModelProcessingPhase completedPhase) {
        this.executionOrder = completedPhase.executionOrder();
    }

    public final <K, V> void addToNs(ParserNamespace<K, V> type, K key, V value) {
        this.addToNamespace(type, key, value);
    }

    static final Collection<? extends StmtContext.Mutable<?, ?, ?>> mutableEffectiveSubstatements(List<ReactorStmtCtx<?, ?, ?>> effective) {
        return effective instanceof ImmutableCollection ? effective : Collections.unmodifiableCollection(effective);
    }

    private static List<ReactorStmtCtx<?, ?, ?>> shrinkEffective(List<ReactorStmtCtx<?, ?, ?>> effective) {
        return effective.isEmpty() ? ImmutableList.of() : effective;
    }

    static final List<ReactorStmtCtx<?, ?, ?>> removeStatementFromEffectiveSubstatements(List<ReactorStmtCtx<?, ?, ?>> effective, StatementDefinition statementDef) {
        if (effective.isEmpty()) {
            return effective;
        }
        Iterator<ReactorStmtCtx<?, ?, ?>> iterator = effective.iterator();
        while (iterator.hasNext()) {
            StmtContext next = (StmtContext)iterator.next();
            if (!statementDef.equals(next.publicDefinition())) continue;
            iterator.remove();
        }
        return StatementContextBase.shrinkEffective(effective);
    }

    static final List<ReactorStmtCtx<?, ?, ?>> removeStatementFromEffectiveSubstatements(List<ReactorStmtCtx<?, ?, ?>> effective, StatementDefinition statementDef, String statementArg) {
        if (statementArg == null) {
            return StatementContextBase.removeStatementFromEffectiveSubstatements(effective, statementDef);
        }
        if (effective.isEmpty()) {
            return effective;
        }
        Iterator<ReactorStmtCtx<?, ?, ?>> iterator = effective.iterator();
        while (iterator.hasNext()) {
            StmtContext.Mutable next = iterator.next();
            if (!statementDef.equals(next.publicDefinition()) || !statementArg.equals(next.rawArgument())) continue;
            iterator.remove();
        }
        return StatementContextBase.shrinkEffective(effective);
    }

    public final <X, Y extends DeclaredStatement<X>, Z extends EffectiveStatement<X, Y>> StmtContext.Mutable<X, Y, Z> createUndeclaredSubstatement(StatementSupport<X, Y, Z> support, X arg) {
        Objects.requireNonNull(support);
        Preconditions.checkArgument((boolean)(support instanceof UndeclaredStatementFactory), (String)"Unsupported statement support %s", support);
        UndeclaredStmtCtx<X, Y, Z> ret = new UndeclaredStmtCtx<X, Y, Z>(this, support, arg);
        support.onStatementAdded(ret);
        return ret;
    }

    final List<ReactorStmtCtx<?, ?, ?>> addEffectiveSubstatement(List<ReactorStmtCtx<?, ?, ?>> effective, StmtContext.Mutable<?, ?, ?> substatement) {
        ReactorStmtCtx<?, ?, ?> stmt = StatementContextBase.verifyStatement(substatement);
        List<ReactorStmtCtx<?, ?, ?>> resized = this.beforeAddEffectiveStatement(effective, 1);
        this.ensureCompletedExecution(stmt);
        resized.add(stmt);
        return resized;
    }

    static final void afterAddEffectiveSubstatement(StmtContext.Mutable<?, ?, ?> substatement) {
        if (substatement instanceof UndeclaredStmtCtx) {
            UndeclaredStmtCtx undeclared = (UndeclaredStmtCtx)substatement;
            StatementContextBase.finishDeclaration(undeclared);
        }
    }

    private static <X, Y extends DeclaredStatement<X>, Z extends EffectiveStatement<X, Y>> void finishDeclaration(@NonNull UndeclaredStmtCtx<X, Y, Z> substatement) {
        substatement.definition().onDeclarationFinished(substatement, ModelProcessingPhase.FULL_DECLARATION);
    }

    public final void addEffectiveSubstatements(Collection<? extends StmtContext.Mutable<?, ?, ?>> statements) {
        if (!statements.isEmpty()) {
            statements.forEach(StatementContextBase::verifyStatement);
            this.addEffectiveSubstatementsImpl(statements);
        }
    }

    abstract void addEffectiveSubstatementsImpl(Collection<? extends StmtContext.Mutable<?, ?, ?>> var1);

    final List<ReactorStmtCtx<?, ?, ?>> addEffectiveSubstatementsImpl(List<ReactorStmtCtx<?, ?, ?>> effective, Collection<? extends StmtContext.Mutable<?, ?, ?>> statements) {
        List<ReactorStmtCtx<?, ?, ?>> resized = this.beforeAddEffectiveStatement(effective, statements.size());
        Collection<StmtContext.Mutable<?, ?, ?>> casted = statements;
        if (this.executionOrder != 0) {
            for (ReactorStmtCtx reactorStmtCtx : casted) {
                StatementContextBase.ensureCompletedExecution(reactorStmtCtx, this.executionOrder);
            }
        }
        resized.addAll(casted);
        return resized;
    }

    abstract Iterator<ReactorStmtCtx<?, ?, ?>> effectiveChildrenToComplete();

    final void ensureCompletedExecution(ReactorStmtCtx<?, ?, ?> stmt) {
        if (this.executionOrder != 0) {
            StatementContextBase.ensureCompletedExecution(stmt, this.executionOrder);
        }
    }

    private static void ensureCompletedExecution(ReactorStmtCtx<?, ?, ?> stmt, byte executionOrder) {
        Verify.verify((boolean)stmt.tryToCompletePhase(executionOrder), (String)"Statement %s cannot complete phase %s", stmt, (int)executionOrder);
    }

    static final ReactorStmtCtx<?, ?, ?> verifyStatement(StmtContext.Mutable<?, ?, ?> stmt) {
        if (stmt instanceof ReactorStmtCtx) {
            ReactorStmtCtx reactorStmt = (ReactorStmtCtx)stmt;
            return reactorStmt;
        }
        throw new VerifyException("Unexpected statement " + stmt);
    }

    private List<ReactorStmtCtx<?, ?, ?>> beforeAddEffectiveStatement(List<ReactorStmtCtx<?, ?, ?>> effective, int toAdd) {
        Verify.verify((this.executionOrder != 6 ? 1 : 0) != 0, (String)"Cannot modify finished statement at %s", (Object)this.sourceReference());
        return this.beforeAddEffectiveStatementUnsafe(effective, toAdd);
    }

    final List<ReactorStmtCtx<?, ?, ?>> beforeAddEffectiveStatementUnsafe(List<ReactorStmtCtx<?, ?, ?>> effective, int toAdd) {
        ModelProcessingPhase inProgressPhase = this.getRoot().getSourceContext().getInProgressPhase();
        Preconditions.checkState((inProgressPhase == ModelProcessingPhase.FULL_DECLARATION || inProgressPhase == ModelProcessingPhase.EFFECTIVE_MODEL ? 1 : 0) != 0, (String)"Effective statement cannot be added in declared phase at: %s", (Object)this.sourceReference());
        return effective.isEmpty() ? new ArrayList(toAdd) : effective;
    }

    @Override
    final E createEffective() {
        E result = this.createEffective(this.definition.getFactory());
        if (result instanceof MutableStatement) {
            MutableStatement mutable = (MutableStatement)result;
            this.getRoot().addMutableStmtToSeal(mutable);
        }
        return result;
    }

    abstract @NonNull E createEffective(@NonNull StatementFactory<A, D, E> var1);

    abstract Stream<? extends @NonNull ReactorStmtCtx<?, ?, ?>> streamDeclared();

    abstract @NonNull Stream<? extends @NonNull ReactorStmtCtx<?, ?, ?>> streamEffective();

    @Override
    final boolean doTryToCompletePhase(byte targetOrder) {
        boolean finished;
        boolean bl = finished = this.phaseMutation.isEmpty() || this.runMutations(targetOrder);
        if (this.completeChildren(targetOrder) && finished) {
            this.onPhaseCompleted(targetOrder);
            return true;
        }
        return false;
    }

    private boolean completeChildren(byte targetOrder) {
        boolean finished = true;
        for (StatementContextBase<?, ?, ?> child : this.mutableDeclaredSubstatements()) {
            finished &= child.tryToCompletePhase(targetOrder);
        }
        Iterator<ReactorStmtCtx<?, ?, ?>> it = this.effectiveChildrenToComplete();
        while (it.hasNext()) {
            finished &= it.next().tryToCompletePhase(targetOrder);
        }
        return finished;
    }

    private boolean runMutations(byte targetOrder) {
        ModelProcessingPhase phase = (ModelProcessingPhase)Verify.verifyNotNull((Object)ModelProcessingPhase.ofExecutionOrder((byte)targetOrder));
        Collection openMutations = this.phaseMutation.get((Object)phase);
        return openMutations.isEmpty() || this.runMutations(phase, openMutations);
    }

    private boolean runMutations(ModelProcessingPhase phase, Collection<ContextMutation> openMutations) {
        boolean finished = true;
        Iterator<ContextMutation> it = openMutations.iterator();
        while (it.hasNext()) {
            ContextMutation current = it.next();
            if (current.isFinished()) {
                it.remove();
                continue;
            }
            finished = false;
        }
        if (openMutations.isEmpty()) {
            this.phaseMutation.removeAll((Object)phase);
            this.cleanupPhaseMutation();
        }
        return finished;
    }

    private void cleanupPhaseMutation() {
        if (this.phaseMutation.isEmpty()) {
            this.phaseMutation = ImmutableMultimap.of();
        }
    }

    private void onPhaseCompleted(byte completedOrder) {
        ModelProcessingPhase phase;
        Collection listeners;
        this.executionOrder = completedOrder;
        if (completedOrder == 6) {
            this.summarizeSubstatementPolicy();
        }
        if (!(listeners = this.phaseListeners.get((Object)(phase = (ModelProcessingPhase)Verify.verifyNotNull((Object)ModelProcessingPhase.ofExecutionOrder((byte)completedOrder))))).isEmpty()) {
            this.runPhaseListeners(phase, listeners);
        }
    }

    private void summarizeSubstatementPolicy() {
        if (this.definition().support().copyPolicy() == StatementSupport.CopyPolicy.EXACT_REPLICA || this.noSensitiveSubstatements()) {
            this.setAllSubstatementsContextIndependent();
        }
    }

    abstract boolean noSensitiveSubstatements();

    static boolean noSensitiveSubstatements(Collection<? extends ReactorStmtCtx<?, ?, ?>> substatements) {
        block3: for (ReactorStmtCtx<?, ?, ?> stmt : substatements) {
            if (!stmt.isSupportedToBuildEffective()) continue;
            if (!stmt.allSubstatementsContextIndependent()) {
                return false;
            }
            switch (stmt.definition().support().copyPolicy()) {
                case CONTEXT_INDEPENDENT: 
                case EXACT_REPLICA: 
                case IGNORE: {
                    continue block3;
                }
            }
            return false;
        }
        return true;
    }

    private void runPhaseListeners(ModelProcessingPhase phase, Collection<OnPhaseFinished> listeners) {
        Iterator<OnPhaseFinished> listener = listeners.iterator();
        while (listener.hasNext()) {
            OnPhaseFinished next = listener.next();
            if (!next.phaseFinished(this, phase)) continue;
            listener.remove();
        }
        if (listeners.isEmpty()) {
            this.phaseListeners.removeAll((Object)phase);
            if (this.phaseListeners.isEmpty()) {
                this.phaseListeners = ImmutableMultimap.of();
            }
        }
    }

    @Override
    final StatementDefinitionContext<A, D, E> definition() {
        return this.definition;
    }

    final <K, V> void onNamespaceItemAddedAction(final ParserNamespace<K, V> namespace, K key, final OnNamespaceItemAdded listener) {
        NamespaceAccess<K, V> access = this.accessNamespace(namespace);
        V potential = access.valueFrom(this, key);
        if (potential != null) {
            LOG.trace("Listener on {} key {} satisfied immediately", namespace, key);
            listener.namespaceItemAdded(this, namespace, key, potential);
            return;
        }
        access.addListener(key, new NamespaceAccess.KeyedValueAddedListener<K, V>(this){

            @Override
            void onValueAdded(K key, V value) {
                listener.namespaceItemAdded(StatementContextBase.this, namespace, key, value);
            }
        });
    }

    final <K, V> void onNamespaceItemAddedAction(ParserNamespace<K, V> namespace, ModelProcessingPhase phase, NamespaceKeyCriterion<K> criterion, OnNamespaceItemAdded listener) {
        NamespaceAccess<Object, Object> access = this.accessNamespace(namespace);
        Map.Entry<K, V> entry = access.entryFrom(this, criterion);
        if (entry != null) {
            LOG.debug("Listener on {} criterion {} found a pre-existing match: {}", new Object[]{namespace, criterion, entry});
            this.waitForPhase(entry.getValue(), access, phase, criterion, listener);
            return;
        }
        access.addListener((key, value) -> {
            if (criterion.match(key)) {
                LOG.debug("Listener on {} criterion {} matched added key {}", new Object[]{namespace, criterion, key});
                this.waitForPhase(value, access, phase, criterion, listener);
                return true;
            }
            return false;
        });
    }

    private <K, V> void waitForPhase(Object value, NamespaceAccess<K, V> access, ModelProcessingPhase phase, NamespaceKeyCriterion<K> criterion, OnNamespaceItemAdded listener) {
        ((StatementContextBase)value).addPhaseCompletedListener(phase, (context, phaseCompleted) -> {
            Map.Entry match = access.entryFrom(this, criterion);
            if (match == null) {
                throw new IllegalStateException("Failed to find a match for criterion %s in namespace %s node %s".formatted(criterion, access.namespace(), this));
            }
            listener.namespaceItemAdded(this, access.namespace(), match.getKey(), match.getValue());
            return true;
        });
    }

    private static <T> Multimap<ModelProcessingPhase, T> newMultimap() {
        return Multimaps.newListMultimap(new EnumMap(ModelProcessingPhase.class), () -> new ArrayList(1));
    }

    void addPhaseCompletedListener(ModelProcessingPhase phase, OnPhaseFinished listener) {
        Objects.requireNonNull(phase, "Statement context processing phase cannot be null");
        Objects.requireNonNull(listener, "Statement context phase listener cannot be null");
        for (ModelProcessingPhase finishedPhase = ModelProcessingPhase.ofExecutionOrder((byte)this.executionOrder); finishedPhase != null; finishedPhase = finishedPhase.getPreviousPhase()) {
            if (!phase.equals((Object)finishedPhase)) continue;
            listener.phaseFinished(this, finishedPhase);
            return;
        }
        if (this.phaseListeners.isEmpty()) {
            this.phaseListeners = StatementContextBase.newMultimap();
        }
        this.phaseListeners.put((Object)phase, (Object)listener);
    }

    final void addMutation(ModelProcessingPhase phase, ContextMutation mutation) {
        Preconditions.checkState((this.executionOrder < phase.executionOrder() ? 1 : 0) != 0, (String)"Mutation registered after phase was completed at: %s", (Object)this.sourceReference());
        if (this.phaseMutation.isEmpty()) {
            this.phaseMutation = StatementContextBase.newMultimap();
        }
        this.phaseMutation.put((Object)phase, (Object)mutation);
    }

    final void removeMutation(ModelProcessingPhase phase, ContextMutation mutation) {
        if (!this.phaseMutation.isEmpty()) {
            this.phaseMutation.remove((Object)phase, (Object)mutation);
            this.cleanupPhaseMutation();
        }
    }

    public final Optional<StmtContext.Mutable<A, D, E>> copyAsChildOf(StmtContext.Mutable<?, ?, ?> parent, CopyType type, QNameModule targetModule) {
        StatementContextBase.checkEffectiveModelCompleted(this);
        return Optional.ofNullable(this.copyAsChildOfImpl(parent, type, targetModule));
    }

    private @Nullable ReactorStmtCtx<A, D, E> copyAsChildOfImpl(StmtContext.Mutable<?, ?, ?> parent, CopyType type, QNameModule targetModule) {
        StatementSupport<A, D, E> support = this.definition.support();
        StatementSupport.CopyPolicy policy = support.copyPolicy();
        switch (policy) {
            case EXACT_REPLICA: {
                return this.replicaAsChildOf((StmtContext.Mutable)parent);
            }
            case CONTEXT_INDEPENDENT: {
                if (this.allSubstatementsContextIndependent()) {
                    return this.replicaAsChildOf((StmtContext.Mutable)parent);
                }
            }
            case DECLARED_COPY: {
                return (ReactorStmtCtx)parent.childCopyOf((StmtContext)this, type, targetModule);
            }
            case IGNORE: {
                return null;
            }
            case REJECT: {
                throw new IllegalStateException("Statement " + support.getPublicView() + " should never be copied");
            }
        }
        throw new IllegalStateException("Unhandled policy " + policy);
    }

    @Override
    final ReactorStmtCtx<?, ?, ?> asEffectiveChildOf(StatementContextBase<?, ?, ?> parent, CopyType type, QNameModule targetModule) {
        ReactorStmtCtx<A, D, E> copy = this.copyAsChildOfImpl(parent, type, targetModule);
        if (copy == null) {
            return null;
        }
        parent.ensureCompletedExecution(copy);
        return this.canReuseCurrent(copy) ? this : copy;
    }

    private boolean canReuseCurrent(@NonNull ReactorStmtCtx<A, D, E> copy) {
        return this.definition.getFactory().canReuseCurrent(copy, (EffectiveStmtCtx.Current)this, this.buildEffective().effectiveSubstatements()) && this.allSubstatementsContextIndependent();
    }

    public final StmtContext.Mutable<?, ?, ?> childCopyOf(StmtContext<?, ?, ?> stmt, CopyType type, QNameModule targetModule) {
        StatementContextBase.checkEffectiveModelCompleted(stmt);
        if (stmt instanceof StatementContextBase) {
            StatementContextBase base = (StatementContextBase)stmt;
            return this.childCopyOf(base, type, targetModule);
        }
        if (stmt instanceof ReplicaStatementContext) {
            ReplicaStatementContext replica = (ReplicaStatementContext)stmt;
            return replica.replicaAsChildOf(this);
        }
        throw new IllegalArgumentException("Unsupported statement " + stmt);
    }

    private <X, Y extends DeclaredStatement<X>, Z extends EffectiveStatement<X, Y>> StmtContext.Mutable<X, Y, Z> childCopyOf(StatementContextBase<X, Y, Z> original, CopyType type, QNameModule targetModule) {
        InferredStatementContext<X, Y, Z> copy;
        StatementContextBase result;
        Optional<StatementSupport<?, ?, ?>> implicitParent = this.definition.getImplicitParentFor((NamespaceStmtCtx)this, original.publicDefinition());
        if (implicitParent.isPresent()) {
            result = new UndeclaredStmtCtx(this, implicitParent.orElseThrow(), original, type);
            CopyType childCopyType = switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case CopyType.ADDED_BY_AUGMENTATION -> CopyType.ORIGINAL;
                case CopyType.ADDED_BY_USES_AUGMENTATION -> CopyType.ADDED_BY_USES;
                case CopyType.ADDED_BY_USES, CopyType.ORIGINAL -> type;
            };
            copy = new InferredStatementContext<X, Y, Z>(result, original, childCopyType, type, targetModule);
            result.addEffectiveSubstatement(copy);
            result.definition.onStatementAdded(result);
        } else {
            copy = new InferredStatementContext<X, Y, Z>(this, original, type, type, targetModule);
            result = copy;
        }
        original.definition.onStatementAdded(copy);
        return result;
    }

    @Override
    final ReplicaStatementContext<A, D, E> replicaAsChildOf(StatementContextBase<?, ?, ?> parent) {
        return new ReplicaStatementContext(parent, this);
    }

    private static void checkEffectiveModelCompleted(StmtContext<?, ?, ?> stmt) {
        ModelProcessingPhase phase = stmt.getCompletedPhase();
        Preconditions.checkState((phase == ModelProcessingPhase.EFFECTIVE_MODEL ? 1 : 0) != 0, (String)"Attempted to copy statement %s which has completed phase %s", stmt, (Object)phase);
    }

    public final boolean hasImplicitParentSupport() {
        return this.definition.getFactory() instanceof ImplicitParentAwareStatementSupport;
    }

    public final StmtContext<?, ?, ?> wrapWithImplicit(StmtContext<?, ?, ?> original) {
        Optional<StatementSupport<?, ?, ?>> optImplicit = this.definition.getImplicitParentFor((NamespaceStmtCtx)this, original.publicDefinition());
        if (optImplicit.isEmpty()) {
            return original;
        }
        if (original instanceof StatementContextBase) {
            StatementContextBase origBase = (StatementContextBase)original;
            UndeclaredStmtCtx<A, A, A> result = new UndeclaredStmtCtx<A, A, A>(origBase, optImplicit.orElseThrow());
            result.addEffectiveSubstatement(origBase.reparent(result));
            result.setCompletedPhase(original.getCompletedPhase());
            return result;
        }
        throw new IllegalArgumentException("Unsupported original " + original);
    }

    abstract StatementContextBase<A, D, E> reparent(StatementContextBase<?, ?, ?> var1);

    abstract boolean hasEmptySubstatements();

    static {
        int copyTypes = COPY_TYPE_VALUES.length;
        Verify.verify((copyTypes == 4 ? 1 : 0) != 0, (String)"Unexpected %s CopyType values", (int)copyTypes);
    }

    static interface ContextMutation {
        public boolean isFinished();
    }

    static interface OnPhaseFinished
    extends EventListener {
        public boolean phaseFinished(StatementContextBase<?, ?, ?> var1, ModelProcessingPhase var2);
    }

    static interface OnNamespaceItemAdded
    extends EventListener {
        public void namespaceItemAdded(StatementContextBase<?, ?, ?> var1, ParserNamespace<?, ?> var2, Object var3, Object var4);
    }
}

