/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.runtime.osgi.impl;

import com.google.common.base.Verify;
import com.google.common.primitives.UnsignedLong;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.osgi.OSGiBindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.spi.ForwardingBindingRuntimeContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={BindingRuntimeContext.class}, immediate=true)
public final class GlobalBindingRuntimeContext
extends ForwardingBindingRuntimeContext {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalBindingRuntimeContext.class);
    private final UnsignedLong generation;
    private BindingRuntimeContext delegate;

    @Activate
    public GlobalBindingRuntimeContext(@Reference OSGiBindingRuntimeContext osgi) {
        this.generation = osgi.getGeneration();
        this.delegate = (BindingRuntimeContext)osgi.getService();
        LOG.info("Global BindingRuntimeContext generation {} activated", (Object)this.generation);
    }

    protected BindingRuntimeContext delegate() {
        return (BindingRuntimeContext)Verify.verifyNotNull((Object)this.delegate);
    }

    @Deactivate
    void deactivate() {
        this.delegate = null;
        LOG.info("Global BindingRuntimeContext generation {} deactivated", (Object)this.generation);
    }
}

