/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AugmentResolver;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CamelCaseNamingStrategy;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ChoiceGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ClassPlacement;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CollisionDomain;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CompositeRuntimeTypeBuilder;
import org.opendaylight.mdsal.binding.generator.impl.reactor.Generator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.StatementNamespace;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TargetAugmentEffectiveStatement;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.mdsal.binding.generator.impl.rt.DefaultAugmentRuntimeType;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.YangSourceDefinition;
import org.opendaylight.mdsal.binding.model.api.type.builder.AnnotableTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.model.ri.BindingTypes;
import org.opendaylight.mdsal.binding.runtime.api.AugmentRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.CaseRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.odlext.model.api.AugmentIdentifierEffectiveStatement;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

abstract class AbstractAugmentGenerator
extends AbstractCompositeGenerator<AugmentEffectiveStatement, AugmentRuntimeType> {
    static final Comparator<? super AbstractAugmentGenerator> COMPARATOR = (o1, o2) -> {
        Iterator thisIt = ((SchemaNodeIdentifier)((AugmentEffectiveStatement)o1.statement()).argument()).getNodeIdentifiers().iterator();
        Iterator otherIt = ((SchemaNodeIdentifier)((AugmentEffectiveStatement)o2.statement()).argument()).getNodeIdentifiers().iterator();
        while (thisIt.hasNext()) {
            if (!otherIt.hasNext()) {
                return 1;
            }
            int comp = ((QName)thisIt.next()).compareTo((QName)otherIt.next());
            if (comp == 0) continue;
            return comp;
        }
        return otherIt.hasNext() ? -1 : 0;
    };
    private AbstractCompositeGenerator<?, ?> targetGen;

    AbstractAugmentGenerator(AugmentEffectiveStatement statement, AbstractCompositeGenerator<?, ?> parent) {
        super(statement, parent);
    }

    @Override
    final StatementNamespace namespace() {
        return StatementNamespace.AUGMENT;
    }

    @Override
    final void pushToInference(SchemaInferenceStack dataTree) {
        dataTree.enterSchemaTree((SchemaNodeIdentifier)((AugmentEffectiveStatement)this.statement()).argument());
    }

    @Override
    final AbstractQName localName() {
        throw new UnsupportedOperationException();
    }

    @Override
    ClassPlacement classPlacement() {
        AbstractCompositeGenerator<?, ?> target = this.targetGenerator();
        return target instanceof ChoiceGenerator ? ClassPlacement.PHANTOM : super.classPlacement();
    }

    @Override
    final CollisionDomain.Member createMember(CollisionDomain domain) {
        AbstractQName explicitIdentifier = ((AugmentEffectiveStatement)this.statement()).findFirstEffectiveSubstatementArgument(AugmentIdentifierEffectiveStatement.class).orElse(null);
        if (explicitIdentifier != null) {
            return domain.addPrimary(this, new CamelCaseNamingStrategy(StatementNamespace.AUGMENT, explicitIdentifier));
        }
        CollisionDomain.Member target = this.targetGenerator().getMember();
        int offset = 1;
        for (Generator gen : this.getParent()) {
            AbstractAugmentGenerator aug;
            if (gen == this) break;
            if (!(gen instanceof AbstractAugmentGenerator) || !target.equalRoot((aug = (AbstractAugmentGenerator)gen).targetGenerator().getMember())) continue;
            ++offset;
        }
        return domain.addSecondary(this, target, String.valueOf(offset), (SchemaNodeIdentifier)((AugmentEffectiveStatement)this.statement()).argument());
    }

    @Override
    final GeneratedType createTypeImpl(TypeBuilderFactory builderFactory) {
        GeneratedTypeBuilder builder = builderFactory.newGeneratedTypeBuilder(this.typeName());
        YangSourceDefinition.of((ModuleEffectiveStatement)((ModuleEffectiveStatement)this.currentModule().statement()), this.statement()).ifPresent(arg_0 -> ((GeneratedTypeBuilder)builder).setYangSourceDefinition(arg_0));
        builder.addImplementsType((Type)BindingTypes.augmentation((Type)this.targetGenerator().getGeneratedType(builderFactory)));
        this.addUsesInterfaces(builder, builderFactory);
        AbstractAugmentGenerator.addConcreteInterfaceMethods(builder);
        this.addGetterMethods(builder, builderFactory);
        this.annotateDeprecatedIfNecessary((AnnotableTypeBuilder)builder);
        return builder.build();
    }

    boolean matchesInstantiated(AugmentEffectiveStatement statement) {
        return ((AugmentEffectiveStatement)this.statement()).equals(statement);
    }

    final void fillRuntimeCasesIn(AugmentResolver resolver, ChoiceEffectiveStatement stmt, List<CaseRuntimeType> toList) {
        toList.addAll(this.createBuilder(this.effectiveIn((SchemaTreeAwareEffectiveStatement<?, ?>)stmt)).populate(resolver, this).getCaseChilden());
    }

    final @NonNull AugmentRuntimeType runtimeTypeIn(AugmentResolver resolver, EffectiveStatement<?, ?> stmt) {
        Verify.verify((boolean)(stmt instanceof SchemaTreeAwareEffectiveStatement), (String)"Unexpected target statement %s", stmt);
        return (AugmentRuntimeType)Verify.verifyNotNull((Object)((AugmentRuntimeType)this.createInternalRuntimeType(resolver, this.effectiveIn((SchemaTreeAwareEffectiveStatement)stmt))));
    }

    abstract @NonNull TargetAugmentEffectiveStatement effectiveIn(SchemaTreeAwareEffectiveStatement<?, ?> var1);

    final @NonNull TargetAugmentEffectiveStatement effectiveIn(SchemaTreeAwareEffectiveStatement<?, ?> target, Function<QName, QName> transform) {
        AugmentEffectiveStatement augment = (AugmentEffectiveStatement)this.statement();
        List stmts = augment.effectiveSubstatements();
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)stmts.size());
        for (EffectiveStatement child : stmts) {
            if (child instanceof SchemaTreeEffectiveStatement) {
                SchemaTreeEffectiveStatement schemaTreeChild = (SchemaTreeEffectiveStatement)child;
                QName qname = (QName)schemaTreeChild.argument();
                target.findSchemaTreeNode(transform.apply(qname)).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                continue;
            }
            builder.add((Object)child);
        }
        return new TargetAugmentEffectiveStatement(augment, target, builder.build());
    }

    @Override
    final void addAsGetterMethod(GeneratedTypeBuilderBase<?> builder, TypeBuilderFactory builderFactory) {
    }

    @Override
    CompositeRuntimeTypeBuilder<AugmentEffectiveStatement, AugmentRuntimeType> createBuilder(AugmentEffectiveStatement statement) {
        return new CompositeRuntimeTypeBuilder<AugmentEffectiveStatement, AugmentRuntimeType>(statement){

            @Override
            AugmentRuntimeType build(GeneratedType type, AugmentEffectiveStatement statement, List<RuntimeType> children, List<AugmentRuntimeType> augments) {
                Verify.verify((boolean)augments.isEmpty(), (String)"Unexpected augments %s", augments);
                return new DefaultAugmentRuntimeType(type, statement, children);
            }
        };
    }

    final void setTargetGenerator(AbstractCompositeGenerator<?, ?> targetGenerator) {
        Verify.verify((this.targetGen == null ? 1 : 0) != 0, (String)"Attempted to relink %s, already have target %s", (Object)this, this.targetGen);
        this.targetGen = Objects.requireNonNull(targetGenerator);
    }

    final @NonNull AbstractCompositeGenerator<?, ?> targetGenerator() {
        return (AbstractCompositeGenerator)Verify.verifyNotNull(this.targetGen, (String)"No target for %s", (Object[])new Object[]{this});
    }
}

