/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AugmentResolver;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CamelCaseNamingStrategy;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ClassPlacement;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CollisionDomain;
import org.opendaylight.mdsal.binding.generator.impl.reactor.Generator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.OriginalLink;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.mdsal.binding.generator.impl.tree.StatementRepresentation;
import org.opendaylight.mdsal.binding.model.api.MethodSignature;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.TypeMemberComment;
import org.opendaylight.mdsal.binding.model.api.type.builder.AnnotableTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.yang.binding.contract.Naming;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AddedByUsesAware;
import org.opendaylight.yangtools.yang.model.api.CopyableNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DescriptionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExplicitGenerator<S extends EffectiveStatement<?, ?>, R extends RuntimeType>
extends Generator
implements CopyableNode,
StatementRepresentation<S> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractExplicitGenerator.class);
    private final @NonNull S statement;
    private AbstractExplicitGenerator<S, R> prev;
    private AbstractExplicitGenerator<S, R> orig;
    private @Nullable R runtimeType;
    private boolean runtimeTypeInitialized;

    AbstractExplicitGenerator(S statement) {
        this.statement = (EffectiveStatement)Objects.requireNonNull(statement);
    }

    AbstractExplicitGenerator(S statement, AbstractCompositeGenerator<?, ?> parent) {
        super(parent);
        this.statement = (EffectiveStatement)Objects.requireNonNull(statement);
    }

    @Override
    public final @NonNull S statement() {
        return this.statement;
    }

    public final Optional<R> runtimeType() {
        if (!this.runtimeTypeInitialized) {
            Type type = this.runtimeJavaType();
            if (type != null) {
                this.runtimeType = this.createExternalRuntimeType(type);
            }
            this.runtimeTypeInitialized = true;
        }
        return Optional.ofNullable(this.runtimeType);
    }

    @Nullable Type runtimeJavaType() {
        return this.generatedType().orElse(null);
    }

    abstract @NonNull R createExternalRuntimeType(@NonNull Type var1);

    final @Nullable R createInternalRuntimeType(@NonNull AugmentResolver resolver, @NonNull S stmt) {
        AbstractExplicitGenerator<S, R> gen = this;
        do {
            Type type;
            if ((type = gen.runtimeJavaType()) == null) continue;
            return this.createInternalRuntimeType(resolver, stmt, type);
        } while ((gen = gen.previous()) != null);
        return null;
    }

    abstract @NonNull R createInternalRuntimeType(@NonNull AugmentResolver var1, @NonNull S var2, @NonNull Type var3);

    public final boolean isAddedByUses() {
        AddedByUsesAware aware;
        S s = this.statement;
        return s instanceof AddedByUsesAware && (aware = (AddedByUsesAware)s).isAddedByUses();
    }

    public final boolean isAugmenting() {
        CopyableNode copyable;
        S s = this.statement;
        return s instanceof CopyableNode && (copyable = (CopyableNode)s).isAugmenting();
    }

    final boolean linkOriginalGenerator() {
        if (this.orig != null) {
            return true;
        }
        if (this.prev == null) {
            LOG.trace("Linking {}", (Object)this);
            if (!this.isAddedByUses() && !this.isAugmenting()) {
                this.orig = this.prev = this;
                LOG.trace("Linked {} to self", (Object)this);
                return true;
            }
            OriginalLink link = this.getParent().originalChild(this.getQName());
            if (link == null) {
                LOG.trace("Cannot link {} yet", (Object)this);
                return false;
            }
            this.prev = link.previous();
            this.orig = link.original();
            if (this.orig != null) {
                LOG.trace("Linked {} to {} original {}", new Object[]{this, this.prev, this.orig});
                return true;
            }
            LOG.trace("Linked {} to intermediate {}", (Object)this, this.prev);
            return false;
        }
        this.orig = this.prev.originalLink().original();
        if (this.orig != null) {
            LOG.trace("Linked {} to original {}", (Object)this, this.orig);
            return true;
        }
        return false;
    }

    final @Nullable AbstractExplicitGenerator<S, R> previous() {
        AbstractExplicitGenerator local = (AbstractExplicitGenerator)Verify.verifyNotNull(this.prev, (String)"Generator %s does not have linkage to previous instance resolved", (Object[])new Object[]{this});
        return local == this ? null : local;
    }

    @NonNull AbstractExplicitGenerator<S, R> getOriginal() {
        return (AbstractExplicitGenerator)Verify.verifyNotNull(this.orig, (String)"Generator %s does not have linkage to original instance resolved", (Object[])new Object[]{this});
    }

    @Nullable AbstractExplicitGenerator<S, R> tryOriginal() {
        return this.orig;
    }

    final @NonNull OriginalLink<S, R> originalLink() {
        AbstractExplicitGenerator<S, R> local = this.prev;
        if (local == null) {
            return OriginalLink.partial(this);
        }
        if (local == this) {
            return OriginalLink.complete(this);
        }
        return OriginalLink.partial(local);
    }

    @Nullable AbstractExplicitGenerator<?, ?> findSchemaTreeGenerator(QName qname) {
        return this.findLocalSchemaTreeGenerator(qname);
    }

    final @Nullable AbstractExplicitGenerator<?, ?> findLocalSchemaTreeGenerator(QName qname) {
        for (Generator child : this) {
            SchemaTreeEffectiveStatement stmt;
            AbstractExplicitGenerator gen;
            S s;
            if (!(child instanceof AbstractExplicitGenerator) || !((s = (gen = (AbstractExplicitGenerator)child).statement()) instanceof SchemaTreeEffectiveStatement) || !qname.equals((stmt = (SchemaTreeEffectiveStatement)s).argument())) continue;
            return gen;
        }
        return null;
    }

    final @NonNull QName getQName() {
        Object arg = this.statement.argument();
        if (arg instanceof QName) {
            QName qname = (QName)arg;
            return qname;
        }
        throw new VerifyException("Unexpected argument " + arg);
    }

    @NonNull AbstractQName localName() {
        Object arg = this.statement.argument();
        if (arg instanceof AbstractQName) {
            AbstractQName aqn = (AbstractQName)arg;
            return aqn;
        }
        throw new VerifyException("Illegal argument " + arg);
    }

    @Override
    ClassPlacement classPlacement() {
        return this.isAddedByUses() || this.isAugmenting() ? ClassPlacement.NONE : ClassPlacement.TOP_LEVEL;
    }

    @Override
    CollisionDomain.Member createMember(CollisionDomain domain) {
        return domain.addPrimary(this, new CamelCaseNamingStrategy(this.namespace(), this.localName()));
    }

    void addAsGetterMethod(@NonNull GeneratedTypeBuilderBase<?> builder, @NonNull TypeBuilderFactory builderFactory) {
        if (this.isAugmenting()) {
            return;
        }
        if (this.isAddedByUses()) {
            this.addAsGetterMethodOverride(builder, builderFactory);
            return;
        }
        Type returnType = this.methodReturnType(builderFactory);
        this.constructGetter(builder, returnType);
        this.constructRequire(builder, returnType);
    }

    MethodSignatureBuilder constructGetter(GeneratedTypeBuilderBase<?> builder, Type returnType) {
        return this.constructGetter(builder, returnType, Naming.getGetterMethodName((String)this.localName().getLocalName()));
    }

    final MethodSignatureBuilder constructGetter(GeneratedTypeBuilderBase<?> builder, Type returnType, String methodName) {
        MethodSignatureBuilder getMethod = (MethodSignatureBuilder)builder.addMethod(methodName).setReturnType(returnType);
        this.annotateDeprecatedIfNecessary((AnnotableTypeBuilder)getMethod);
        this.statement.findFirstEffectiveSubstatementArgument(DescriptionEffectiveStatement.class).map(TypeMemberComment::referenceOf).ifPresent(arg_0 -> ((MethodSignatureBuilder)getMethod).setComment(arg_0));
        return getMethod;
    }

    void constructRequire(GeneratedTypeBuilderBase<?> builder, Type returnType) {
    }

    final void constructRequireImpl(GeneratedTypeBuilderBase<?> builder, Type returnType) {
        this.constructGetter(builder, returnType, Naming.getRequireMethodName((String)this.localName().getLocalName())).setDefault(true).setMechanics(MethodSignature.ValueMechanics.NONNULL);
    }

    void addAsGetterMethodOverride(@NonNull GeneratedTypeBuilderBase<?> builder, @NonNull TypeBuilderFactory builderFactory) {
    }

    @NonNull Type methodReturnType(@NonNull TypeBuilderFactory builderFactory) {
        return this.getGeneratedType(builderFactory);
    }

    final void annotateDeprecatedIfNecessary(AnnotableTypeBuilder builder) {
        AbstractExplicitGenerator.annotateDeprecatedIfNecessary(this.statement, builder);
    }

    @Override
    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        helper.add("argument", this.statement.argument());
        if (this.isAddedByUses()) {
            helper.addValue((Object)"addedByUses");
        }
        if (this.isAugmenting()) {
            helper.addValue((Object)"augmenting");
        }
        return helper;
    }
}

