/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.generator.BindingGeneratorUtil;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractDependentGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractExplicitGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ClassPlacement;
import org.opendaylight.mdsal.binding.generator.impl.reactor.GeneratedUnionBuilder;
import org.opendaylight.mdsal.binding.generator.impl.reactor.GeneratorContext;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeReference;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypedefGenerator;
import org.opendaylight.mdsal.binding.model.api.ConcreteType;
import org.opendaylight.mdsal.binding.model.api.Enumeration;
import org.opendaylight.mdsal.binding.model.api.GeneratedProperty;
import org.opendaylight.mdsal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.Restrictions;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.YangSourceDefinition;
import org.opendaylight.mdsal.binding.model.api.type.builder.AnnotableTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.TypeMemberBuilder;
import org.opendaylight.mdsal.binding.model.ri.BaseYangTypes;
import org.opendaylight.mdsal.binding.model.ri.BindingTypes;
import org.opendaylight.mdsal.binding.model.ri.Types;
import org.opendaylight.mdsal.binding.model.ri.generated.type.builder.AbstractEnumerationBuilder;
import org.opendaylight.mdsal.binding.model.ri.generated.type.builder.GeneratedPropertyBuilderImpl;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.binding.RegexPatterns;
import org.opendaylight.yangtools.yang.binding.contract.Naming;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.PathExpression;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.ModelStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.BaseEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LengthEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PathEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PatternEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RangeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.ModifierKind;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.TypeDefinitions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractTypeObjectGenerator<S extends EffectiveStatement<?, ?>, R extends RuntimeType>
extends AbstractDependentGenerator<S, R> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTypeObjectGenerator.class);
    static final ImmutableMap<QName, Type> SIMPLE_TYPES = ImmutableMap.builder().put((Object)TypeDefinitions.BINARY, (Object)BaseYangTypes.BINARY_TYPE).put((Object)TypeDefinitions.BOOLEAN, (Object)BaseYangTypes.BOOLEAN_TYPE).put((Object)TypeDefinitions.DECIMAL64, (Object)BaseYangTypes.DECIMAL64_TYPE).put((Object)TypeDefinitions.EMPTY, (Object)BaseYangTypes.EMPTY_TYPE).put((Object)TypeDefinitions.INSTANCE_IDENTIFIER, (Object)BaseYangTypes.INSTANCE_IDENTIFIER).put((Object)TypeDefinitions.INT8, (Object)BaseYangTypes.INT8_TYPE).put((Object)TypeDefinitions.INT16, (Object)BaseYangTypes.INT16_TYPE).put((Object)TypeDefinitions.INT32, (Object)BaseYangTypes.INT32_TYPE).put((Object)TypeDefinitions.INT64, (Object)BaseYangTypes.INT64_TYPE).put((Object)TypeDefinitions.STRING, (Object)BaseYangTypes.STRING_TYPE).put((Object)TypeDefinitions.UINT8, (Object)BaseYangTypes.UINT8_TYPE).put((Object)TypeDefinitions.UINT16, (Object)BaseYangTypes.UINT16_TYPE).put((Object)TypeDefinitions.UINT32, (Object)BaseYangTypes.UINT32_TYPE).put((Object)TypeDefinitions.UINT64, (Object)BaseYangTypes.UINT64_TYPE).build();
    private final TypeEffectiveStatement<?> type;
    private TypedefGenerator baseGen;
    private TypeReference refType;
    private List<GeneratedType> auxiliaryGeneratedTypes = List.of();
    private UnionDependencies unionDependencies;
    private List<AbstractTypeObjectGenerator<?, ?>> inferred = List.of();
    private Type methodReturnTypeElement;

    AbstractTypeObjectGenerator(S statement, AbstractCompositeGenerator<?, ?> parent) {
        super(statement, parent);
        this.type = (TypeEffectiveStatement)this.statement().findFirstEffectiveSubstatement(TypeEffectiveStatement.class).orElseThrow();
    }

    @Override
    public final List<GeneratedType> auxiliaryGeneratedTypes() {
        return this.auxiliaryGeneratedTypes;
    }

    @Override
    final void linkDependencies(GeneratorContext context) {
        Verify.verify((this.inferred != null ? 1 : 0) != 0, (String)"Duplicate linking of %s", (Object)this);
        QName typeName = (QName)this.type.argument();
        if (AbstractTypeObjectGenerator.isBuiltinName(typeName)) {
            Verify.verify((boolean)this.inferred.isEmpty(), (String)"Unexpected non-empty downstreams in %s", (Object)this);
            this.inferred = null;
            return;
        }
        AbstractExplicitGenerator prev = this.previous();
        if (prev != null) {
            Verify.verify((boolean)(prev instanceof AbstractTypeObjectGenerator), (String)"Unexpected previous %s", prev);
            ((AbstractTypeObjectGenerator)prev).linkInferred(this);
        } else {
            this.linkBaseGen(context.resolveTypedef(typeName));
        }
    }

    private void linkInferred(AbstractTypeObjectGenerator<?, ?> downstream) {
        if (this.inferred == null) {
            downstream.linkBaseGen((TypedefGenerator)Verify.verifyNotNull((Object)this.baseGen, (String)"Mismatch on linking between %s and %s", (Object[])new Object[]{this, downstream}));
            return;
        }
        if (this.inferred.isEmpty()) {
            this.inferred = new ArrayList(2);
        }
        this.inferred.add(downstream);
    }

    private void linkBaseGen(TypedefGenerator upstreamBaseGen) {
        Verify.verify((this.baseGen == null ? 1 : 0) != 0, (String)"Attempted to replace base %s with %s in %s", (Object)this.baseGen, (Object)upstreamBaseGen, (Object)this);
        List downstreams = (List)Verify.verifyNotNull(this.inferred, (String)"Duplicated linking of %s", (Object[])new Object[]{this});
        this.baseGen = (TypedefGenerator)Verify.verifyNotNull((Object)upstreamBaseGen);
        this.baseGen.addDerivedGenerator(this);
        this.inferred = null;
        for (AbstractTypeObjectGenerator downstream : downstreams) {
            downstream.linkBaseGen(upstreamBaseGen);
        }
    }

    void bindTypeDefinition(GeneratorContext context) {
        if (this.baseGen != null) {
            return;
        }
        QName arg = (QName)this.type.argument();
        if (TypeDefinitions.IDENTITYREF.equals((Object)arg)) {
            this.refType = TypeReference.identityRef(this.type.streamEffectiveSubstatements(BaseEffectiveStatement.class).map(ModelStatement::argument).map(context::resolveIdentity).collect(Collectors.toUnmodifiableList()));
        } else if (TypeDefinitions.LEAFREF.equals((Object)arg)) {
            this.refType = this.resolveLeafref(context);
        } else if (TypeDefinitions.UNION.equals((Object)arg)) {
            this.unionDependencies = new UnionDependencies(this.type, context);
            LOG.trace("Resolved union {} to dependencies {}", this.type, (Object)this.unionDependencies);
        }
        LOG.trace("Resolved base {} to generator {}", this.type, (Object)this.refType);
        this.bindDerivedGenerators(this.refType);
    }

    final void bindTypeDefinition(@Nullable TypeReference reference) {
        this.refType = reference;
        LOG.trace("Resolved derived {} to generator {}", this.type, (Object)this.refType);
    }

    private @NonNull TypeReference resolveLeafref(GeneratorContext context) {
        AbstractTypeObjectGenerator<?, ?> targetGenerator;
        try {
            targetGenerator = context.resolveLeafref((PathExpression)this.type.findFirstEffectiveSubstatementArgument(PathEffectiveStatement.class).orElseThrow());
        }
        catch (IllegalArgumentException e) {
            return TypeReference.leafRef(e);
        }
        Preconditions.checkArgument((targetGenerator != this ? 1 : 0) != 0, (String)"Effective model contains self-referencing leaf %s", (Object)this.statement().argument());
        return TypeReference.leafRef(targetGenerator);
    }

    private static boolean isBuiltinName(QName typeName) {
        return YangConstants.RFC6020_YANG_MODULE.equals((Object)typeName.getModule());
    }

    abstract void bindDerivedGenerators(@Nullable TypeReference var1);

    @Override
    final ClassPlacement classPlacement() {
        if (this.refType != null) {
            return ClassPlacement.NONE;
        }
        if (this.isDerivedEnumeration()) {
            return ClassPlacement.NONE;
        }
        return this.classPlacementImpl();
    }

    @NonNull ClassPlacement classPlacementImpl() {
        return this.baseGen != null || SIMPLE_TYPES.containsKey(this.type.argument()) || this.isAddedByUses() || this.isAugmenting() ? ClassPlacement.NONE : ClassPlacement.MEMBER;
    }

    @Override
    final GeneratedType getGeneratedType(TypeBuilderFactory builderFactory) {
        return this.isDerivedEnumeration() ? this.baseGen.getGeneratedType(builderFactory) : super.getGeneratedType(builderFactory);
    }

    final boolean isEnumeration() {
        return this.baseGen != null ? this.baseGen.isEnumeration() : TypeDefinitions.ENUMERATION.equals(this.type.argument());
    }

    final boolean isDerivedEnumeration() {
        return this.baseGen != null && this.baseGen.isEnumeration();
    }

    @Override
    Type methodReturnType(TypeBuilderFactory builderFactory) {
        return this.methodReturnElementType(builderFactory);
    }

    @Override
    final Type runtimeJavaType() {
        if (this.methodReturnTypeElement != null) {
            return this.methodReturnTypeElement;
        }
        Optional<GeneratedType> genType = this.generatedType();
        if (genType.isPresent()) {
            return (Type)genType.orElseThrow();
        }
        AbstractExplicitGenerator prev = (AbstractExplicitGenerator)Verify.verifyNotNull(this.previous(), (String)"No previous generator for %s", (Object[])new Object[]{this});
        return prev.runtimeJavaType();
    }

    final @NonNull Type methodReturnElementType(@NonNull TypeBuilderFactory builderFactory) {
        Type local = this.methodReturnTypeElement;
        if (local == null) {
            this.methodReturnTypeElement = local = this.createMethodReturnElementType(builderFactory);
        }
        return local;
    }

    private @NonNull Type createMethodReturnElementType(@NonNull TypeBuilderFactory builderFactory) {
        GeneratedType baseType;
        GeneratedType generatedType = this.tryGeneratedType(builderFactory);
        if (generatedType != null) {
            return generatedType;
        }
        if (this.refType != null) {
            return this.refType.methodReturnType(builderFactory);
        }
        AbstractExplicitGenerator prev = this.previous();
        if (prev != null) {
            return prev.methodReturnType(builderFactory);
        }
        if (this.baseGen == null) {
            QName qname = (QName)this.type.argument();
            baseType = (Type)Verify.verifyNotNull((Object)((Type)SIMPLE_TYPES.get((Object)qname)), (String)"Cannot resolve type %s in %s", (Object[])new Object[]{qname, this});
        } else {
            baseType = this.baseGen.getGeneratedType(builderFactory);
        }
        return AbstractTypeObjectGenerator.restrictType((Type)baseType, this.computeRestrictions(), builderFactory);
    }

    private static @NonNull Type restrictType(@NonNull Type baseType, Restrictions restrictions, TypeBuilderFactory builderFactory) {
        if (restrictions == null || restrictions.isEmpty()) {
            return baseType;
        }
        if (!(baseType instanceof GeneratedTransferObject)) {
            return Types.restrictedType((Type)baseType, (Restrictions)restrictions);
        }
        GeneratedTransferObject gto = (GeneratedTransferObject)baseType;
        GeneratedTOBuilder builder = builderFactory.newGeneratedTOBuilder((JavaTypeName)gto.getIdentifier());
        GeneratedTransferObject parent = gto.getSuperType();
        if (parent != null) {
            builder.setExtendsType(parent);
        }
        builder.setRestrictions(restrictions);
        for (GeneratedProperty gp : gto.getProperties()) {
            ((GeneratedPropertyBuilder)((GeneratedPropertyBuilder)((GeneratedPropertyBuilder)builder.addProperty(gp.getName()).setValue(gp.getValue()).setReadOnly(gp.isReadOnly()).setAccessModifier(gp.getAccessModifier())).setReturnType(gp.getReturnType())).setFinal(gp.isFinal())).setStatic(gp.isStatic());
        }
        return builder.build();
    }

    @Override
    final void addAsGetterMethodOverride(GeneratedTypeBuilderBase<?> builder, TypeBuilderFactory builderFactory) {
        if (!(this.refType instanceof TypeReference.ResolvedLeafref)) {
            return;
        }
        AbstractTypeObjectGenerator prev = (AbstractTypeObjectGenerator)Verify.verifyNotNull(this.previous(), (String)"Missing previous link in %s", (Object[])new Object[]{this});
        if (prev.refType instanceof TypeReference.ResolvedLeafref) {
            return;
        }
        Type myType = this.methodReturnType(builderFactory);
        LOG.trace("Override of {} to {}", (Object)this, (Object)myType);
        MethodSignatureBuilder getter = this.constructGetter(builder, myType);
        getter.addAnnotation(OVERRIDE_ANNOTATION);
        this.annotateDeprecatedIfNecessary((AnnotableTypeBuilder)getter);
    }

    final @Nullable Restrictions computeRestrictions() {
        List length = this.type.findFirstEffectiveSubstatementArgument(LengthEffectiveStatement.class).orElse(List.of());
        List range = this.type.findFirstEffectiveSubstatementArgument(RangeEffectiveStatement.class).orElse(List.of());
        List patterns = this.type.streamEffectiveSubstatements(PatternEffectiveStatement.class).map(ModelStatement::argument).collect(Collectors.toUnmodifiableList());
        if (length.isEmpty() && range.isEmpty() && patterns.isEmpty()) {
            return null;
        }
        return BindingGeneratorUtil.getRestrictions(this.extractTypeDefinition());
    }

    @Override
    final GeneratedType createTypeImpl(TypeBuilderFactory builderFactory) {
        if (this.baseGen != null) {
            GeneratedType baseType = this.baseGen.getGeneratedType(builderFactory);
            Verify.verify((boolean)(baseType instanceof GeneratedTransferObject), (String)"Unexpected base type %s", (Object)baseType);
            return this.createDerivedType(builderFactory, (GeneratedTransferObject)baseType);
        }
        boolean isTypedef = this instanceof TypedefGenerator;
        QName arg = (QName)this.type.argument();
        if (TypeDefinitions.BITS.equals((Object)arg)) {
            return AbstractTypeObjectGenerator.createBits(builderFactory, this.statement(), this.typeName(), this.currentModule(), (BitsTypeDefinition)this.extractTypeDefinition(), isTypedef);
        }
        if (TypeDefinitions.ENUMERATION.equals((Object)arg)) {
            return AbstractTypeObjectGenerator.createEnumeration(builderFactory, this.statement(), this.typeName(), this.currentModule(), (EnumTypeDefinition)this.extractTypeDefinition());
        }
        if (TypeDefinitions.UNION.equals((Object)arg)) {
            ArrayList<GeneratedType> tmp = new ArrayList<GeneratedType>(1);
            GeneratedTransferObject ret = AbstractTypeObjectGenerator.createUnion(tmp, builderFactory, this.statement(), this.unionDependencies, this.typeName(), this.currentModule(), this.type, isTypedef, this.extractTypeDefinition());
            this.auxiliaryGeneratedTypes = List.copyOf(tmp);
            return ret;
        }
        return AbstractTypeObjectGenerator.createSimple(builderFactory, this.statement(), this.typeName(), this.currentModule(), (Type)Verify.verifyNotNull((Object)((Type)SIMPLE_TYPES.get((Object)arg)), (String)"Unhandled type %s", (Object[])new Object[]{arg}), this.extractTypeDefinition());
    }

    private static @NonNull GeneratedTransferObject createBits(TypeBuilderFactory builderFactory, EffectiveStatement<?, ?> definingStatement, JavaTypeName typeName, ModuleGenerator module, BitsTypeDefinition typedef, boolean isTypedef) {
        GeneratedTOBuilder builder = builderFactory.newGeneratedTOBuilder(typeName);
        builder.setTypedef(isTypedef);
        builder.addImplementsType((Type)BindingTypes.BITS_TYPE_OBJECT);
        builder.setBaseType((TypeDefinition)typedef);
        YangSourceDefinition.of((ModuleEffectiveStatement)((ModuleEffectiveStatement)module.statement()), definingStatement).ifPresent(arg_0 -> ((GeneratedTOBuilder)builder).setYangSourceDefinition(arg_0));
        for (BitsTypeDefinition.Bit bit : typedef.getBits()) {
            String name = bit.getName();
            GeneratedPropertyBuilder genPropertyBuilder = builder.addProperty(Naming.getPropertyName((String)name));
            genPropertyBuilder.setReadOnly(true);
            genPropertyBuilder.setReturnType((Type)Types.primitiveBooleanType());
            builder.addEqualsIdentity(genPropertyBuilder);
            builder.addHashIdentity(genPropertyBuilder);
            builder.addToStringProperty(genPropertyBuilder);
        }
        builder.addConstant((Type)Types.immutableSetTypeFor((Type)Types.STRING), "VALID_NAMES", (Object)typedef);
        builder.setModuleName(((UnresolvedQName.Unqualified)((ModuleEffectiveStatement)module.statement()).argument()).getLocalName());
        builderFactory.addCodegenInformation((DocumentedNode)typedef, (GeneratedTypeBuilderBase<?>)builder);
        AbstractTypeObjectGenerator.annotateDeprecatedIfNecessary((DocumentedNode.WithStatus)typedef, (AnnotableTypeBuilder)builder);
        AbstractTypeObjectGenerator.makeSerializable(builder);
        return builder.build();
    }

    private static @NonNull Enumeration createEnumeration(TypeBuilderFactory builderFactory, EffectiveStatement<?, ?> definingStatement, JavaTypeName typeName, ModuleGenerator module, EnumTypeDefinition typedef) {
        AbstractEnumerationBuilder builder = builderFactory.newEnumerationBuilder(typeName);
        YangSourceDefinition.of((ModuleEffectiveStatement)((ModuleEffectiveStatement)module.statement()), definingStatement).ifPresent(arg_0 -> ((AbstractEnumerationBuilder)builder).setYangSourceDefinition(arg_0));
        typedef.getDescription().map(BindingGeneratorUtil::encodeAngleBrackets).ifPresent(arg_0 -> ((AbstractEnumerationBuilder)builder).setDescription(arg_0));
        typedef.getReference().ifPresent(arg_0 -> ((AbstractEnumerationBuilder)builder).setReference(arg_0));
        builder.setModuleName(((UnresolvedQName.Unqualified)((ModuleEffectiveStatement)module.statement()).argument()).getLocalName());
        builder.updateEnumPairsFromEnumTypeDef(typedef);
        return builder.toInstance();
    }

    private static @NonNull GeneratedType createSimple(TypeBuilderFactory builderFactory, EffectiveStatement<?, ?> definingStatement, JavaTypeName typeName, ModuleGenerator module, Type javaType, TypeDefinition<?> typedef) {
        String moduleName = ((UnresolvedQName.Unqualified)((ModuleEffectiveStatement)module.statement()).argument()).getLocalName();
        GeneratedTOBuilder builder = builderFactory.newGeneratedTOBuilder(typeName);
        builder.setTypedef(true);
        builder.addImplementsType((Type)BindingTypes.scalarTypeObject((Type)javaType));
        YangSourceDefinition.of((ModuleEffectiveStatement)((ModuleEffectiveStatement)module.statement()), definingStatement).ifPresent(arg_0 -> ((GeneratedTOBuilder)builder).setYangSourceDefinition(arg_0));
        GeneratedPropertyBuilder genPropBuilder = builder.addProperty("value");
        genPropBuilder.setReturnType(javaType);
        builder.addEqualsIdentity(genPropBuilder);
        builder.addHashIdentity(genPropBuilder);
        builder.addToStringProperty(genPropBuilder);
        builder.setRestrictions(BindingGeneratorUtil.getRestrictions(typedef));
        builder.setModuleName(moduleName);
        builderFactory.addCodegenInformation((DocumentedNode)typedef, (GeneratedTypeBuilderBase<?>)builder);
        AbstractTypeObjectGenerator.annotateDeprecatedIfNecessary(typedef, (AnnotableTypeBuilder)builder);
        if (javaType instanceof ConcreteType && "String".equals(javaType.getName()) && typedef.getBaseType() != null) {
            AbstractTypeObjectGenerator.addStringRegExAsConstant(builder, AbstractTypeObjectGenerator.resolveRegExpressions(typedef));
        }
        AbstractTypeObjectGenerator.addUnits(builder, typedef);
        AbstractTypeObjectGenerator.makeSerializable(builder);
        return builder.build();
    }

    private static @NonNull GeneratedTransferObject createUnion(List<GeneratedType> auxiliaryGeneratedTypes, TypeBuilderFactory builderFactory, EffectiveStatement<?, ?> definingStatement, UnionDependencies dependencies, JavaTypeName typeName, ModuleGenerator module, TypeEffectiveStatement<?> type, boolean isTypedef, TypeDefinition<?> typedef) {
        GeneratedUnionBuilder builder = builderFactory.newGeneratedUnionBuilder(typeName);
        YangSourceDefinition.of((ModuleEffectiveStatement)((ModuleEffectiveStatement)module.statement()), definingStatement).ifPresent(arg_0 -> ((GeneratedUnionBuilder)builder).setYangSourceDefinition(arg_0));
        builder.addImplementsType((Type)BindingTypes.UNION_TYPE_OBJECT);
        builder.setIsUnion(true);
        builder.setModuleName(((UnresolvedQName.Unqualified)((ModuleEffectiveStatement)module.statement()).argument()).getLocalName());
        builderFactory.addCodegenInformation(definingStatement, (GeneratedTypeBuilderBase<?>)builder);
        AbstractTypeObjectGenerator.annotateDeprecatedIfNecessary(definingStatement, (AnnotableTypeBuilder)builder);
        HashMap<String, String> expressions = new HashMap<String, String>();
        ArrayList<String> typeProperties = new ArrayList<String>();
        for (EffectiveStatement stmt : type.effectiveSubstatements()) {
            Enumeration generatedType;
            String localName;
            if (!(stmt instanceof TypeEffectiveStatement)) continue;
            TypeEffectiveStatement subType = (TypeEffectiveStatement)stmt;
            QName subName = (QName)subType.argument();
            String propSource = localName = subName.getLocalName();
            if (TypeDefinitions.UNION.equals((Object)subName)) {
                JavaTypeName subUnionName = typeName.createEnclosed(AbstractTypeObjectGenerator.provideAvailableNameForGenTOBuilder(typeName.simpleName()));
                GeneratedTransferObject subUnion = AbstractTypeObjectGenerator.createUnion(auxiliaryGeneratedTypes, builderFactory, definingStatement, dependencies, subUnionName, module, subType, isTypedef, subType.getTypeDefinition());
                builder.addEnclosingTransferObject(subUnion);
                propSource = subUnionName.simpleName();
                generatedType = subUnion;
            } else if (TypeDefinitions.ENUMERATION.equals((Object)subName)) {
                Enumeration subEnumeration = AbstractTypeObjectGenerator.createEnumeration(builderFactory, definingStatement, typeName.createEnclosed(Naming.getClassName((String)localName), "$"), module, (EnumTypeDefinition)subType.getTypeDefinition());
                builder.addEnumeration(subEnumeration);
                generatedType = subEnumeration;
            } else if (TypeDefinitions.BITS.equals((Object)subName)) {
                GeneratedTransferObject subBits = AbstractTypeObjectGenerator.createBits(builderFactory, definingStatement, typeName.createEnclosed(Naming.getClassName((String)localName), "$"), module, (BitsTypeDefinition)subType.getTypeDefinition(), isTypedef);
                builder.addEnclosingTransferObject(subBits);
                generatedType = subBits;
            } else if (TypeDefinitions.IDENTITYREF.equals((Object)subName)) {
                propSource = ((QName)((BaseEffectiveStatement)stmt.findFirstEffectiveSubstatement(BaseEffectiveStatement.class).orElseThrow(() -> new VerifyException(String.format("Invalid identityref definition %s in %s, missing BASE statement", stmt, definingStatement)))).argument()).getLocalName();
                generatedType = ((TypeReference)Verify.verifyNotNull((Object)dependencies.identityTypes.get(stmt), (String)"Cannot resolve identityref %s in %s", (Object[])new Object[]{stmt, definingStatement})).methodReturnType(builderFactory);
            } else if (TypeDefinitions.LEAFREF.equals((Object)subName)) {
                generatedType = ((TypeReference)Verify.verifyNotNull((Object)dependencies.leafTypes.get(stmt), (String)"Cannot resolve leafref %s in %s", (Object[])new Object[]{stmt, definingStatement})).methodReturnType(builderFactory);
            } else {
                Type baseType = (Type)SIMPLE_TYPES.get((Object)subName);
                if (baseType == null) {
                    AbstractTypeObjectGenerator baseGen = (AbstractTypeObjectGenerator)Verify.verifyNotNull((Object)dependencies.baseTypes.get(subName), (String)"Cannot resolve base type %s in %s", (Object[])new Object[]{subName, definingStatement});
                    baseType = baseGen.methodReturnType(builderFactory);
                    if (baseGen.refType instanceof TypeReference.Leafref) {
                        Type search = baseType;
                        String matching = builder.getProperties().stream().filter(prop -> search == ((GeneratedPropertyBuilderImpl)prop).getReturnType()).findFirst().map(TypeMemberBuilder::getName).orElse(null);
                        if (matching != null) {
                            typeProperties.add(matching);
                            continue;
                        }
                        propSource = Naming.getUnionLeafrefMemberName((String)builder.getName(), (String)baseType.getName());
                    }
                }
                expressions.putAll(AbstractTypeObjectGenerator.resolveRegExpressions(subType.getTypeDefinition()));
                generatedType = AbstractTypeObjectGenerator.restrictType(baseType, BindingGeneratorUtil.getRestrictions(type.getTypeDefinition()), builderFactory);
            }
            String propName = Naming.getPropertyName((String)propSource);
            typeProperties.add(propName);
            if (builder.containsProperty(propName)) continue;
            GeneratedPropertyBuilder propBuilder = (GeneratedPropertyBuilder)builder.addProperty(propName).setReturnType((Type)generatedType);
            builder.addEqualsIdentity(propBuilder);
            builder.addHashIdentity(propBuilder);
            builder.addToStringProperty(propBuilder);
        }
        builder.setTypePropertyNames(typeProperties);
        AbstractTypeObjectGenerator.addStringRegExAsConstant(builder, expressions);
        AbstractTypeObjectGenerator.addUnits(builder, typedef);
        AbstractTypeObjectGenerator.makeSerializable(builder);
        return builder.build();
    }

    abstract @NonNull TypeDefinition<?> extractTypeDefinition();

    abstract @NonNull GeneratedTransferObject createDerivedType(@NonNull TypeBuilderFactory var1, @NonNull GeneratedTransferObject var2);

    static void addStringRegExAsConstant(GeneratedTOBuilder genTOBuilder, Map<String, String> expressions) {
        if (!expressions.isEmpty()) {
            genTOBuilder.addConstant((Type)Types.listTypeFor((Type)BaseYangTypes.STRING_TYPE), "PATTERN_CONSTANTS", (Object)ImmutableMap.copyOf(expressions));
        }
    }

    static Map<String, String> resolveRegExpressions(TypeDefinition<?> typedef) {
        Object object;
        if (typedef instanceof StringTypeDefinition) {
            StringTypeDefinition stringTypedef = (StringTypeDefinition)typedef;
            object = AbstractTypeObjectGenerator.resolveRegExpressions(stringTypedef.getPatternConstraints());
        } else {
            object = ImmutableMap.of();
        }
        return object;
    }

    private static Map<String, String> resolveRegExpressions(List<PatternConstraint> patternConstraints) {
        if (patternConstraints.isEmpty()) {
            return ImmutableMap.of();
        }
        HashMap regExps = Maps.newHashMapWithExpectedSize((int)patternConstraints.size());
        for (PatternConstraint patternConstraint : patternConstraints) {
            String regEx = patternConstraint.getJavaPatternString();
            Optional optModifier = patternConstraint.getModifier();
            if (optModifier.isPresent()) {
                regEx = AbstractTypeObjectGenerator.applyModifier((ModifierKind)optModifier.orElseThrow(), regEx);
            }
            regExps.put(regEx, patternConstraint.getRegularExpressionString());
        }
        return regExps;
    }

    private static String provideAvailableNameForGenTOBuilder(String name) {
        int dollar = name.indexOf(36);
        if (dollar == -1) {
            return name + "$1";
        }
        int newSuffix = Integer.parseUnsignedInt(name.substring(dollar + 1)) + 1;
        Verify.verify((newSuffix > 0 ? 1 : 0) != 0, (String)"Suffix counter overflow", (Object[])new Object[0]);
        return name.substring(0, dollar + 1) + newSuffix;
    }

    private static String applyModifier(ModifierKind modifier, String pattern) {
        switch (modifier) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case INVERT_MATCH: 
        }
        return RegexPatterns.negatePatternString((String)pattern);
    }

    private static final class UnionDependencies
    implements Immutable {
        private final Map<EffectiveStatement<?, ?>, TypeReference> identityTypes = new HashMap();
        private final Map<EffectiveStatement<?, ?>, TypeReference> leafTypes = new HashMap();
        private final Map<QName, TypedefGenerator> baseTypes = new HashMap<QName, TypedefGenerator>();

        UnionDependencies(TypeEffectiveStatement<?> type, GeneratorContext context) {
            this.resolveUnionDependencies(context, type);
        }

        private void resolveUnionDependencies(GeneratorContext context, TypeEffectiveStatement<?> union) {
            for (EffectiveStatement stmt : union.effectiveSubstatements()) {
                if (!(stmt instanceof TypeEffectiveStatement)) continue;
                TypeEffectiveStatement type = (TypeEffectiveStatement)stmt;
                QName typeName = (QName)type.argument();
                if (TypeDefinitions.IDENTITYREF.equals((Object)typeName)) {
                    if (this.identityTypes.containsKey(stmt)) continue;
                    this.identityTypes.put(stmt, TypeReference.identityRef(type.streamEffectiveSubstatements(BaseEffectiveStatement.class).map(ModelStatement::argument).map(context::resolveIdentity).collect(Collectors.toUnmodifiableList())));
                    continue;
                }
                if (TypeDefinitions.LEAFREF.equals((Object)typeName)) {
                    if (this.leafTypes.containsKey(stmt)) continue;
                    this.leafTypes.put(stmt, TypeReference.leafRef(context.resolveLeafref((PathExpression)type.findFirstEffectiveSubstatementArgument(PathEffectiveStatement.class).orElseThrow())));
                    continue;
                }
                if (TypeDefinitions.UNION.equals((Object)typeName)) {
                    this.resolveUnionDependencies(context, type);
                    continue;
                }
                if (AbstractTypeObjectGenerator.isBuiltinName(typeName) || this.baseTypes.containsKey(typeName)) continue;
                this.baseTypes.put(typeName, context.resolveTypedef(typeName));
            }
        }
    }
}

