/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.base.Verify;
import java.util.List;
import java.util.stream.Collectors;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractDependentGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AugmentResolver;
import org.opendaylight.mdsal.binding.generator.impl.reactor.GeneratorContext;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.StatementNamespace;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.mdsal.binding.generator.impl.rt.DefaultIdentityRuntimeType;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.AnnotableTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.model.ri.BindingTypes;
import org.opendaylight.mdsal.binding.runtime.api.IdentityRuntimeType;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.ModelStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.BaseEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

public final class IdentityGenerator
extends AbstractDependentGenerator<IdentityEffectiveStatement, IdentityRuntimeType> {
    private List<IdentityGenerator> baseIdentities = null;

    IdentityGenerator(IdentityEffectiveStatement statement, AbstractCompositeGenerator<?, ?> parent) {
        super(statement, parent);
    }

    @Override
    StatementNamespace namespace() {
        return StatementNamespace.IDENTITY;
    }

    @Override
    void pushToInference(SchemaInferenceStack dataTree) {
        throw new UnsupportedOperationException("Cannot push " + this.statement() + " to data tree");
    }

    @Override
    void linkDependencies(GeneratorContext context) {
        this.baseIdentities = ((IdentityEffectiveStatement)this.statement()).streamEffectiveSubstatements(BaseEffectiveStatement.class).map(ModelStatement::argument).map(context::resolveIdentity).collect(Collectors.toUnmodifiableList());
    }

    @Override
    GeneratedType createTypeImpl(TypeBuilderFactory builderFactory) {
        GeneratedTypeBuilder builder = builderFactory.newGeneratedTypeBuilder(this.typeName());
        if (!this.baseIdentities.isEmpty()) {
            for (IdentityGenerator baseIdentity : this.baseIdentities) {
                builder.addImplementsType((Type)baseIdentity.getGeneratedType(builderFactory));
            }
        } else {
            builder.addImplementsType((Type)BindingTypes.BASE_IDENTITY);
        }
        IdentityGenerator.annotateDeprecatedIfNecessary(this.statement(), (AnnotableTypeBuilder)builder);
        IdentityGenerator.narrowImplementedInterface(builder);
        ModuleGenerator module = this.currentModule();
        module.addQNameConstant((GeneratedTypeBuilderBase<?>)builder, this.localName());
        builder.addConstant(Type.of((Identifiable)builder), "VALUE", BaseIdentity.class);
        builderFactory.addCodegenInformation(module, (EffectiveStatement<?, ?>)this.statement(), (GeneratedTypeBuilderBase<?>)builder);
        builder.setModuleName(((UnresolvedQName.Unqualified)((ModuleEffectiveStatement)module.statement()).argument()).getLocalName());
        return builder.build();
    }

    @Override
    IdentityRuntimeType createExternalRuntimeType(Type type) {
        Verify.verify((boolean)(type instanceof GeneratedType), (String)"Unexpected type %s", (Object)type);
        return new DefaultIdentityRuntimeType((GeneratedType)type, (IdentityEffectiveStatement)this.statement());
    }

    @Override
    IdentityRuntimeType createInternalRuntimeType(AugmentResolver resolver, IdentityEffectiveStatement statement, Type type) {
        throw new UnsupportedOperationException("Should never be called");
    }

    @Override
    void addAsGetterMethod(GeneratedTypeBuilderBase<?> builder, TypeBuilderFactory builderFactory) {
    }
}

