/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CompositeRuntimeTypeBuilder;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CompositeSchemaTreeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.KeyGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.StatementNamespace;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.mdsal.binding.generator.impl.rt.DefaultListRuntimeType;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.MethodSignature;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.AnnotableTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.mdsal.binding.model.ri.BindingTypes;
import org.opendaylight.mdsal.binding.model.ri.Types;
import org.opendaylight.mdsal.binding.runtime.api.AugmentRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.KeyRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.ListRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.yang.binding.contract.Naming;
import org.opendaylight.yangtools.yang.common.Ordering;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.KeyEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

final class ListGenerator
extends CompositeSchemaTreeGenerator<ListEffectiveStatement, ListRuntimeType> {
    private final @Nullable KeyGenerator keyGen;

    ListGenerator(ListEffectiveStatement statement, AbstractCompositeGenerator<?, ?> parent) {
        super(statement, parent);
        this.keyGen = statement.findFirstEffectiveSubstatement(KeyEffectiveStatement.class).map(key -> new KeyGenerator((KeyEffectiveStatement)key, parent, this)).orElse(null);
    }

    @Override
    StatementNamespace namespace() {
        return StatementNamespace.LIST;
    }

    @Nullable KeyGenerator keyGenerator() {
        return this.keyGen;
    }

    @Override
    void pushToInference(SchemaInferenceStack dataTree) {
        dataTree.enterDataTree((QName)((ListEffectiveStatement)this.statement()).argument());
    }

    @Override
    GeneratedType createTypeImpl(TypeBuilderFactory builderFactory) {
        GeneratedTypeBuilder builder = builderFactory.newGeneratedTypeBuilder(this.typeName());
        this.addImplementsChildOf(builder);
        ListGenerator.addAugmentable(builder);
        this.addUsesInterfaces(builder, builderFactory);
        ListGenerator.addConcreteInterfaceMethods(builder);
        ModuleGenerator module = this.currentModule();
        module.addQNameConstant((GeneratedTypeBuilderBase<?>)builder, this.localName());
        if (this.keyGen != null) {
            GeneratedType keyType = this.keyGen.getGeneratedType(builderFactory);
            builder.addImplementsType((Type)BindingTypes.keyAware((Type)keyType));
            ((MethodSignatureBuilder)builder.addMethod("key").setReturnType((Type)keyType)).addAnnotation(OVERRIDE_ANNOTATION);
        }
        this.addGetterMethods(builder, builderFactory);
        this.annotateDeprecatedIfNecessary((AnnotableTypeBuilder)builder);
        builderFactory.addCodegenInformation(module, (EffectiveStatement<?, ?>)this.statement(), (GeneratedTypeBuilderBase<?>)builder);
        builder.setModuleName(((UnresolvedQName.Unqualified)((ModuleEffectiveStatement)module.statement()).argument()).getLocalName());
        return builder.build();
    }

    private @Nullable KeyRuntimeType keyRuntimeType() {
        KeyGenerator gen = this.keyGen;
        return gen != null ? (KeyRuntimeType)gen.runtimeType().orElseThrow() : null;
    }

    @Override
    Type methodReturnType(TypeBuilderFactory builderFactory) {
        Type generatedType = super.methodReturnType(builderFactory);
        if (this.keyGen != null && ((ListEffectiveStatement)this.statement()).ordering() == Ordering.SYSTEM) {
            return Types.mapTypeFor((Type)this.keyGen.getGeneratedType(builderFactory), (Type)generatedType);
        }
        return Types.listTypeFor((Type)generatedType);
    }

    @Override
    MethodSignatureBuilder constructGetter(GeneratedTypeBuilderBase<?> builder, Type returnType) {
        MethodSignatureBuilder ret = super.constructGetter(builder, returnType).setMechanics(MethodSignature.ValueMechanics.NULLIFY_EMPTY);
        MethodSignatureBuilder nonnull = ((MethodSignatureBuilder)builder.addMethod(Naming.getNonnullMethodName((String)this.localName().getLocalName())).setReturnType(returnType)).setDefault(true);
        this.annotateDeprecatedIfNecessary((AnnotableTypeBuilder)nonnull);
        return ret;
    }

    @Override
    CompositeRuntimeTypeBuilder<ListEffectiveStatement, ListRuntimeType> createBuilder(ListEffectiveStatement statement) {
        return new CompositeRuntimeTypeBuilder<ListEffectiveStatement, ListRuntimeType>(statement){

            @Override
            ListRuntimeType build(GeneratedType type, ListEffectiveStatement statement, List<RuntimeType> children, List<AugmentRuntimeType> augments) {
                return new DefaultListRuntimeType(type, statement, children, augments, ListGenerator.this.keyRuntimeType());
            }
        };
    }
}

