/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.generator.BindingGeneratorUtil;
import org.opendaylight.mdsal.binding.generator.impl.reactor.GeneratedUnionBuilder;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeComments;
import org.opendaylight.mdsal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.YangSourceDefinition;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.model.ri.generated.type.builder.AbstractEnumerationBuilder;
import org.opendaylight.mdsal.binding.model.ri.generated.type.builder.CodegenEnumerationBuilder;
import org.opendaylight.mdsal.binding.model.ri.generated.type.builder.CodegenGeneratedTOBuilder;
import org.opendaylight.mdsal.binding.model.ri.generated.type.builder.CodegenGeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.ri.generated.type.builder.RuntimeEnumerationBuilder;
import org.opendaylight.mdsal.binding.model.ri.generated.type.builder.RuntimeGeneratedTOBuilder;
import org.opendaylight.mdsal.binding.model.ri.generated.type.builder.RuntimeGeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeGeneratedUnion;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;

@Beta
public abstract class TypeBuilderFactory
implements Immutable {
    TypeBuilderFactory() {
    }

    public static @NonNull TypeBuilderFactory codegen() {
        return Codegen.INSTANCE;
    }

    public static @NonNull TypeBuilderFactory runtime() {
        return Runtime.INSTANCE;
    }

    abstract @NonNull AbstractEnumerationBuilder newEnumerationBuilder(JavaTypeName var1);

    abstract @NonNull GeneratedTOBuilder newGeneratedTOBuilder(JavaTypeName var1);

    abstract @NonNull GeneratedTypeBuilder newGeneratedTypeBuilder(JavaTypeName var1);

    abstract @NonNull GeneratedUnionBuilder newGeneratedUnionBuilder(JavaTypeName var1);

    abstract void addCodegenInformation(EffectiveStatement<?, ?> var1, GeneratedTypeBuilderBase<?> var2);

    abstract void addCodegenInformation(ModuleEffectiveStatement var1, GeneratedTypeBuilderBase<?> var2);

    abstract void addCodegenInformation(DocumentedNode var1, GeneratedTypeBuilderBase<?> var2);

    abstract void addCodegenInformation(ModuleGenerator var1, EffectiveStatement<?, ?> var2, GeneratedTypeBuilderBase<?> var3);

    private static final class Codegen
    extends TypeBuilderFactory {
        private static final @NonNull Codegen INSTANCE = new Codegen();

        private Codegen() {
        }

        @Override
        GeneratedTOBuilder newGeneratedTOBuilder(JavaTypeName identifier) {
            return new CodegenGeneratedTOBuilder(identifier);
        }

        @Override
        GeneratedTypeBuilder newGeneratedTypeBuilder(JavaTypeName identifier) {
            return new CodegenGeneratedTypeBuilder(identifier);
        }

        @Override
        AbstractEnumerationBuilder newEnumerationBuilder(JavaTypeName identifier) {
            return new CodegenEnumerationBuilder(identifier);
        }

        @Override
        GeneratedUnionBuilder newGeneratedUnionBuilder(JavaTypeName identifier) {
            return new UnionBuilder(identifier);
        }

        @Override
        void addCodegenInformation(EffectiveStatement<?, ?> stmt, GeneratedTypeBuilderBase<?> builder) {
            if (stmt instanceof DocumentedNode) {
                DocumentedNode documented = (DocumentedNode)stmt;
                this.addCodegenInformation(documented, builder);
            }
        }

        @Override
        void addCodegenInformation(ModuleEffectiveStatement stmt, GeneratedTypeBuilderBase<?> builder) {
            Verify.verify((boolean)(stmt instanceof Module), (String)"Unexpected module %s", (Object)stmt);
            Module module = (Module)stmt;
            YangSourceDefinition.of((Module)module).ifPresent(arg_0 -> builder.setYangSourceDefinition(arg_0));
            TypeComments.description((DocumentedNode)module).ifPresent(arg_0 -> builder.addComment(arg_0));
            module.getDescription().ifPresent(arg_0 -> builder.setDescription(arg_0));
            module.getReference().ifPresent(arg_0 -> builder.setReference(arg_0));
        }

        @Override
        void addCodegenInformation(DocumentedNode node, GeneratedTypeBuilderBase<?> builder) {
            node.getDescription().map(BindingGeneratorUtil::encodeAngleBrackets).ifPresent(arg_0 -> builder.setDescription(arg_0));
            node.getReference().ifPresent(arg_0 -> builder.setReference(arg_0));
        }

        @Override
        void addCodegenInformation(ModuleGenerator module, EffectiveStatement<?, ?> stmt, GeneratedTypeBuilderBase<?> builder) {
            if (stmt instanceof DocumentedNode) {
                DocumentedNode documented = (DocumentedNode)stmt;
                TypeComments.description(documented).ifPresent(arg_0 -> builder.addComment(arg_0));
                documented.getDescription().ifPresent(arg_0 -> builder.setDescription(arg_0));
                documented.getReference().ifPresent(arg_0 -> builder.setReference(arg_0));
            }
            if (stmt instanceof SchemaNode) {
                SchemaNode schema = (SchemaNode)stmt;
                YangSourceDefinition.of((ModuleEffectiveStatement)((ModuleEffectiveStatement)module.statement()), (SchemaNode)schema).ifPresent(arg_0 -> builder.setYangSourceDefinition(arg_0));
            }
        }

        private static final class UnionBuilder
        extends CodegenGeneratedTOBuilder
        implements GeneratedUnionBuilder {
            UnionBuilder(JavaTypeName identifier) {
                super(identifier);
                this.setIsUnion(true);
            }

            @Override
            public void setTypePropertyNames(List<String> propertyNames) {
                Objects.requireNonNull(propertyNames);
            }
        }
    }

    private static final class Runtime
    extends TypeBuilderFactory {
        private static final @NonNull Runtime INSTANCE = new Runtime();

        private Runtime() {
        }

        @Override
        GeneratedTOBuilder newGeneratedTOBuilder(JavaTypeName identifier) {
            return new RuntimeGeneratedTOBuilder(identifier);
        }

        @Override
        GeneratedTypeBuilder newGeneratedTypeBuilder(JavaTypeName identifier) {
            return new RuntimeGeneratedTypeBuilder(identifier);
        }

        @Override
        AbstractEnumerationBuilder newEnumerationBuilder(JavaTypeName identifier) {
            return new RuntimeEnumerationBuilder(identifier);
        }

        @Override
        GeneratedUnionBuilder newGeneratedUnionBuilder(JavaTypeName identifier) {
            return new UnionBuilder(identifier);
        }

        @Override
        void addCodegenInformation(EffectiveStatement<?, ?> stmt, GeneratedTypeBuilderBase<?> builder) {
        }

        @Override
        void addCodegenInformation(ModuleEffectiveStatement stmt, GeneratedTypeBuilderBase<?> builder) {
        }

        @Override
        void addCodegenInformation(DocumentedNode node, GeneratedTypeBuilderBase<?> builder) {
        }

        @Override
        void addCodegenInformation(ModuleGenerator module, EffectiveStatement<?, ?> stmt, GeneratedTypeBuilderBase<?> builder) {
        }

        private static final class UnionBuilder
        extends RuntimeGeneratedTOBuilder
        implements GeneratedUnionBuilder {
            private List<String> typePropertyNames;

            UnionBuilder(JavaTypeName identifier) {
                super(identifier);
                this.setIsUnion(true);
            }

            @Override
            public void setTypePropertyNames(List<String> propertyNames) {
                this.typePropertyNames = List.copyOf(propertyNames);
            }

            public GeneratedTransferObject build() {
                return this.typePropertyNames == null || this.typePropertyNames.isEmpty() ? super.build() : new UnionGTO(this, this.typePropertyNames);
            }

            private static final class UnionGTO
            extends RuntimeGeneratedTOBuilder.GTO
            implements RuntimeGeneratedUnion {
                private final @NonNull List<String> typePropertyNames;

                UnionGTO(RuntimeGeneratedTOBuilder builder, List<String> typePropertyNames) {
                    super(builder);
                    this.typePropertyNames = Objects.requireNonNull(typePropertyNames);
                }

                public List<String> typePropertyNames() {
                    return this.typePropertyNames;
                }
            }
        }
    }
}

