/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.base.Verify;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractAugmentGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AugmentRequirement;
import org.opendaylight.mdsal.binding.generator.impl.reactor.GroupingGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TargetAugmentEffectiveStatement;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesEffectiveStatement;

final class UsesAugmentGenerator
extends AbstractAugmentGenerator {
    private final UsesEffectiveStatement uses;
    private GroupingGenerator grouping;

    UsesAugmentGenerator(AugmentEffectiveStatement statement, UsesEffectiveStatement uses, AbstractCompositeGenerator<?, ?> parent) {
        super(statement, parent);
        this.uses = Objects.requireNonNull(uses);
    }

    void resolveGrouping(UsesEffectiveStatement resolvedUses, GroupingGenerator resolvedGrouping) {
        if (resolvedUses == this.uses) {
            Verify.verify((this.grouping == null ? 1 : 0) != 0, (String)"Attempted to re-resolve grouping of %s", (Object)this);
            this.grouping = Objects.requireNonNull(resolvedGrouping);
        }
    }

    @NonNull AugmentRequirement startLinkage() {
        return new AugmentRequirement(this, (GroupingGenerator)Verify.verifyNotNull((Object)this.grouping, (String)"Unresolved grouping in %s", (Object[])new Object[]{this}));
    }

    @Override
    boolean matchesInstantiated(AugmentEffectiveStatement statement) {
        return super.matchesInstantiated(statement) || UsesAugmentGenerator.declared((AugmentEffectiveStatement)this.statement()).equals(UsesAugmentGenerator.declared(statement));
    }

    private static AugmentStatement declared(AugmentEffectiveStatement statement) {
        return (AugmentStatement)Verify.verifyNotNull((Object)((AugmentStatement)statement.getDeclared()), (String)" %s does not have a declared view", (Object[])new Object[]{statement});
    }

    @Override
    TargetAugmentEffectiveStatement effectiveIn(SchemaTreeAwareEffectiveStatement<?, ?> target) {
        Verify.verify((boolean)(target instanceof SchemaTreeEffectiveStatement), (String)"Unexpected statement %s", target);
        QNameModule targetNamespace = ((QName)((SchemaTreeEffectiveStatement)target).argument()).getModule();
        return this.effectiveIn(target, qname -> qname.bindTo(targetNamespace));
    }
}

