/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodec;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class UnionJSONCodec<T>
implements JSONCodec<T> {
    private static final Logger LOG = LoggerFactory.getLogger(UnionJSONCodec.class);
    private final ImmutableList<JSONCodec<?>> codecs;

    UnionJSONCodec(List<JSONCodec<?>> codecs) {
        this.codecs = ImmutableList.copyOf(codecs);
    }

    static UnionJSONCodec<?> create(UnionTypeDefinition type, List<JSONCodec<?>> codecs) {
        Iterator<JSONCodec<?>> it = codecs.iterator();
        Verify.verify((boolean)it.hasNext(), (String)"Union %s has no subtypes", (Object)type);
        Class dataClass = it.next().getDataType();
        while (it.hasNext()) {
            Class next = it.next().getDataType();
            if (dataClass.equals(next)) continue;
            LOG.debug("Type {} has diverse data classes: {} and {}", new Object[]{type, dataClass, next});
            return new Diverse(codecs);
        }
        LOG.debug("Type {} has single data class {}", (Object)type, (Object)dataClass);
        return new SingleType(dataClass, codecs);
    }

    public final T parseValue(Object ctx, String str) {
        for (JSONCodec codec : this.codecs) {
            Object ret;
            try {
                ret = codec.parseValue(ctx, str);
            }
            catch (RuntimeException e) {
                LOG.debug("Codec {} did not accept input '{}'", new Object[]{codec, str, e});
                continue;
            }
            return this.getDataType().cast(ret);
        }
        throw new IllegalArgumentException("Invalid value \"" + str + "\" for union type.");
    }

    @Override
    public final void writeValue(JsonWriter ctx, T value) throws IOException {
        for (JSONCodec codec : this.codecs) {
            if (!codec.getDataType().isInstance(value)) {
                LOG.debug("Codec {} cannot accept input {}, skipping it", (Object)codec, value);
                continue;
            }
            JSONCodec objCodec = codec;
            try {
                objCodec.writeValue(ctx, value);
                return;
            }
            catch (RuntimeException e) {
                LOG.debug("Codec {} failed to serialize {}", new Object[]{codec, value, e});
            }
        }
        throw new IllegalArgumentException("No codecs could serialize" + value);
    }

    private static final class Diverse
    extends UnionJSONCodec<Object> {
        Diverse(List<JSONCodec<?>> codecs) {
            super(codecs);
        }

        public Class<Object> getDataType() {
            return Object.class;
        }
    }

    private static final class SingleType<T>
    extends UnionJSONCodec<T> {
        private final Class<T> dataClass;

        SingleType(Class<T> dataClass, List<JSONCodec<?>> codecs) {
            super(codecs);
            this.dataClass = Objects.requireNonNull(dataClass);
        }

        public Class<T> getDataType() {
            return this.dataClass;
        }
    }
}

