/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.broker.DOMForwardedReadOnlyTransaction;
import org.opendaylight.mdsal.dom.broker.DOMForwardedReadWriteTransaction;
import org.opendaylight.mdsal.dom.broker.DOMForwardedWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionFactory;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractDOMForwardedTransactionFactory<T extends DOMStoreTransactionFactory>
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDOMForwardedTransactionFactory.class);
    private static final VarHandle CLOSED;
    private final Map<LogicalDatastoreType, T> storeTxFactories;
    private volatile boolean closed;

    protected AbstractDOMForwardedTransactionFactory(Map<LogicalDatastoreType, ? extends T> txFactories) {
        Preconditions.checkState((!txFactories.isEmpty() ? 1 : 0) != 0, (Object)"txFactories should not be empty.");
        this.storeTxFactories = new EnumMap<LogicalDatastoreType, T>(txFactories);
    }

    protected abstract Object newTransactionIdentifier();

    protected abstract FluentFuture<? extends CommitInfo> commit(DOMDataTreeWriteTransaction var1, DOMStoreThreePhaseCommitCohort var2);

    public final DOMDataTreeReadTransaction newReadOnlyTransaction() {
        this.checkNotClosed();
        return new DOMForwardedReadOnlyTransaction(this.newTransactionIdentifier(), storeType -> this.requireTxFactory((LogicalDatastoreType)storeType).newReadOnlyTransaction());
    }

    public final DOMDataTreeWriteTransaction newWriteOnlyTransaction() {
        this.checkNotClosed();
        return new DOMForwardedWriteTransaction<DOMStoreWriteTransaction>(this.newTransactionIdentifier(), storeType -> this.requireTxFactory((LogicalDatastoreType)storeType).newWriteOnlyTransaction(), this);
    }

    public final DOMDataTreeReadWriteTransaction newReadWriteTransaction() {
        this.checkNotClosed();
        return new DOMForwardedReadWriteTransaction(this.newTransactionIdentifier(), storeType -> this.requireTxFactory((LogicalDatastoreType)storeType).newReadWriteTransaction(), (AbstractDOMForwardedTransactionFactory<?>)this);
    }

    protected final Map<LogicalDatastoreType, T> getTxFactories() {
        return this.storeTxFactories;
    }

    private @NonNull T requireTxFactory(LogicalDatastoreType type) {
        DOMStoreTransactionFactory factory = (DOMStoreTransactionFactory)this.storeTxFactories.get(Objects.requireNonNull(type));
        if (factory == null) {
            throw new IllegalArgumentException("Unsupported datastore type " + type);
        }
        return (T)factory;
    }

    protected final void checkNotClosed() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Transaction factory was closed. No further operations allowed.");
    }

    @Override
    public void close() {
        if (!CLOSED.compareAndSet(this, false, true)) {
            LOG.warn("Transaction factory was already closed", new Throwable());
        }
    }

    static {
        try {
            CLOSED = MethodHandles.lookup().findVarHandle(AbstractDOMForwardedTransactionFactory.class, "closed", Boolean.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

