/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMNotificationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DOMNotificationRouterEvent {
    private static final Logger LOG = LoggerFactory.getLogger(DOMNotificationRouterEvent.class);
    private final SettableFuture<Void> future = SettableFuture.create();
    private final @NonNull DOMNotification notification;

    DOMNotificationRouterEvent(DOMNotification notification) {
        this.notification = Objects.requireNonNull(notification);
    }

    ListenableFuture<Void> future() {
        return this.future;
    }

    void deliverTo(DOMNotificationListener listener) {
        try {
            listener.onNotification(this.notification);
        }
        catch (Exception e) {
            LOG.warn("Listener {} failed during notification delivery", (Object)listener, (Object)e);
        }
        finally {
            this.clear();
        }
    }

    void clear() {
        this.future.set(null);
    }
}

