/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.blueprint.ext;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.binding.KeyAware;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizationResultHolder;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaTreeInference;
import org.opendaylight.yangtools.yang.model.api.stmt.KeyEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class BindingContext {
    public final InstanceIdentifier<DataObject> appConfigPath;
    public final Class<?> appConfigBindingClass;
    public final Class<? extends DataSchemaNode> schemaType;
    public final QName bindingQName;

    public static BindingContext create(String logName, Class<? extends DataObject> klass, String appConfigListKeyValue) {
        if (KeyAware.class.isAssignableFrom(klass)) {
            if (Strings.isNullOrEmpty((String)appConfigListKeyValue)) {
                throw new ComponentDefinitionException(String.format("%s: App config binding class %s represents a yang list therefore \"%s\" must be specified", logName, klass.getName(), "list-key-value"));
            }
            try {
                return ListBindingContext.newInstance(klass, appConfigListKeyValue);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new ComponentDefinitionException(String.format("%s: Error initializing for app config list binding class %s", logName, klass.getName()), (Throwable)e);
            }
        }
        return new ContainerBindingContext(klass);
    }

    private BindingContext(Class<?> appConfigBindingClass, InstanceIdentifier<DataObject> appConfigPath, Class<? extends DataSchemaNode> schemaType) {
        this.appConfigBindingClass = appConfigBindingClass;
        this.appConfigPath = appConfigPath;
        this.schemaType = schemaType;
        this.bindingQName = BindingReflections.findQName(appConfigBindingClass);
    }

    public NormalizedNode parseDataElement(Element element, SchemaTreeInference dataSchema) throws XMLStreamException, IOException, SAXException, URISyntaxException {
        NormalizedNode normalizedNode;
        NormalizationResultHolder resultHolder = new NormalizationResultHolder();
        NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from((NormalizationResultHolder)resultHolder);
        XmlParserStream xmlParser = XmlParserStream.create((NormalizedNodeStreamWriter)writer, (EffectiveStatementInference)dataSchema);
        xmlParser.traverse(new DOMSource(element));
        NormalizedNode result = resultHolder.getResult().data();
        if (result instanceof MapNode) {
            MapNode mapNode = (MapNode)result;
            normalizedNode = (NormalizedNode)mapNode.body().iterator().next();
        } else {
            normalizedNode = result;
        }
        return normalizedNode;
    }

    public abstract NormalizedNode newDefaultNode(SchemaTreeInference var1);

    private static class ListBindingContext
    extends BindingContext {
        final String appConfigListKeyValue;

        ListBindingContext(Class<? extends DataObject> appConfigBindingClass, InstanceIdentifier<? extends DataObject> appConfigPath, String appConfigListKeyValue) {
            super(appConfigBindingClass, appConfigPath, ListSchemaNode.class);
            this.appConfigListKeyValue = appConfigListKeyValue;
        }

        static ListBindingContext newInstance(Class<? extends DataObject> bindingClass, String listKeyValue) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
            Key keyInstance = (Key)bindingClass.getMethod("key", new Class[0]).getReturnType().getConstructor(String.class).newInstance(listKeyValue);
            KeyedInstanceIdentifier appConfigPath = InstanceIdentifier.builder(bindingClass, (Key)keyInstance).build();
            return new ListBindingContext(bindingClass, (InstanceIdentifier<? extends DataObject>)appConfigPath, listKeyValue);
        }

        @Override
        public NormalizedNode newDefaultNode(SchemaTreeInference dataSchema) {
            SchemaTreeEffectiveStatement stmt = (SchemaTreeEffectiveStatement)Iterables.getLast((Iterable)dataSchema.statementPath());
            Set keys = (Set)stmt.findFirstEffectiveSubstatementArgument(KeyEffectiveStatement.class).orElseThrow();
            Preconditions.checkArgument((keys.size() == 1 ? 1 : 0) != 0, (String)"Expected only 1 key for list %s", (Object)this.appConfigBindingClass);
            QName listKeyQName = (QName)keys.iterator().next();
            return ImmutableNodes.mapEntryBuilder((QName)this.bindingQName, (QName)listKeyQName, (Object)this.appConfigListKeyValue).build();
        }
    }

    private static class ContainerBindingContext
    extends BindingContext {
        ContainerBindingContext(Class<? extends DataObject> appConfigBindingClass) {
            super(appConfigBindingClass, (InstanceIdentifier<DataObject>)InstanceIdentifier.create(appConfigBindingClass), ContainerSchemaNode.class);
        }

        @Override
        public NormalizedNode newDefaultNode(SchemaTreeInference dataSchema) {
            return ImmutableNodes.containerNode((QName)this.bindingQName);
        }
    }
}

