/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.blueprint.ext;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import org.opendaylight.controller.blueprint.ext.AbstractDependentComponentFactoryMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SpecificReferenceListMetadata
extends AbstractDependentComponentFactoryMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(SpecificReferenceListMetadata.class);
    private final String interfaceName;
    private final String serviceResourcePath;
    private final Collection<String> expectedServiceTypes = new ConcurrentSkipListSet<String>();
    private final Collection<String> retrievedServiceTypes = new ConcurrentSkipListSet<String>();
    private final Collection<Object> retrievedServices = Collections.synchronizedList(new ArrayList());
    private volatile BundleTracker<Bundle> bundleTracker;
    private volatile ServiceTracker<Object, Object> serviceTracker;

    SpecificReferenceListMetadata(String id, String interfaceName) {
        super(id);
        this.interfaceName = interfaceName;
        this.serviceResourcePath = "META-INF/services/" + interfaceName;
    }

    @Override
    protected void startTracking() {
        BundleTrackerCustomizer<Bundle> bundleListener = new BundleTrackerCustomizer<Bundle>(){

            public Bundle addingBundle(Bundle bundle, BundleEvent event) {
                SpecificReferenceListMetadata.this.bundleAdded(bundle);
                return bundle;
            }

            public void modifiedBundle(Bundle bundle, BundleEvent event, Bundle object) {
            }

            public void removedBundle(Bundle bundle, BundleEvent event, Bundle object) {
            }
        };
        this.bundleTracker = new BundleTracker(this.container().getBundleContext(), 60, (BundleTrackerCustomizer)bundleListener);
        this.bundleTracker.open();
        if (this.expectedServiceTypes.isEmpty()) {
            this.setSatisfied();
            return;
        }
        ServiceTrackerCustomizer<Object, Object> serviceListener = new ServiceTrackerCustomizer<Object, Object>(){

            public Object addingService(ServiceReference<Object> reference) {
                return SpecificReferenceListMetadata.this.serviceAdded(reference);
            }

            public void modifiedService(ServiceReference<Object> reference, Object service) {
            }

            public void removedService(ServiceReference<Object> reference, Object service) {
                SpecificReferenceListMetadata.this.container().getBundleContext().ungetService(reference);
            }
        };
        this.setDependencyDesc(this.interfaceName + " services with types " + this.expectedServiceTypes);
        this.serviceTracker = new ServiceTracker(this.container().getBundleContext(), this.interfaceName, (ServiceTrackerCustomizer)serviceListener);
        this.serviceTracker.open();
    }

    private void bundleAdded(Bundle bundle) {
        URL resource = bundle.getEntry(this.serviceResourcePath);
        if (resource == null) {
            return;
        }
        LOG.debug("{}: Found {} resource in bundle {}", new Object[]{this.logName(), resource, bundle.getSymbolicName()});
        try {
            for (String line : Resources.readLines((URL)resource, (Charset)StandardCharsets.UTF_8)) {
                int ci = line.indexOf(35);
                if (ci >= 0) {
                    line = line.substring(0, ci);
                }
                if ((line = line.trim()).isEmpty()) continue;
                String serviceType = line;
                LOG.debug("{}: Retrieved service type {}", (Object)this.logName(), (Object)serviceType);
                this.expectedServiceTypes.add(serviceType);
            }
        }
        catch (IOException e) {
            this.setFailure(String.format("%s: Error reading resource %s from bundle %s", this.logName(), resource, bundle.getSymbolicName()), e);
        }
    }

    private Object serviceAdded(ServiceReference<Object> reference) {
        Object service = this.container().getBundleContext().getService(reference);
        String serviceType = (String)reference.getProperty("type");
        LOG.debug("{}: Service type {} added from bundle {}", new Object[]{this.logName(), serviceType, reference.getBundle().getSymbolicName()});
        if (serviceType == null) {
            LOG.error("{}: Missing OSGi service property '{}' for service interface {} in bundle {}", new Object[]{this.logName(), "type", this.interfaceName, reference.getBundle().getSymbolicName()});
            return service;
        }
        if (!this.expectedServiceTypes.contains(serviceType)) {
            LOG.error("{}: OSGi service property '{}' for service interface {} in bundle {} was not found in the expected service types {} obtained via {} bundle resources. Is the bundle resource missing or the service type misspelled?", new Object[]{this.logName(), "type", this.interfaceName, reference.getBundle().getSymbolicName(), this.expectedServiceTypes, this.serviceResourcePath});
            return service;
        }
        if (this.isSatisfied()) {
            this.restartContainer();
        } else {
            this.retrievedServiceTypes.add(serviceType);
            this.retrievedServices.add(service);
            if (this.retrievedServiceTypes.equals(this.expectedServiceTypes)) {
                LOG.debug("{}: Got all expected service types", (Object)this.logName());
                this.setSatisfied();
            } else {
                HashSet<String> remaining = new HashSet<String>(this.expectedServiceTypes);
                remaining.removeAll(this.retrievedServiceTypes);
                this.setDependencyDesc(this.interfaceName + " services with types " + remaining);
            }
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object create() throws ComponentDefinitionException {
        LOG.debug("{}: In create: interfaceName: {}", (Object)this.logName(), (Object)this.interfaceName);
        super.onCreate();
        LOG.debug("{}: create returning service list {}", (Object)this.logName(), this.retrievedServices);
        Collection<Object> collection = this.retrievedServices;
        synchronized (collection) {
            return List.copyOf(this.retrievedServices);
        }
    }

    @Override
    public void destroy(Object instance) {
        super.destroy(instance);
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
            this.bundleTracker = null;
        }
        if (this.serviceTracker != null) {
            this.serviceTracker.close();
            this.serviceTracker = null;
        }
    }

    public String toString() {
        return "SpecificReferenceListMetadata [interfaceName=" + this.interfaceName + ", serviceResourcePath=" + this.serviceResourcePath + "]";
    }
}

