/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.logbuffer.LogBufferDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import org.agrona.BufferUtil;
import org.agrona.CloseHelper;
import org.agrona.LangUtil;
import org.agrona.concurrent.UnsafeBuffer;

public final class LogBuffers
implements AutoCloseable {
    private static final EnumSet<StandardOpenOption> FILE_OPTIONS = EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.SPARSE);
    private long lingerDeadlineNs = Long.MAX_VALUE;
    private int refCount;
    private final int termLength;
    private final FileChannel fileChannel;
    private final ByteBuffer[] termBuffers = new ByteBuffer[3];
    private final UnsafeBuffer logMetaDataBuffer;
    private final MappedByteBuffer[] mappedByteBuffers;

    public LogBuffers(String logFileName) {
        int termLength = 0;
        FileChannel fileChannel = null;
        UnsafeBuffer logMetaDataBuffer = null;
        MappedByteBuffer[] mappedByteBuffers = null;
        try {
            fileChannel = FileChannel.open(Paths.get(logFileName, new String[0]), FILE_OPTIONS, new FileAttribute[0]);
            long logLength = fileChannel.size();
            if (logLength < Integer.MAX_VALUE) {
                MappedByteBuffer mappedBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, logLength);
                mappedBuffer.order(ByteOrder.LITTLE_ENDIAN);
                mappedByteBuffers = new MappedByteBuffer[]{mappedBuffer};
                logMetaDataBuffer = new UnsafeBuffer((ByteBuffer)mappedBuffer, (int)(logLength - (long)LogBufferDescriptor.LOG_META_DATA_LENGTH), LogBufferDescriptor.LOG_META_DATA_LENGTH);
                termLength = LogBufferDescriptor.termLength(logMetaDataBuffer);
                int pageSize = LogBufferDescriptor.pageSize(logMetaDataBuffer);
                LogBufferDescriptor.checkTermLength(termLength);
                LogBufferDescriptor.checkPageSize(pageSize);
                for (int i = 0; i < 3; ++i) {
                    int offset = i * termLength;
                    mappedBuffer.limit(offset + termLength).position(offset);
                    this.termBuffers[i] = mappedBuffer.slice();
                }
            } else {
                mappedByteBuffers = new MappedByteBuffer[4];
                int assumedTermLength = 0x40000000;
                long metaDataSectionOffset = 0xC0000000L;
                long metaDataMappingLength = logLength - 0xC0000000L;
                MappedByteBuffer metaDataMappedBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0xC0000000L, metaDataMappingLength);
                metaDataMappedBuffer.order(ByteOrder.LITTLE_ENDIAN);
                mappedByteBuffers[3] = metaDataMappedBuffer;
                logMetaDataBuffer = new UnsafeBuffer((ByteBuffer)metaDataMappedBuffer, (int)metaDataMappingLength - LogBufferDescriptor.LOG_META_DATA_LENGTH, LogBufferDescriptor.LOG_META_DATA_LENGTH);
                int metaDataTermLength = LogBufferDescriptor.termLength(logMetaDataBuffer);
                int pageSize = LogBufferDescriptor.pageSize(logMetaDataBuffer);
                LogBufferDescriptor.checkPageSize(pageSize);
                if (metaDataTermLength != 0x40000000) {
                    throw new IllegalStateException("assumed term length 1073741824 does not match metadata: termLength=" + metaDataTermLength);
                }
                termLength = 0x40000000;
                for (int i = 0; i < 3; ++i) {
                    long position = 0x40000000L * (long)i;
                    MappedByteBuffer mappedBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, position, 0x40000000L);
                    mappedBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    mappedByteBuffers[i] = mappedBuffer;
                    this.termBuffers[i] = mappedBuffer;
                }
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        catch (IllegalStateException ex) {
            this.close();
            throw ex;
        }
        this.termLength = termLength;
        this.fileChannel = fileChannel;
        this.logMetaDataBuffer = logMetaDataBuffer;
        this.mappedByteBuffers = mappedByteBuffers;
    }

    public UnsafeBuffer[] duplicateTermBuffers() {
        UnsafeBuffer[] buffers = new UnsafeBuffer[3];
        for (int i = 0; i < 3; ++i) {
            buffers[i] = new UnsafeBuffer(this.termBuffers[i].duplicate().order(ByteOrder.LITTLE_ENDIAN));
        }
        return buffers;
    }

    public UnsafeBuffer metaDataBuffer() {
        return this.logMetaDataBuffer;
    }

    public FileChannel fileChannel() {
        return this.fileChannel;
    }

    public void preTouch() {
        boolean value = false;
        int pageSize = LogBufferDescriptor.pageSize(this.logMetaDataBuffer);
        UnsafeBuffer atomicBuffer = new UnsafeBuffer();
        for (MappedByteBuffer buffer : this.mappedByteBuffers) {
            atomicBuffer.wrap((ByteBuffer)buffer);
            int length = atomicBuffer.capacity();
            for (int i = 0; i < length; i += pageSize) {
                atomicBuffer.compareAndSetInt(i, 0, 0);
            }
        }
    }

    @Override
    public void close() {
        Exception error = null;
        try {
            CloseHelper.close((AutoCloseable)this.fileChannel);
        }
        catch (Exception ex) {
            error = ex;
        }
        for (MappedByteBuffer mappedByteBuffer : this.mappedByteBuffers) {
            this.mappedByteBuffers[i] = null;
            BufferUtil.free((ByteBuffer)mappedByteBuffer);
        }
        this.logMetaDataBuffer.wrap(0L, 0);
        if (error != null) {
            LangUtil.rethrowUnchecked((Throwable)error);
        }
    }

    public int termLength() {
        return this.termLength;
    }

    public int incRef() {
        return ++this.refCount;
    }

    public int decRef() {
        return --this.refCount;
    }

    public void lingerDeadlineNs(long timeNs) {
        this.lingerDeadlineNs = timeNs;
    }

    public long lingerDeadlineNs() {
        return this.lingerDeadlineNs;
    }
}

