/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.model.ietf.type.util;

import com.google.common.base.Preconditions;
import org.eclipse.jdt.annotation.NonNull;

public final class Ipv4Utils {
    public static final int INET4_LENGTH = 4;

    private Ipv4Utils() {
    }

    public static void fillIpv4Bytes(byte @NonNull [] bytes, int byteStart, String str, int strStart, int strLimit) {
        int out = byteStart;
        int val = 0;
        for (int i = strStart; i < strLimit; ++i) {
            char c = str.charAt(i);
            if (c == '.') {
                bytes[out++] = (byte)val;
                val = 0;
                continue;
            }
            val = 10 * val + c - 48;
        }
        bytes[out] = (byte)val;
    }

    public static int addressBits(String str, int limit) {
        int prev = 0;
        int current = 0;
        for (int i = 0; i < limit; ++i) {
            char c = str.charAt(i);
            if (c == '.') {
                prev = prev << 8 | current;
                current = 0;
                continue;
            }
            current = 10 * current + c - 48;
        }
        return prev << 8 | current;
    }

    public static byte @NonNull [] addressBytes(String str, int limit) {
        byte[] bytes = new byte[4];
        Ipv4Utils.fillIpv4Bytes(bytes, 0, str, 0, limit);
        return bytes;
    }

    public static String addressString(int bits) {
        return (bits >>> 24) + "." + (bits >>> 16 & 0xFF) + "." + (bits >>> 8 & 0xFF) + "." + (bits & 0xFF);
    }

    public static String addressString(byte @NonNull [] bytes) {
        StringBuilder sb = new StringBuilder(15);
        Ipv4Utils.appendIpv4String(sb, bytes);
        return sb.toString();
    }

    public static void appendIpv4String(StringBuilder sb, byte @NonNull [] bytes) {
        Preconditions.checkArgument((bytes.length == 4 ? 1 : 0) != 0, (Object)"IPv4 address length is 4 bytes");
        sb.append(Byte.toUnsignedInt(bytes[0]));
        for (int i = 1; i < 4; ++i) {
            sb.append('.').append(Byte.toUnsignedInt(bytes[i]));
        }
    }
}

