/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.model.ietf.type.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Arrays;
import java.util.HexFormat;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.model.ietf.type.util.Ipv4Utils;

public final class Ipv6Utils {
    public static final int INET6_LENGTH = 16;

    private Ipv6Utils() {
    }

    public static void fillIpv6Bytes(byte @NonNull [] bytes, String str, int strLimit) {
        int i = 0;
        if (str.charAt(i) == ':') {
            Preconditions.checkArgument((str.charAt(++i) == ':' ? 1 : 0) != 0, (String)"Invalid v6 address '%s'", (Object)str);
        }
        boolean haveVal = false;
        int val = 0;
        int colonp = -1;
        int j = 0;
        int curtok = i;
        while (i < strLimit) {
            char ch;
            if ((ch = str.charAt(i++)) == ':') {
                curtok = i;
                if (haveVal) {
                    bytes[j++] = (byte)(val >>> 8 & 0xFF);
                    bytes[j++] = (byte)(val & 0xFF);
                    haveVal = false;
                    val = 0;
                    continue;
                }
                colonp = j;
                continue;
            }
            if (ch == '.' && j + 4 <= 16) {
                Ipv4Utils.fillIpv4Bytes(bytes, j, str, curtok, strLimit);
                j += 4;
                haveVal = false;
                break;
            }
            val = (val << 4) + HexFormat.fromHexDigit(ch);
            haveVal = true;
        }
        if (haveVal) {
            Ipv6Utils.verifySize(j + 2 <= 16, str);
            bytes[j++] = (byte)(val >> 8 & 0xFF);
            bytes[j++] = (byte)(val & 0xFF);
        }
        if (colonp != -1) {
            Ipv6Utils.verifySize(j != 16, str);
            Ipv6Utils.expandZeros(bytes, colonp, j);
        } else {
            Ipv6Utils.verifySize(j == 16, str);
        }
    }

    private static void verifySize(boolean expression, String str) {
        Verify.verify((boolean)expression, (String)"Overrun in parsing of '%s', should not occur", (Object)str);
    }

    private static void expandZeros(byte[] bytes, int where, int filledBytes) {
        int tailLength = filledBytes - where;
        int tailOffset = 16 - tailLength;
        System.arraycopy(bytes, where, bytes, tailOffset, tailLength);
        Arrays.fill(bytes, where, tailOffset, (byte)0);
    }
}

