/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.ri.type;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.ri.type.BitImpl;

@Beta
public final class BitBuilder
implements Mutable {
    private final String name;
    private final Uint32 position;
    private ImmutableList<UnknownSchemaNode> unknownSchemaNodes = ImmutableList.of();
    private Status status = Status.CURRENT;
    private String description;
    private String reference;

    private BitBuilder(String name, Uint32 position) {
        this.name = Objects.requireNonNull(name);
        this.position = Objects.requireNonNull(position);
    }

    public static @NonNull BitBuilder create(String name, Uint32 position) {
        return new BitBuilder(name, position);
    }

    public @NonNull BitBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public @NonNull BitBuilder setReference(String reference) {
        this.reference = reference;
        return this;
    }

    public @NonNull BitBuilder setStatus(Status status) {
        this.status = Objects.requireNonNull(status);
        return this;
    }

    public @NonNull BitBuilder setUnknownSchemaNodes(Collection<UnknownSchemaNode> unknownSchemaNodes) {
        this.unknownSchemaNodes = ImmutableList.copyOf(unknownSchemaNodes);
        return this;
    }

    public @NonNull BitBuilder setUnknownSchemaNodes(UnknownSchemaNode ... unknownSchemaNodes) {
        this.unknownSchemaNodes = ImmutableList.copyOf((Object[])unknownSchemaNodes);
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull BitsTypeDefinition.Bit build() {
        return new BitImpl(this.name, this.position, this.description, this.reference, this.status, (List<UnknownSchemaNode>)this.unknownSchemaNodes);
    }
}

