/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.ri.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.function.Function;
import org.opendaylight.yangtools.yang.common.Decimal64;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;

final class NumberUtil {
    private static final Comparator<Number> NUMBER_COMPARATOR = (o1, o2) -> {
        Preconditions.checkArgument((boolean)o1.getClass().equals(o2.getClass()), (String)"Incompatible Number classes %s and %s", o1.getClass(), o2.getClass());
        if (o1 instanceof Byte) {
            return ((Byte)o1).compareTo((Byte)o2);
        }
        if (o1 instanceof Short) {
            return ((Short)o1).compareTo((Short)o2);
        }
        if (o1 instanceof Integer) {
            return ((Integer)o1).compareTo((Integer)o2);
        }
        if (o1 instanceof Long) {
            return ((Long)o1).compareTo((Long)o2);
        }
        if (o1 instanceof Uint8) {
            return ((Uint8)o1).compareTo((Uint8)o2);
        }
        if (o1 instanceof Uint16) {
            return ((Uint16)o1).compareTo((Uint16)o2);
        }
        if (o1 instanceof Uint32) {
            return ((Uint32)o1).compareTo((Uint32)o2);
        }
        if (o1 instanceof Uint64) {
            return ((Uint64)o1).compareTo((Uint64)o2);
        }
        if (o1 instanceof Decimal64) {
            return ((Decimal64)o1).compareTo((Decimal64)o2);
        }
        throw new IllegalArgumentException("Unsupported Number class " + o1.getClass());
    };
    private static final ImmutableMap<Class<? extends Number>, Function<Number, Number>> CONVERTERS;

    private NumberUtil() {
    }

    static <T extends Number> Function<Number, T> converterTo(Class<T> clazz) {
        return (Function)CONVERTERS.get(clazz);
    }

    static boolean isRangeCovered(Number min, Number max, Number superMin, Number superMax) {
        return NUMBER_COMPARATOR.compare(min, superMin) >= 0 && NUMBER_COMPARATOR.compare(max, superMax) <= 0;
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        b.put(Byte.class, input -> {
            if (input instanceof Byte) {
                return input;
            }
            return Byte.valueOf(input.toString());
        });
        b.put(Short.class, input -> {
            if (input instanceof Short) {
                return input;
            }
            if (input instanceof Byte) {
                return input.shortValue();
            }
            return Short.valueOf(input.toString());
        });
        b.put(Integer.class, input -> {
            if (input instanceof Integer) {
                return input;
            }
            if (input instanceof Byte || input instanceof Short) {
                return input.intValue();
            }
            return Integer.valueOf(input.toString());
        });
        b.put(Long.class, input -> {
            if (input instanceof Long) {
                return input;
            }
            if (input instanceof Byte || input instanceof Short || input instanceof Integer) {
                return input.longValue();
            }
            return Long.valueOf(input.toString());
        });
        b.put(Decimal64.class, input -> {
            if (input instanceof Decimal64) {
                return input;
            }
            if (input instanceof Byte || input instanceof Short || input instanceof Integer || input instanceof Long) {
                return Decimal64.valueOf((int)1, (long)input.longValue());
            }
            return Decimal64.valueOf((String)input.toString());
        });
        b.put(Uint8.class, input -> {
            if (input instanceof Uint8) {
                return input;
            }
            if (input instanceof Byte || input instanceof Short || input instanceof Integer || input instanceof Long || input instanceof Uint16 || input instanceof Uint32 || input instanceof Uint64) {
                return Uint8.valueOf((long)input.longValue());
            }
            return Uint8.valueOf((String)input.toString());
        });
        b.put(Uint16.class, input -> {
            if (input instanceof Uint16) {
                return input;
            }
            if (input instanceof Byte || input instanceof Short || input instanceof Integer || input instanceof Long || input instanceof Uint8 || input instanceof Uint32 || input instanceof Uint64) {
                return Uint16.valueOf((long)input.longValue());
            }
            return Uint16.valueOf((String)input.toString());
        });
        b.put(Uint32.class, input -> {
            if (input instanceof Uint32) {
                return input;
            }
            if (input instanceof Byte || input instanceof Short || input instanceof Integer || input instanceof Long || input instanceof Uint8 || input instanceof Uint16 || input instanceof Uint64) {
                return Uint32.valueOf((long)input.longValue());
            }
            return Uint32.valueOf((String)input.toString());
        });
        b.put(Uint64.class, input -> {
            if (input instanceof Uint64) {
                return input;
            }
            if (input instanceof Byte || input instanceof Short || input instanceof Integer || input instanceof Long || input instanceof Uint8 || input instanceof Uint16 || input instanceof Uint32) {
                return Uint64.valueOf((long)input.longValue());
            }
            return Uint64.valueOf((String)input.toString());
        });
        CONVERTERS = b.build();
    }
}

