/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.profile.assembly;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.features.FeaturePattern;
import org.apache.karaf.features.internal.model.Dependency;
import org.apache.karaf.features.internal.model.Feature;
import org.apache.karaf.features.internal.model.Features;
import org.apache.karaf.features.internal.service.FeatureReq;

public class FeatureSelector {
    private final Set<Feature> allFeatures;
    Map<String, Set<Feature>> featuresCache;

    public FeatureSelector(Set<Feature> features) {
        this.allFeatures = features;
        this.featuresCache = new HashMap<String, Set<Feature>>();
        for (Feature feature : features) {
            this.featuresCache.computeIfAbsent(feature.getName(), fn -> new HashSet()).add(feature);
        }
    }

    public static Collection<String> getMatchingFeatures(String idOrPattern, Collection<Features> repositories) {
        LinkedList<String> result = new LinkedList<String>();
        FeaturePattern pattern = new FeaturePattern(idOrPattern);
        for (Features features : repositories) {
            for (Feature feature : features.getFeature()) {
                if (!pattern.matches(feature.getName(), feature.getVersion())) continue;
                result.add(feature.getId());
            }
        }
        return result;
    }

    public static Collection<String> getMatchingFeatures(FeaturePattern idOrPattern, Collection<Feature> features) {
        LinkedList<String> result = new LinkedList<String>();
        for (Feature feature : features) {
            if (!idOrPattern.matches(feature.getName(), feature.getVersion())) continue;
            result.add(feature.getId());
        }
        return result;
    }

    public Set<Feature> getMatching(List<String> features) {
        HashSet<Feature> selected = new HashSet<Feature>();
        for (String feature : features) {
            for (String featureId : FeatureSelector.getMatchingFeatures(new FeaturePattern(feature), this.allFeatures)) {
                this.addFeatures(featureId, selected, true);
            }
        }
        return selected;
    }

    private void addFeatures(String feature, Set<Feature> features, boolean mandatory) {
        Set<Feature> set = this.getMatching(feature);
        if (mandatory && set.isEmpty()) {
            throw new IllegalStateException("Could not find matching feature for " + feature);
        }
        for (Feature f : set) {
            if (!features.add(f)) continue;
            for (Dependency dep : f.getFeature()) {
                if (dep.isBlacklisted()) continue;
                this.addFeatures(dep.toString(), features, this.isMandatory(dep));
            }
        }
    }

    private boolean isMandatory(Dependency dep) {
        return !dep.isDependency() && !dep.isPrerequisite();
    }

    private Set<Feature> getMatching(String nameAndVersion) {
        FeatureReq req = new FeatureReq(nameAndVersion);
        Set<Feature> versionToFeatures = this.featuresCache.get(req.getName());
        if (versionToFeatures == null) {
            return Collections.emptySet();
        }
        return versionToFeatures.stream().filter(f -> f.getName().equals(req.getName()) && req.getVersionRange().contains(VersionTable.getVersion(f.getVersion()))).collect(Collectors.toSet());
    }
}

