/*
 * Decompiled with CFR 0.152.
 */
package rpcbenchmark.impl;

import com.google.common.base.Verify;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.mdsal.binding.api.RpcConsumerRegistry;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.rpcbench.rpc.routes.RpcRoute;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.rpcbench.rpc.routes.RpcRouteKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.RpcbenchmarkService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.StartTestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.StartTestOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.StartTestOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.TestStatusInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.TestStatusOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.TestStatusOutputBuilder;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.RequireServiceComponentRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rpcbenchmark.impl.GlobalBindingRTCClient;
import rpcbenchmark.impl.GlobalBindingRTCServer;
import rpcbenchmark.impl.RTCClient;
import rpcbenchmark.impl.RoutedBindingRTCServer;
import rpcbenchmark.impl.RoutedBindingRTClient;

@Singleton
@Component(service={})
@RequireServiceComponentRuntime
public final class RpcbenchmarkProvider
implements AutoCloseable,
RpcbenchmarkService {
    private static final Logger LOG = LoggerFactory.getLogger(RpcbenchmarkProvider.class);
    private static final int TEST_TIMEOUT = 5;
    private final AtomicReference<TestStatusOutput.ExecStatus> execStatus = new AtomicReference<TestStatusOutput.ExecStatus>(TestStatusOutput.ExecStatus.Idle);
    private final RpcProviderService providerRegistry;
    private final RpcConsumerRegistry consumerRegistry;
    private final GlobalBindingRTCServer globalServer;
    private final Registration reg;

    @Inject
    @Activate
    public RpcbenchmarkProvider(@Reference RpcProviderService providerRegistry, @Reference RpcConsumerRegistry consumerRegistry) {
        this.providerRegistry = Objects.requireNonNull(providerRegistry);
        this.consumerRegistry = Objects.requireNonNull(consumerRegistry);
        this.globalServer = new GlobalBindingRTCServer(providerRegistry);
        this.reg = providerRegistry.registerRpcImplementation(RpcbenchmarkService.class, (RpcService)this);
        LOG.info("RpcbenchmarkProvider initiated");
    }

    @Override
    @PreDestroy
    @Deactivate
    public void close() {
        this.globalServer.close();
        this.reg.close();
        LOG.info("RpcbenchmarkProvider closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<RpcResult<StartTestOutput>> startTest(StartTestInput input) {
        LOG.debug("startTest {}", (Object)input);
        RoutedBindingRTCServer routed = null;
        RTCClient client = switch (input.getOperation()) {
            case StartTestInput.Operation.ROUTEDRTC -> {
                ArrayList routeIid = new ArrayList();
                for (int i = 0; i < input.getNumServers().intValue(); ++i) {
                    routeIid.add((InstanceIdentifier<?>)InstanceIdentifier.create(RpcbenchRpcRoutes.class).child(RpcRoute.class, (Key)new RpcRouteKey(Integer.toString(i))));
                }
                routed = new RoutedBindingRTCServer(this.providerRegistry, Set.copyOf(routeIid));
                yield new RoutedBindingRTClient(this.consumerRegistry, input.getPayloadSize().intValue(), routeIid);
            }
            case StartTestInput.Operation.GLOBALRTC -> new GlobalBindingRTCClient(this.consumerRegistry, input.getPayloadSize().intValue());
            default -> {
                LOG.error("Unsupported server/client type {}", (Object)input.getOperation());
                throw new IllegalArgumentException("Unsupported server/client type" + input.getOperation());
            }
        };
        try {
            ExecutorService executor = Executors.newFixedThreadPool(input.getNumClients().intValue());
            Runnable testRun = () -> client.runTest(input.getIterations().intValue());
            LOG.info("Test Started");
            long startTime = System.nanoTime();
            for (int i = 0; i < input.getNumClients().intValue(); ++i) {
                Verify.verifyNotNull(executor.submit(testRun));
            }
            executor.shutdown();
            try {
                executor.awaitTermination(5L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                LOG.error("Out of time: test did not finish within the {} min deadline ", (Object)5);
            }
            long endTime = System.nanoTime();
            LOG.info("Test Done");
            long elapsedTime = endTime - startTime;
            StartTestOutput output = new StartTestOutputBuilder().setRate(Uint32.ZERO).setGlobalRtcClientError(Uint32.valueOf((long)client.getRpcError())).setGlobalRtcClientOk(Uint32.valueOf((long)client.getRpcOk())).setExecTime(Uint32.valueOf((long)TimeUnit.NANOSECONDS.toMillis(elapsedTime))).setRate(Uint32.valueOf((long)((client.getRpcOk() + client.getRpcError()) * 1000000000L / elapsedTime))).build();
            FluentFuture fluentFuture = RpcResultBuilder.success((Object)output).buildFuture();
            return fluentFuture;
        }
        finally {
            if (routed != null) {
                routed.close();
            }
        }
    }

    public ListenableFuture<RpcResult<TestStatusOutput>> testStatus(TestStatusInput input) {
        LOG.info("testStatus");
        TestStatusOutput output = new TestStatusOutputBuilder().setGlobalServerCnt(Uint32.valueOf((int)this.globalServer.getNumRpcs())).setExecStatus(this.execStatus.get()).build();
        return RpcResultBuilder.success((Object)output).buildFuture();
    }
}

