/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.runtime.spi;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeGenerator;
import org.opendaylight.mdsal.binding.runtime.api.DefaultBindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.api.ModuleInfoSnapshot;
import org.opendaylight.mdsal.binding.runtime.spi.ModuleInfoSnapshotBuilder;
import org.opendaylight.mdsal.binding.runtime.spi.ServiceLoaderState;
import org.opendaylight.yangtools.yang.binding.YangModelBindingProvider;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.binding.contract.Naming;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.parser.api.YangParserException;
import org.opendaylight.yangtools.yang.parser.api.YangParserFactory;

@Beta
public final class BindingRuntimeHelpers {
    private BindingRuntimeHelpers() {
    }

    public static @NonNull EffectiveModelContext createEffectiveModel(Class<?> ... classes) {
        return BindingRuntimeHelpers.createEffectiveModel(Arrays.stream(classes).map(BindingRuntimeHelpers::getYangModuleInfo).collect(Collectors.toList()));
    }

    public static @NonNull EffectiveModelContext createEffectiveModel(Iterable<? extends YangModuleInfo> moduleInfos) {
        try {
            return BindingRuntimeHelpers.createEffectiveModel(ServiceLoaderState.ParserFactory.INSTANCE, moduleInfos);
        }
        catch (YangParserException e) {
            throw new IllegalStateException("Failed to parse models", e);
        }
    }

    public static @NonNull EffectiveModelContext createEffectiveModel(YangParserFactory parserFactory, Iterable<? extends YangModuleInfo> moduleInfos) throws YangParserException {
        return BindingRuntimeHelpers.prepareContext(parserFactory, moduleInfos).getEffectiveModelContext();
    }

    public static @NonNull BindingRuntimeContext createRuntimeContext() {
        ModuleInfoSnapshot infos;
        try {
            infos = BindingRuntimeHelpers.prepareContext(ServiceLoaderState.ParserFactory.INSTANCE, BindingRuntimeHelpers.loadModuleInfos());
        }
        catch (YangParserException e) {
            throw new IllegalStateException("Failed to parse models", e);
        }
        return new DefaultBindingRuntimeContext(ServiceLoaderState.Generator.INSTANCE.generateTypeMapping(infos.getEffectiveModelContext()), infos);
    }

    public static @NonNull BindingRuntimeContext createRuntimeContext(Class<?> ... classes) {
        try {
            return BindingRuntimeHelpers.createRuntimeContext(ServiceLoaderState.ParserFactory.INSTANCE, ServiceLoaderState.Generator.INSTANCE, classes);
        }
        catch (YangParserException e) {
            throw new IllegalStateException("Failed to parse models", e);
        }
    }

    public static @NonNull BindingRuntimeContext createRuntimeContext(Collection<? extends YangModuleInfo> infos) {
        ModuleInfoSnapshot snapshot;
        try {
            snapshot = BindingRuntimeHelpers.prepareContext(ServiceLoaderState.ParserFactory.INSTANCE, infos);
        }
        catch (YangParserException e) {
            throw new IllegalStateException("Failed to parse models", e);
        }
        return new DefaultBindingRuntimeContext(ServiceLoaderState.Generator.INSTANCE.generateTypeMapping(snapshot.getEffectiveModelContext()), snapshot);
    }

    public static @NonNull BindingRuntimeContext createRuntimeContext(YangParserFactory parserFactory, BindingRuntimeGenerator generator, Class<?> ... classes) throws YangParserException {
        return BindingRuntimeHelpers.createRuntimeContext(parserFactory, generator, Arrays.asList(classes));
    }

    public static @NonNull BindingRuntimeContext createRuntimeContext(YangParserFactory parserFactory, BindingRuntimeGenerator generator, Collection<Class<?>> classes) throws YangParserException {
        ModuleInfoSnapshot infos = BindingRuntimeHelpers.prepareContext(parserFactory, classes.stream().map(BindingRuntimeHelpers::getYangModuleInfo).collect(Collectors.toList()));
        return new DefaultBindingRuntimeContext(generator.generateTypeMapping(infos.getEffectiveModelContext()), infos);
    }

    public static @NonNull YangModuleInfo getYangModuleInfo(Class<?> clazz) {
        String modelPackage = Naming.getModelRootPackageName((String)clazz.getPackage().getName());
        for (YangModelBindingProvider bindingProvider : ServiceLoader.load(YangModelBindingProvider.class, clazz.getClassLoader())) {
            YangModuleInfo moduleInfo = bindingProvider.getModuleInfo();
            if (!modelPackage.equals(moduleInfo.getClass().getPackage().getName())) continue;
            return moduleInfo;
        }
        throw new IllegalStateException("Failed to find YangModuleInfo in package " + modelPackage + " for " + clazz);
    }

    public static @NonNull ImmutableSet<YangModuleInfo> loadModuleInfos() {
        return BindingRuntimeHelpers.loadModuleInfos(Thread.currentThread().getContextClassLoader());
    }

    public static @NonNull ImmutableSet<YangModuleInfo> loadModuleInfos(ClassLoader classLoader) {
        ImmutableSet.Builder moduleInfoSet = ImmutableSet.builder();
        for (YangModelBindingProvider bindingProvider : ServiceLoader.load(YangModelBindingProvider.class, classLoader)) {
            YangModuleInfo moduleInfo = bindingProvider.getModuleInfo();
            Preconditions.checkState((moduleInfo != null ? 1 : 0) != 0, (String)"Module Info for %s is not available.", bindingProvider.getClass());
            BindingRuntimeHelpers.collectYangModuleInfo(bindingProvider.getModuleInfo(), (ImmutableSet.Builder<YangModuleInfo>)moduleInfoSet);
        }
        return moduleInfoSet.build();
    }

    private static void collectYangModuleInfo(YangModuleInfo moduleInfo, ImmutableSet.Builder<YangModuleInfo> moduleInfoSet) {
        moduleInfoSet.add((Object)moduleInfo);
        for (YangModuleInfo dependency : moduleInfo.getImportedModules()) {
            BindingRuntimeHelpers.collectYangModuleInfo(dependency, moduleInfoSet);
        }
    }

    private static @NonNull ModuleInfoSnapshot prepareContext(YangParserFactory parserFactory, Iterable<? extends YangModuleInfo> moduleInfos) throws YangParserException {
        return new ModuleInfoSnapshotBuilder(parserFactory).add(moduleInfos).build();
    }
}

