/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.api;

import com.google.common.base.MoreObjects;
import com.google.common.io.CharSource;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;

final class DelegatedYangTextSchemaSource
extends YangTextSchemaSource
implements Delegator<CharSource> {
    private final @NonNull CharSource delegate;

    DelegatedYangTextSchemaSource(SourceIdentifier identifier, CharSource delegate) {
        super(identifier);
        this.delegate = Objects.requireNonNull(delegate);
    }

    public CharSource getDelegate() {
        return this.delegate;
    }

    public Reader openStream() throws IOException {
        return this.delegate.openStream();
    }

    @Override
    public Optional<String> getSymbolicName() {
        return Optional.of("[" + this.delegate.toString() + "]");
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("delegate", (Object)this.delegate);
    }
}

