/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.api;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;

final class ResourceYangTextSchemaSource
extends YangTextSchemaSource
implements Delegator<URL> {
    private final @NonNull URL url;
    private final @NonNull Charset charset;

    ResourceYangTextSchemaSource(SourceIdentifier identifier, URL url, Charset charset) {
        super(identifier);
        this.url = Objects.requireNonNull(url);
        this.charset = Objects.requireNonNull(charset);
    }

    public URL getDelegate() {
        return this.url;
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("url", (Object)this.url);
    }

    public Reader openStream() throws IOException {
        return new InputStreamReader(this.url.openStream(), this.charset);
    }

    @Override
    public Optional<String> getSymbolicName() {
        return Optional.of(this.url.toString());
    }
}

