/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.api;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.stmt.FeatureSet;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceFilter;
import org.opendaylight.yangtools.yang.model.repo.api.StatementParserMode;

@Beta
public final class SchemaContextFactoryConfiguration
implements Immutable {
    private static final @NonNull SchemaContextFactoryConfiguration DEFAULT_CONFIGURATION = new Builder().build();
    private final @NonNull SchemaSourceFilter filter;
    private final @NonNull StatementParserMode statementParserMode;
    private final @Nullable FeatureSet supportedFeatures;
    private final @Nullable ImmutableSetMultimap<QNameModule, QNameModule> modulesDeviatedByModules;

    private SchemaContextFactoryConfiguration(@NonNull SchemaSourceFilter filter, @NonNull StatementParserMode statementParserMode, @Nullable FeatureSet supportedFeatures, @Nullable ImmutableSetMultimap<QNameModule, QNameModule> modulesDeviatedByModules) {
        this.filter = Objects.requireNonNull(filter);
        this.statementParserMode = Objects.requireNonNull(statementParserMode);
        this.supportedFeatures = supportedFeatures;
        this.modulesDeviatedByModules = modulesDeviatedByModules;
    }

    public @NonNull SchemaSourceFilter getSchemaSourceFilter() {
        return this.filter;
    }

    public @NonNull StatementParserMode getStatementParserMode() {
        return this.statementParserMode;
    }

    public Optional<FeatureSet> getSupportedFeatures() {
        return Optional.ofNullable(this.supportedFeatures);
    }

    public Optional<SetMultimap<QNameModule, QNameModule>> getModulesDeviatedByModules() {
        return Optional.ofNullable(this.modulesDeviatedByModules);
    }

    public static @NonNull SchemaContextFactoryConfiguration getDefault() {
        return DEFAULT_CONFIGURATION;
    }

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filter, this.statementParserMode, this.supportedFeatures, this.modulesDeviatedByModules});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof SchemaContextFactoryConfiguration)) return false;
        SchemaContextFactoryConfiguration other = (SchemaContextFactoryConfiguration)obj;
        if (!this.filter.equals(other.filter)) return false;
        if (!this.statementParserMode.equals((Object)other.statementParserMode)) return false;
        if (!Objects.equals(this.supportedFeatures, other.supportedFeatures)) return false;
        if (!Objects.equals(this.modulesDeviatedByModules, other.modulesDeviatedByModules)) return false;
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("schemaSourceFilter", (Object)this.filter).add("statementParserMode", (Object)this.statementParserMode).add("supportedFeatures", (Object)this.supportedFeatures).add("modulesDeviatedByModules", this.modulesDeviatedByModules).toString();
    }

    public static class Builder
    implements Mutable {
        private @NonNull SchemaSourceFilter filter = SchemaSourceFilter.ALWAYS_ACCEPT;
        private @NonNull StatementParserMode statementParserMode = StatementParserMode.DEFAULT_MODE;
        private ImmutableSetMultimap<QNameModule, QNameModule> modulesDeviatedByModules;
        private FeatureSet supportedFeatures;

        public @NonNull Builder setFilter(@NonNull SchemaSourceFilter filter) {
            this.filter = Objects.requireNonNull(filter);
            return this;
        }

        public @NonNull Builder setStatementParserMode(@NonNull StatementParserMode statementParserMode) {
            this.statementParserMode = Objects.requireNonNull(statementParserMode);
            return this;
        }

        public @NonNull Builder setSupportedFeatures(FeatureSet supportedFeatures) {
            this.supportedFeatures = supportedFeatures;
            return this;
        }

        public @NonNull Builder setModulesDeviatedByModules(@Nullable SetMultimap<QNameModule, QNameModule> modulesDeviatedByModules) {
            this.modulesDeviatedByModules = modulesDeviatedByModules != null ? ImmutableSetMultimap.copyOf(modulesDeviatedByModules) : null;
            return this;
        }

        public @NonNull SchemaContextFactoryConfiguration build() {
            return new SchemaContextFactoryConfiguration(this.filter, this.statementParserMode, this.supportedFeatures, this.modulesDeviatedByModules);
        }
    }
}

