/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.api;

import java.io.Reader;
import java.io.StringReader;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;

public class StringYangTextSchemaSource
extends YangTextSchemaSource {
    private final @Nullable String symbolicName;
    private final @NonNull String content;

    public StringYangTextSchemaSource(SourceIdentifier identifier, String content) {
        this(identifier, content, null);
    }

    public StringYangTextSchemaSource(SourceIdentifier identifier, String content, @Nullable String symbolicName) {
        super(identifier);
        this.content = Objects.requireNonNull(content);
        this.symbolicName = symbolicName;
    }

    @Override
    public final Optional<String> getSymbolicName() {
        return Optional.ofNullable(this.symbolicName);
    }

    public final Reader openStream() {
        return new StringReader(this.content);
    }
}

