/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.api;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;

final class YangTextFileSchemaSource
extends YangTextSchemaSource
implements Delegator<Path> {
    private final @NonNull Path path;
    private final @NonNull Charset charset;

    YangTextFileSchemaSource(SourceIdentifier identifier, Path path, Charset charset) {
        super(identifier);
        this.path = Objects.requireNonNull(path);
        this.charset = Objects.requireNonNull(charset);
    }

    public Path getDelegate() {
        return this.path;
    }

    public Reader openStream() throws IOException {
        return new InputStreamReader(Files.newInputStream(this.path, new OpenOption[0]), this.charset);
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("path", (Object)this.path);
    }

    @Override
    public Optional<String> getSymbolicName() {
        return Optional.of(this.path.toString());
    }
}

