/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.concepts.WritableObject;
import org.opendaylight.yangtools.yang.common.QNameModule;

@NonNullByDefault
public record YangDataName(QNameModule module, String name) implements Identifier,
WritableObject
{
    private static final long serialVersionUID = 1L;
    private static final Interner<YangDataName> INTERNER = Interners.newWeakInterner();

    public YangDataName {
        Objects.requireNonNull(module);
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name must not be empty");
    }

    public YangDataName intern() {
        QNameModule cacheMod = this.module.intern();
        YangDataName template = cacheMod == this.module ? this : new YangDataName(cacheMod, this.name.intern());
        return (YangDataName)INTERNER.intern((Object)template);
    }

    public static YangDataName readFrom(DataInput in) throws IOException {
        return new YangDataName(QNameModule.readFrom(in), in.readUTF());
    }

    public void writeTo(DataOutput out) throws IOException {
        this.module.writeTo(out);
        out.writeUTF(this.name);
    }
}

