/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public enum YangVersion {
    VERSION_1("1", "RFC6020"),
    VERSION_1_1("1.1", "RFC7950");

    private final @NonNull String str;
    private final @NonNull String reference;

    private YangVersion(String str, String reference) {
        this.str = Objects.requireNonNull(str);
        this.reference = Objects.requireNonNull(reference);
    }

    public static @Nullable YangVersion forString(@NonNull String str) {
        return switch (Objects.requireNonNull(str)) {
            case "1" -> VERSION_1;
            case "1.1" -> VERSION_1_1;
            default -> null;
        };
    }

    public static @NonNull YangVersion ofString(@NonNull String str) {
        YangVersion ret = YangVersion.forString(str);
        if (ret != null) {
            return ret;
        }
        throw new IllegalArgumentException("Invalid YANG version " + str);
    }

    @Deprecated
    public static Optional<YangVersion> parse(@NonNull String str) {
        return Optional.ofNullable(YangVersion.forString(str));
    }

    public @NonNull String reference() {
        return this.reference;
    }

    @Deprecated(since="11.0.0", forRemoval=true)
    public @NonNull String getReference() {
        return this.reference;
    }

    public @NonNull String toString() {
        return this.str;
    }
}

