/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.loader;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.security.AccessController;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.loader.BindingClassLoader;
import org.opendaylight.mdsal.binding.loader.LeafBindingClassLoader;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RootBindingClassLoader
extends BindingClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(RootBindingClassLoader.class);
    private static final VarHandle LOADERS;
    private volatile ImmutableMap<ClassLoader, BindingClassLoader> loaders = ImmutableMap.of();

    RootBindingClassLoader(ClassLoader parentLoader, @Nullable File dumpDir) {
        super(parentLoader, dumpDir);
    }

    @Override
    BindingClassLoader findClassLoader(Class<?> bindingClass) {
        BindingClassLoader found;
        ClassLoader target = bindingClass.getClassLoader();
        if (target == null) {
            return this;
        }
        ImmutableMap local = this.loaders;
        BindingClassLoader known = (BindingClassLoader)local.get((Object)target);
        if (known != null) {
            return known;
        }
        if (!this.isOurClass(bindingClass)) {
            RootBindingClassLoader.verifyStaticLinkage(target);
            found = AccessController.doPrivileged(() -> new LeafBindingClassLoader(this, target));
        } else {
            found = this;
        }
        ImmutableMap updated;
        ImmutableMap witness;
        while ((witness = LOADERS.compareAndExchange(this, local, updated = ImmutableMap.builderWithExpectedSize((int)(local.size() + 1)).putAll(local).put((Object)target, (Object)found).build())) != updated) {
            BindingClassLoader recheck = (BindingClassLoader)witness.get((Object)target);
            if (recheck != null) {
                return recheck;
            }
            local = witness;
        }
        return found;
    }

    @Override
    void appendLoaders(Set<LeafBindingClassLoader> newLoaders) {
        throw new IllegalStateException("Attempted to extend root loader with " + newLoaders);
    }

    private boolean isOurClass(Class<?> bindingClass) {
        Class<?> ourClass;
        try {
            ourClass = this.loadClass(bindingClass.getName(), false);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Failed to load {}", bindingClass, (Object)e);
            return false;
        }
        return bindingClass.equals(ourClass);
    }

    private static void verifyStaticLinkage(ClassLoader candidate) {
        Class<?> targetClazz;
        try {
            targetClazz = candidate.loadClass(DataContainer.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("ClassLoader " + candidate + " cannot load " + DataContainer.class, e);
        }
        Verify.verify((boolean)DataContainer.class.equals(targetClazz), (String)"Class mismatch on DataContainer. Ours is from %s, target %s has %s from %s", (Object)DataContainer.class.getClassLoader(), (Object)candidate, targetClazz, (Object)targetClazz.getClassLoader());
    }

    static {
        try {
            LOADERS = MethodHandles.lookup().findVarHandle(RootBindingClassLoader.class, "loaders", ImmutableMap.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
        Verify.verify((boolean)RootBindingClassLoader.registerAsParallelCapable());
    }
}

