/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.EnumMap;
import java.util.Map;
import org.opendaylight.controller.cluster.databroker.DOMBrokerReadOnlyTransaction;
import org.opendaylight.controller.cluster.databroker.DOMBrokerReadWriteTransaction;
import org.opendaylight.controller.cluster.databroker.DOMBrokerWriteOnlyTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDOMTransactionFactory<T extends DOMStoreTransactionFactory>
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDOMTransactionFactory.class);
    private static final VarHandle CLOSED;
    private final Map<LogicalDatastoreType, T> storeTxFactories;
    private volatile boolean closed;

    protected AbstractDOMTransactionFactory(Map<LogicalDatastoreType, T> txFactories) {
        this.storeTxFactories = new EnumMap<LogicalDatastoreType, T>(txFactories);
    }

    protected abstract Object newTransactionIdentifier();

    protected abstract FluentFuture<? extends CommitInfo> commit(DOMDataTreeWriteTransaction var1, DOMStoreThreePhaseCommitCohort var2);

    public final DOMDataTreeReadTransaction newReadOnlyTransaction() {
        this.checkNotClosed();
        return new DOMBrokerReadOnlyTransaction(this.newTransactionIdentifier(), this.storeTxFactories);
    }

    public final DOMDataTreeWriteTransaction newWriteOnlyTransaction() {
        this.checkNotClosed();
        return new DOMBrokerWriteOnlyTransaction(this.newTransactionIdentifier(), this.storeTxFactories, this);
    }

    public final DOMDataTreeReadWriteTransaction newReadWriteTransaction() {
        this.checkNotClosed();
        return new DOMBrokerReadWriteTransaction(this.newTransactionIdentifier(), this.storeTxFactories, this);
    }

    public final Map<LogicalDatastoreType, T> getTxFactories() {
        return this.storeTxFactories;
    }

    protected final void checkNotClosed() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Transaction factory was closed. No further operations allowed.");
    }

    @Override
    public void close() {
        if (!CLOSED.compareAndSet(this, false, true)) {
            LOG.warn("Transaction factory was already closed", new Throwable());
        }
    }

    static {
        try {
            CLOSED = MethodHandles.lookup().findVarHandle(AbstractDOMTransactionFactory.class, "closed", Boolean.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

