/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.util.Timeout;
import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedLong;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.client.BackendInfoResolver;
import org.opendaylight.controller.cluster.access.commands.ConnectClientRequest;
import org.opendaylight.controller.cluster.access.commands.ConnectClientSuccess;
import org.opendaylight.controller.cluster.access.commands.NotLeaderException;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.RequestFailure;
import org.opendaylight.controller.cluster.common.actor.ExplicitAsk;
import org.opendaylight.controller.cluster.databroker.actors.dds.ShardBackendInfo;
import org.opendaylight.controller.cluster.datastore.exceptions.NoShardLeaderException;
import org.opendaylight.controller.cluster.datastore.exceptions.NotInitializedException;
import org.opendaylight.controller.cluster.datastore.exceptions.PrimaryNotFoundException;
import org.opendaylight.controller.cluster.datastore.messages.PrimaryShardInfo;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.yangtools.concepts.Registration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.compat.java8.FutureConverters;
import scala.concurrent.Future;

abstract class AbstractShardBackendResolver
extends BackendInfoResolver<ShardBackendInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractShardBackendResolver.class);
    private static final Timeout CONNECT_TIMEOUT = Timeout.apply((long)5L, (TimeUnit)TimeUnit.SECONDS);
    private final AtomicLong nextSessionId = new AtomicLong();
    private final Function1<ActorRef, ?> connectFunction;
    private final ActorUtils actorUtils;
    private final Set<Consumer<Long>> staleBackendInfoCallbacks = ConcurrentHashMap.newKeySet();

    AbstractShardBackendResolver(ClientIdentifier clientId, ActorUtils actorUtils) {
        this.actorUtils = Objects.requireNonNull(actorUtils);
        this.connectFunction = ExplicitAsk.toScala(t -> new ConnectClientRequest(clientId, t, ABIVersion.POTASSIUM, ABIVersion.current()));
    }

    public Registration notifyWhenBackendInfoIsStale(Consumer<Long> callback) {
        this.staleBackendInfoCallbacks.add(callback);
        return () -> this.staleBackendInfoCallbacks.remove(callback);
    }

    protected void notifyStaleBackendInfoCallbacks(Long cookie) {
        this.staleBackendInfoCallbacks.forEach(callback -> callback.accept(cookie));
    }

    protected ActorUtils actorUtils() {
        return this.actorUtils;
    }

    protected final void flushCache(String shardName) {
        this.actorUtils.getPrimaryShardInfoCache().remove(shardName);
    }

    protected final ShardState resolveBackendInfo(String shardName, long cookie) {
        LOG.debug("Resolving cookie {} to shard {}", (Object)cookie, (Object)shardName);
        CompletableFuture<ShardBackendInfo> future = new CompletableFuture<ShardBackendInfo>();
        FutureConverters.toJava(this.actorUtils.findPrimaryShardAsync(shardName)).whenComplete((info, failure) -> {
            if (failure == null) {
                this.connectShard(shardName, cookie, (PrimaryShardInfo)info, future);
                return;
            }
            LOG.debug("Shard {} failed to resolve", (Object)shardName, failure);
            if (failure instanceof NoShardLeaderException) {
                future.completeExceptionally(AbstractShardBackendResolver.wrap("Shard has no current leader", failure));
            } else if (failure instanceof NotInitializedException) {
                LOG.info("Shard {} has not initialized yet", (Object)shardName);
                future.completeExceptionally((Throwable)failure);
            } else if (failure instanceof PrimaryNotFoundException) {
                LOG.info("Failed to find primary for shard {}", (Object)shardName);
                future.completeExceptionally((Throwable)failure);
            } else {
                future.completeExceptionally((Throwable)failure);
            }
        });
        return new ShardState(future);
    }

    private static TimeoutException wrap(String message, Throwable cause) {
        TimeoutException ret = new TimeoutException(message);
        ret.initCause(Objects.requireNonNull(cause));
        return ret;
    }

    private void connectShard(String shardName, long cookie, PrimaryShardInfo info, CompletableFuture<ShardBackendInfo> future) {
        LOG.debug("Shard {} resolved to {}, attempting to connect", (Object)shardName, (Object)info);
        FutureConverters.toJava((Future)ExplicitAsk.ask((ActorSelection)info.getPrimaryShardActor(), this.connectFunction, (Timeout)CONNECT_TIMEOUT)).whenComplete((response, failure) -> this.onConnectResponse(shardName, cookie, future, response, (Throwable)failure));
    }

    private void onConnectResponse(String shardName, long cookie, CompletableFuture<ShardBackendInfo> future, Object response, Throwable failure) {
        if (failure != null) {
            LOG.debug("Connect attempt to {} failed, will retry", (Object)shardName, (Object)failure);
            future.completeExceptionally(AbstractShardBackendResolver.wrap("Connection attempt failed", failure));
            return;
        }
        if (response instanceof RequestFailure) {
            Throwable cause = ((RequestFailure)response).getCause().unwrap();
            LOG.debug("Connect attempt to {} failed to process", (Object)shardName, (Object)cause);
            Throwable result = cause instanceof NotLeaderException ? AbstractShardBackendResolver.wrap("Leader moved during establishment", cause) : cause;
            future.completeExceptionally(result);
            return;
        }
        LOG.debug("Resolved backend information to {}", response);
        Preconditions.checkArgument((boolean)(response instanceof ConnectClientSuccess), (String)"Unhandled response %s", (Object)response);
        ConnectClientSuccess success = (ConnectClientSuccess)response;
        future.complete(new ShardBackendInfo(success.getBackend(), this.nextSessionId.getAndIncrement(), success.getVersion(), shardName, UnsignedLong.fromLongBits((long)cookie), success.getDataTree(), success.getMaxMessages()));
    }

    static final class ShardState {
        private final CompletionStage<ShardBackendInfo> stage;
        private @GuardedBy(value={"this"}) ShardBackendInfo result;

        ShardState(CompletionStage<ShardBackendInfo> stage) {
            this.stage = Objects.requireNonNull(stage);
            stage.whenComplete(this::onStageResolved);
        }

        @NonNull CompletionStage<ShardBackendInfo> getStage() {
            return this.stage;
        }

        synchronized @Nullable ShardBackendInfo getResult() {
            return this.result;
        }

        private synchronized void onStageResolved(ShardBackendInfo info, Throwable failure) {
            if (failure == null) {
                this.result = Objects.requireNonNull(info);
            } else {
                LOG.warn("Failed to resolve shard", failure);
            }
        }
    }
}

