/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSelection;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.OperationLimiter;
import org.opendaylight.controller.cluster.datastore.TransactionContext;
import org.opendaylight.controller.cluster.datastore.TransactionOperation;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import scala.concurrent.Future;

abstract class AbstractTransactionContextWrapper {
    private final TransactionIdentifier identifier;
    private final OperationLimiter limiter;
    private final String shardName;

    AbstractTransactionContextWrapper(@NonNull TransactionIdentifier identifier, @NonNull ActorUtils actorUtils, @NonNull String shardName) {
        this.identifier = Objects.requireNonNull(identifier);
        this.shardName = Objects.requireNonNull(shardName);
        this.limiter = new OperationLimiter(identifier, actorUtils.getDatastoreContext().getShardBatchedModificationCount() + 1, TimeUnit.MILLISECONDS.toSeconds(actorUtils.getDatastoreContext().getOperationTimeoutInMillis()));
    }

    final TransactionIdentifier getIdentifier() {
        return this.identifier;
    }

    final OperationLimiter getLimiter() {
        return this.limiter;
    }

    final String getShardName() {
        return this.shardName;
    }

    abstract @Nullable TransactionContext getTransactionContext();

    abstract void maybeExecuteTransactionOperation(TransactionOperation var1);

    abstract @NonNull Future<ActorSelection> readyTransaction(Optional<SortedSet<String>> var1);
}

